/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;

public class FileRootsVFS
extends VFS {
    public static final String PROTOCOL = "roots";
    private static FileSystemView fsView = FileSystemView.getFileSystemView();

    public FileRootsVFS() {
        super(PROTOCOL, 324, new String[]{"type"});
    }

    @Override
    public String getParentOfPath(String path) {
        return "roots:";
    }

    @Override
    public VFSFile[] _listFiles(Object session, String url, Component comp) {
        File[] roots = FileRootsVFS.listRoots();
        if (roots == null) {
            return null;
        }
        VFSFile[] rootDE = new VFSFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            rootDE[i] = new Root(roots[i]);
        }
        return rootDE;
    }

    @Override
    public VFSFile _getFile(Object session, String path, Component comp) {
        return new Root(new File(path));
    }

    private static File[] listRoots() {
        if (OperatingSystem.isMacOS()) {
            File[] volumes = new File("/Volumes").listFiles();
            LinkedList<File> roots = new LinkedList<File>();
            roots.add(new File("/"));
            for (File volume : volumes) {
                if (!volume.isDirectory()) continue;
                roots.add(volume);
            }
            return roots.toArray(new File[roots.size()]);
        }
        File[] roots = File.listRoots();
        File[] desktop = fsView.getRoots();
        if (desktop == null) {
            return roots;
        }
        File[] rootsPlus = new File[roots.length + desktop.length];
        System.arraycopy(desktop, 0, rootsPlus, 0, desktop.length);
        System.arraycopy(roots, 0, rootsPlus, 1, roots.length);
        return rootsPlus;
    }

    static class Root
    extends VFSFile {
        Root(File file) {
            String path = file.getPath();
            this.setPath(path);
            this.setDeletePath(path);
            this.setSymlinkPath(path);
            if (fsView.isFloppyDrive(file)) {
                this.setType(2);
                this.setName(path);
            } else if (fsView.isDrive(file)) {
                this.setType(2);
                this.setName(path + ' ' + fsView.getSystemDisplayName(file));
            } else if (file.isDirectory()) {
                if (fsView.isFileSystemRoot(file)) {
                    this.setType(1);
                } else {
                    this.setType(2);
                }
                if (OperatingSystem.isMacOS()) {
                    this.setName(MiscUtilities.getFileName(path));
                } else {
                    this.setName(path);
                }
            } else {
                this.setType(0);
            }
        }

        @Override
        public String getExtendedAttribute(String name) {
            if (name.equals("type")) {
                return super.getExtendedAttribute(name);
            }
            return null;
        }
    }
}

