/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.input;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public abstract class TextAreaInputHandler
extends AbstractInputHandler<JEditBeanShellAction> {
    private final TextArea textArea;

    protected TextAreaInputHandler(TextArea textArea) {
        this.textArea = textArea;
        this.bindings = this.currentBindings = new Hashtable();
    }

    @Override
    public void processKeyEvent(KeyEvent evt, int from, boolean global) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event                 : " + TextAreaInputHandler.toString(evt) + " from " + from);
        }
        if (evt.isConsumed()) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event (preprocessing) : " + TextAreaInputHandler.toString(evt));
        }
        if ((evt = KeyEventWorkaround.processKeyEvent(evt)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event after workaround: " + TextAreaInputHandler.toString(evt) + " from " + from);
        }
        boolean focusOnTextArea = false;
        switch (evt.getID()) {
            case 400: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(evt);
                } else if (this.isPrefixActive() || this.textArea.hasFocus()) {
                    this.processKeyEventKeyStrokeHandling(evt, from, "type ", global);
                }
                this.processKeyEventSub(focusOnTextArea);
                break;
            }
            case 401: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(evt);
                    break;
                }
                if (!KeyEventWorkaround.isBindable(evt.getKeyCode())) break;
                this.processKeyEventKeyStrokeHandling(evt, from, "press", global);
                this.processKeyEventSub(focusOnTextArea);
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(evt);
            }
        }
    }

    private void processKeyEventSub(boolean focusOnTextArea) {
        if (this.isPrefixActive() && focusOnTextArea) {
            this.textArea.requestFocus();
        }
    }

    protected abstract JEditBeanShellAction getAction(String var1);

    @Override
    public void invokeAction(String action) {
        this.invokeAction(this.getAction(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAction(JEditBeanShellAction action) {
        JEditBuffer buffer = this.textArea.getBuffer();
        if (!action.noRememberLast()) {
            if (this.lastAction == action) {
                ++this.lastActionCount;
            } else {
                this.lastAction = action;
                this.lastActionCount = 1;
            }
        }
        int _repeatCount = this.repeatCount;
        if (action.noRepeat() || _repeatCount == 1) {
            action.invoke(this.textArea);
        } else {
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < _repeatCount; ++i) {
                    action.invoke(this.textArea);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
        if (_repeatCount != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
        }
    }

    @Override
    public boolean handleKey(KeyEventTranslator.Key keyStroke, boolean dryRun) {
        Object o;
        char input = '\u0000';
        if (keyStroke.modifiers == null || keyStroke.modifiers.equals("S")) {
            switch (keyStroke.key) {
                case 9: 
                case 10: {
                    input = (char)keyStroke.key;
                    break;
                }
                default: {
                    input = keyStroke.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (input != '\u0000') {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.invokeReadNextChar(input);
                    this.repeatCount = 1;
                }
                return true;
            }
            if (!dryRun) {
                this.readNextChar = null;
            }
        }
        if ((o = this.currentBindings.get(keyStroke)) == null) {
            if (!dryRun) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    this.repeatCount = 1;
                    this.setCurrentBindings(this.bindings);
                } else if (input != '\u0000' && !keyStroke.isFromGlobalContext()) {
                    this.userInput(input);
                }
                this.sendShortcutPrefixOff();
            }
        } else {
            if (o instanceof Hashtable) {
                if (!dryRun) {
                    this.setCurrentBindings((Hashtable)o);
                    ShortcutPrefixActiveEvent.firePrefixStateChange(this.currentBindings, true);
                    this.shortcutOn = true;
                }
                return true;
            }
            if (o instanceof String) {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((String)o);
                }
                return true;
            }
            if (o instanceof JEditBeanShellAction) {
                if (!dryRun) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((JEditBeanShellAction)o);
                }
                return true;
            }
        }
        if (!dryRun) {
            this.sendShortcutPrefixOff();
        }
        return false;
    }

    protected void userInput(char ch) {
        this.lastActionCount = 0;
        if (this.repeatCount == 1) {
            this.textArea.userInput(ch);
        }
        this.repeatCount = 1;
    }

    protected void invokeReadNextChar(char ch) {
        int index;
        String charStr = StandardUtilities.charsToEscapes(String.valueOf(ch));
        while ((index = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, index) + '\'' + charStr + '\'' + this.readNextChar.substring(index + 8);
        }
        this.readNextChar = null;
    }
}

