/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.help.HelpHistoryModel;
import org.gjt.sp.jedit.help.HelpHistoryModelListener;
import org.gjt.sp.jedit.help.HelpSearchPanel;
import org.gjt.sp.jedit.help.HelpTOCPanel;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.help.HistoryButton;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.RegexEncodingDetector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame
implements HelpViewerInterface,
HelpHistoryModelListener {
    private static final long serialVersionUID = 1L;
    private static final RegexEncodingDetector ENCODING_DETECTOR = new RegexEncodingDetector(":encoding=([^:]+):", "$1");
    private String baseURL;
    private String shortURL;
    private final HistoryButton back;
    private final HistoryButton forward;
    private final JEditorPane viewer;
    private final JScrollPane viewerScrollPane;
    private final JLabel title;
    private final JSplitPane splitter;
    private final HelpHistoryModel historyModel;
    private final HelpTOCPanel toc;
    private boolean queuedTOCReload;

    public HelpViewer() {
        this("welcome.html");
    }

    public HelpViewer(URL url) {
        this(url.toString());
    }

    public HelpViewer(String url) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        try {
            this.baseURL = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc")).toURI().toURL().toString();
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
        }
        ActionHandler actionListener = new ActionHandler();
        JTabbedPane tabs = new JTabbedPane();
        this.toc = new HelpTOCPanel(this);
        tabs.addTab(jEdit.getProperty("helpviewer.toc.label"), this.toc);
        tabs.addTab(jEdit.getProperty("helpviewer.search.label"), new HelpSearchPanel(this));
        tabs.setMinimumSize(new Dimension(0, 0));
        JPanel rightPanel = new JPanel(new BorderLayout());
        Box toolBar = new Box(0);
        this.title = new JLabel();
        toolBar.add(this.title);
        toolBar.add(Box.createGlue());
        this.historyModel = new HelpHistoryModel(25);
        this.back = new HistoryButton(0, this.historyModel);
        this.back.addActionListener(actionListener);
        toolBar.add(this.back);
        this.forward = new HistoryButton(1, this.historyModel);
        this.forward.addActionListener(actionListener);
        toolBar.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        rightPanel.add("North", toolBar);
        this.viewer = new JEditorPane();
        this.viewer.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setFont(jEdit.getFontProperty("helpviewer.font"));
        this.viewer.addPropertyChangeListener(new PropertyChangeHandler());
        this.viewer.addKeyListener(new KeyHandler());
        this.viewer.addMouseListener(new MouseHandler());
        this.viewerScrollPane = new JScrollPane(this.viewer);
        rightPanel.add("Center", this.viewerScrollPane);
        this.splitter = new JSplitPane(1, tabs, rightPanel);
        this.splitter.setBorder(null);
        this.getContentPane().add("Center", this.splitter);
        this.historyModel.addHelpHistoryModelListener(this);
        this.historyUpdated();
        this.gotoURL(url, true, 0);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setPreferredSize(new Dimension(750, 500));
        this.pack();
        GUIUtilities.loadGeometry(this, "helpviewer");
        GUIUtilities.addSizeSaver(this, "helpviewer");
        EditBus.addToBus(this);
        this.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpViewer.this.splitter.setDividerLocation(jEdit.getIntegerProperty("helpviewer.splitter", 250));
                HelpViewer.this.viewer.requestFocus();
            }
        });
    }

    @Override
    public void gotoURL(String url, final boolean addToHistory, final int scrollPosition) {
        String shortURL;
        if (MiscUtilities.isURL(url)) {
            if (url.startsWith(this.baseURL)) {
                shortURL = url.substring(this.baseURL.length());
                if (shortURL.startsWith("/")) {
                    shortURL = shortURL.substring(1);
                }
            } else {
                shortURL = url;
            }
        } else {
            shortURL = url;
            url = this.baseURL.endsWith("/") ? this.baseURL + url : this.baseURL + '/' + url;
        }
        this.viewer.setCursor(Cursor.getDefaultCursor());
        try {
            final URL _url = new URL(url);
            final String _shortURL = shortURL;
            if (!_url.equals(this.viewer.getPage())) {
                this.title.setText(jEdit.getProperty("helpviewer.loading"));
            }
            this.historyModel.setCurrentScrollPosition(this.viewer.getPage(), this.getCurrentScrollPosition());
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                private boolean success;

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        URLConnection connection;
                        HelpViewer.this.viewer.putClientProperty("charset", null);
                        if (_url.getPath().matches(".+\\.([tT][xX][tT])") && (connection = _url.openConnection()).getContentEncoding() == null) {
                            InputStream is = connection.getInputStream();
                            BufferedInputStream in = AutoDetection.getMarkedStream(is);
                            String encoding = ENCODING_DETECTOR.detectEncoding(in);
                            if (encoding != null) {
                                HelpViewer.this.viewer.putClientProperty("charset", encoding);
                            }
                            in.close();
                        }
                        HelpViewer.this.viewer.setPage(_url);
                        this.success = true;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                        Object[] args = new String[]{_url.toString(), io.toString()};
                        GUIUtilities.error(HelpViewer.this, "read-error", args);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    if (this.success) {
                        if (scrollPosition != 0) {
                            HelpViewer.this.viewerScrollPane.getVerticalScrollBar().setValue(scrollPosition);
                        }
                        if (addToHistory) {
                            HelpViewer.this.historyModel.addToHistory(_url.toString());
                        }
                        HelpViewer.this.shortURL = _shortURL;
                        if (_shortURL != null) {
                            HelpViewer.this.toc.selectNode(_shortURL);
                        }
                        HelpViewer.this.viewer.requestFocus();
                    }
                }
            };
            worker.execute();
        }
        catch (MalformedURLException mf) {
            Log.log(9, this, mf);
            Object[] args = new String[]{url, mf.getMessage()};
            GUIUtilities.error(this, "badurl", args);
        }
    }

    int getCurrentScrollPosition() {
        return this.viewerScrollPane.getVerticalScrollBar().getValue();
    }

    URL getCurrentPage() {
        return this.viewer.getPage();
    }

    @Override
    public void dispose() {
        EditBus.removeFromBus(this);
        jEdit.setIntegerProperty("helpviewer.splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pmsg) {
        if (!(pmsg.getWhat() != PluginUpdate.LOADED && pmsg.getWhat() != PluginUpdate.UNLOADED || pmsg.isExiting())) {
            if (!this.queuedTOCReload) {
                this.queueTOCReload();
            }
            this.queuedTOCReload = true;
        }
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getShortURL() {
        return this.shortURL;
    }

    @Override
    public void historyUpdated() {
        this.back.setEnabled(this.historyModel.hasPrevious());
        this.forward.setEnabled(this.historyModel.hasNext());
    }

    @Override
    public Component getComponent() {
        return this.getRootPane();
    }

    @Override
    public void queueTOCReload() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpViewer.this.queuedTOCReload = false;
                HelpViewer.this.toc.load();
            }
        });
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.handlePopupTrigger(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.handlePopupTrigger(me);
            }
        }

        private void handlePopupTrigger(MouseEvent me) {
            AttributeSet set;
            String href;
            Object attribute;
            HTMLDocument hdoc;
            Element elem;
            int caret = HelpViewer.this.viewer.getUI().viewToModel(HelpViewer.this.viewer, me.getPoint());
            if (caret >= 0 && HelpViewer.this.viewer.getDocument() instanceof HTMLDocument && (elem = (hdoc = (HTMLDocument)HelpViewer.this.viewer.getDocument()).getCharacterElement(caret)).getAttributes().getAttribute(HTML.Tag.A) != null && (attribute = elem.getAttributes().getAttribute(HTML.Tag.A)) instanceof AttributeSet && (href = (String)(set = (AttributeSet)attribute).getAttribute(HTML.Attribute.HREF)) != null) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem copy = popup.add(jEdit.getProperty("helpviewer.copy-link.label"));
                copy.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StringSelection url = new StringSelection(href);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(url, url);
                    }
                });
                popup.show(HelpViewer.this.viewer, me.getX(), me.getY());
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            switch (ke.getKeyCode()) {
                case 38: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() - scrollBar.getUnitIncrement(-1));
                    ke.consume();
                    break;
                }
                case 40: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() + scrollBar.getUnitIncrement(1));
                    ke.consume();
                    break;
                }
                case 37: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() - scrollBar.getUnitIncrement(-1));
                    ke.consume();
                    break;
                }
                case 39: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() + scrollBar.getUnitIncrement(1));
                    ke.consume();
                    break;
                }
                case 36: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(0);
                    scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(0);
                    ke.consume();
                    break;
                }
                case 35: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                    scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                    ke.consume();
                }
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("page".equals(evt.getPropertyName())) {
                String titleStr = (String)HelpViewer.this.viewer.getDocument().getProperty("title");
                if (titleStr == null) {
                    titleStr = MiscUtilities.getFileName(HelpViewer.this.viewer.getPage().toString());
                }
                HelpViewer.this.title.setText(titleStr);
                HelpViewer.this.historyModel.updateTitle(HelpViewer.this.viewer.getPage().toString(), titleStr);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (evt instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                    HelpViewer.this.historyUpdated();
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        HelpViewer.this.gotoURL(url.toString(), true, 0);
                    }
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int scrollPosition;
            String url;
            Object source = evt.getSource();
            String actionCommand = evt.getActionCommand();
            int separatorPosition = actionCommand.lastIndexOf(58);
            if (-1 == separatorPosition) {
                url = actionCommand;
                scrollPosition = 0;
            } else {
                url = actionCommand.substring(0, separatorPosition);
                scrollPosition = Integer.parseInt(actionCommand.substring(separatorPosition + 1));
            }
            if (!url.isEmpty()) {
                HelpViewer.this.gotoURL(url, false, scrollPosition);
                return;
            }
            if (source == HelpViewer.this.back) {
                HelpHistoryModel.HistoryEntry entry = HelpViewer.this.historyModel.back(HelpViewer.this);
                if (entry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(entry.url, false, entry.scrollPosition);
                }
            } else if (source == HelpViewer.this.forward) {
                HelpHistoryModel.HistoryEntry entry = HelpViewer.this.historyModel.forward(HelpViewer.this);
                if (entry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(entry.url, false, entry.scrollPosition);
                }
            }
        }
    }
}

