/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableLayout;
import org.gjt.sp.jedit.gui.DockablePanel;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.PanelWindowContainer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DockableWindowManagerImpl
extends DockableWindowManager {
    private Map<String, Entry> windows;
    private PanelWindowContainer left;
    private PanelWindowContainer right;
    private PanelWindowContainer top;
    private PanelWindowContainer bottom;
    private List<Entry> clones;
    private Entry lastEntry;
    public Stack<String> showStack = new Stack();
    int resizePos;
    Rectangle resizeRect;
    private boolean continuousLayout;

    @Override
    public void setDockingLayout(DockableWindowManager.DockingLayout docking) {
        DockableWindowConfig config = (DockableWindowConfig)docking;
        if (config == null) {
            return;
        }
        if (config.top != null && config.top.length() != 0) {
            this.showDockableWindow(config.top);
        }
        if (config.left != null && config.left.length() != 0) {
            this.showDockableWindow(config.left);
        }
        if (config.bottom != null && config.bottom.length() != 0) {
            this.showDockableWindow(config.bottom);
        }
        if (config.right != null && config.right.length() != 0) {
            this.showDockableWindow(config.right);
        }
    }

    @Override
    public DockableWindowManager.DockingLayout getDockingLayout(View.ViewConfig config) {
        DockableWindowConfig docking = new DockableWindowConfig();
        docking.top = this.getTopDockingArea().getCurrent();
        docking.left = this.getLeftDockingArea().getCurrent();
        docking.bottom = this.getBottomDockingArea().getCurrent();
        docking.right = this.getRightDockingArea().getCurrent();
        docking.topPos = this.getTopDockingArea().getDimension();
        docking.leftPos = this.getLeftDockingArea().getDimension();
        docking.bottomPos = this.getBottomDockingArea().getDimension();
        docking.rightPos = this.getRightDockingArea().getDimension();
        return docking;
    }

    public DockableWindowManagerImpl(View view, DockableWindowFactory factory, View.ViewConfig config) {
        super(view, factory, config);
        this.setLayout(new DockableLayout());
        this.windows = new HashMap<String, Entry>();
        this.clones = new ArrayList<Entry>();
        DockableWindowConfig docking = (DockableWindowConfig)config.docking;
        if (docking == null) {
            docking = new DockableWindowConfig();
        }
        this.top = new PanelWindowContainer(this, "top", docking.topPos);
        this.left = new PanelWindowContainer(this, "left", docking.leftPos);
        this.bottom = new PanelWindowContainer(this, "bottom", docking.bottomPos);
        this.right = new PanelWindowContainer(this, "right", docking.rightPos);
        this.add("top-buttons", this.top.buttonPanel);
        this.add("left-buttons", this.left.buttonPanel);
        this.add("bottom-buttons", this.bottom.buttonPanel);
        this.add("right-buttons", this.right.buttonPanel);
        this.add("top", this.top.dockablePanel);
        this.add("left", this.left.dockablePanel);
        this.add("bottom", this.bottom.dockablePanel);
        this.add("right", this.right.dockablePanel);
    }

    @Override
    public void setMainPanel(JPanel panel) {
        this.add((Component)panel, 0);
    }

    @Override
    public void init() {
        super.init();
        Iterator<DockableWindowFactory.Window> entries = this.factory.getDockableWindowIterator();
        while (entries.hasNext()) {
            this.addEntry(entries.next());
        }
        this.propertiesChanged();
    }

    @Override
    public JComponent floatDockableWindow(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return null;
        }
        Entry newEntry = new Entry(entry.factory, "floating");
        newEntry.win = newEntry.factory.createDockableWindow(this.view, "floating");
        if (newEntry.win != null) {
            FloatingWindowContainer fwc = new FloatingWindowContainer(this, true);
            newEntry.container = fwc;
            newEntry.container.register(newEntry);
            newEntry.container.show(newEntry);
        }
        this.clones.add(newEntry);
        return newEntry.win;
    }

    @Override
    public void showDockableWindow(String name) {
        this.lastEntry = this.windows.get(name);
        if (this.lastEntry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (this.lastEntry.win == null) {
            this.lastEntry.win = this.lastEntry.factory.createDockableWindow(this.view, this.lastEntry.position);
        }
        if (this.lastEntry.win != null) {
            if (this.lastEntry.position.equals("floating") && this.lastEntry.container == null) {
                FloatingWindowContainer fwc = new FloatingWindowContainer(this, this.view.isPlainView());
                this.lastEntry.container = fwc;
                this.lastEntry.container.register(this.lastEntry);
            }
            this.showStack.push(name);
            this.lastEntry.container.show(this.lastEntry);
            Object reason = DockableWindowUpdate.ACTIVATED;
            EditBus.send(new DockableWindowUpdate(this, reason, name));
        }
    }

    @Override
    public void hideDockableWindow(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (entry.win == null) {
            return;
        }
        entry.container.show(null);
    }

    @Override
    public JComponent getDockable(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null || entry.win == null) {
            return null;
        }
        return entry.win;
    }

    @Override
    public boolean isDockableWindowVisible(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null || entry.win == null) {
            return false;
        }
        return entry.container.isVisible(entry);
    }

    @Override
    public boolean isDockableWindowDocked(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            return false;
        }
        return !entry.position.equals("floating");
    }

    @Override
    public void closeCurrentArea() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String dockableName = DockableWindowManagerImpl.this.showStack.pop();
                    DockableWindowManagerImpl.this.hideDockableWindow(dockableName);
                    return;
                }
                catch (Exception dockableName) {
                    for (Component comp = DockableWindowManagerImpl.this.view.getFocusOwner(); comp != null; comp = comp.getParent()) {
                        if (!(comp instanceof DockablePanel)) continue;
                        DockablePanel panel = (DockablePanel)comp;
                        PanelWindowContainer container = panel.getWindowContainer();
                        container.show((Entry)null);
                        return;
                    }
                    DockableWindowManagerImpl.this.getToolkit().beep();
                    return;
                }
            }
        });
    }

    @Override
    public void close() {
        super.close();
        for (Entry entry : this.windows.values()) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
        for (Entry clone : this.clones) {
            if (clone.win == null) continue;
            clone.container.unregister(clone);
        }
    }

    @Override
    public PanelWindowContainer getTopDockingArea() {
        return this.top;
    }

    @Override
    public PanelWindowContainer getLeftDockingArea() {
        return this.left;
    }

    @Override
    public PanelWindowContainer getBottomDockingArea() {
        return this.bottom;
    }

    @Override
    public PanelWindowContainer getRightDockingArea() {
        return this.right;
    }

    public JPopupMenu createPopupMenu(final DockableWindowContainer container, final String dockable, final boolean clone) {
        JPopupMenu popup = new JPopupMenu();
        if (dockable == null && container instanceof PanelWindowContainer) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManagerImpl.this.showDockableWindow(evt.getActionCommand());
                }
            };
            String[] dockables = ((PanelWindowContainer)container).getDockables();
            TreeMap<String, String> dockableMap = new TreeMap<String, String>();
            for (String action : dockables) {
                dockableMap.put(this.getDockableTitle(action), action);
            }
            for (Map.Entry entry : dockableMap.entrySet()) {
                JMenuItem item = new JMenuItem((String)entry.getKey());
                item.setActionCommand((String)entry.getValue());
                item.addActionListener(listener);
                popup.add(item);
            }
        } else {
            JMenuItem caption = new JMenuItem(this.getDockableTitle(dockable));
            caption.setEnabled(false);
            popup.add(caption);
            popup.addSeparator();
            String currentPos = jEdit.getProperty(dockable + ".dock-position", "floating");
            if (!clone) {
                String[] positions;
                for (final String pos : positions = new String[]{"floating", "top", "left", "bottom", "right"}) {
                    if (pos.equals(currentPos)) continue;
                    JMenuItem moveMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-" + pos));
                    moveMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            jEdit.setProperty(dockable + ".dock-position", pos);
                            EditBus.send(new DockableWindowUpdate(DockableWindowManagerImpl.this, DockableWindowUpdate.PROPERTIES_CHANGED, dockable));
                            DockableWindowManagerImpl.this.showDockableWindow(dockable);
                        }
                    });
                    popup.add(moveMenuItem);
                }
                popup.addSeparator();
            }
            JMenuItem cloneMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-clone"));
            cloneMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManagerImpl.this.floatDockableWindow(dockable);
                }
            });
            popup.add(cloneMenuItem);
            popup.addSeparator();
            JMenuItem closeMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-close"));
            closeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (clone) {
                        ((FloatingWindowContainer)container).dispose();
                    } else {
                        DockableWindowManagerImpl.this.removeDockableWindow(dockable);
                    }
                }
            });
            popup.add(closeMenuItem);
            if (!clone && !currentPos.equals("floating")) {
                JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-undock"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        jEdit.setProperty(dockable + ".dock-position", "floating");
                        EditBus.send(new DockableWindowUpdate(DockableWindowManagerImpl.this, DockableWindowUpdate.PROPERTIES_CHANGED, dockable));
                        Entry entry = (Entry)DockableWindowManagerImpl.this.windows.get(dockable);
                        if (entry == null) {
                            Log.log(9, this, "Unknown dockable window: " + dockable);
                        } else {
                            entry.win = null;
                        }
                    }
                });
                popup.add(jMenuItem);
            }
        }
        return popup;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.resizeRect != null) {
            g.setColor(Color.darkGray);
            g.fillRect(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
        }
    }

    @Override
    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate msg) {
        if (msg.getWhat() == DockableWindowUpdate.PROPERTIES_CHANGED) {
            this.propertiesChanged();
        }
    }

    @Override
    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @Override
    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pmsg) {
        block4: {
            block5: {
                block3: {
                    if (pmsg.getWhat() != PluginUpdate.LOADED) break block3;
                    Iterator<DockableWindowFactory.Window> iter = this.factory.getDockableWindowIterator();
                    while (iter.hasNext()) {
                        DockableWindowFactory.Window w = iter.next();
                        if (w.plugin != pmsg.getPluginJAR()) continue;
                        this.addEntry(w);
                    }
                    this.propertiesChanged();
                    break block4;
                }
                if (pmsg.isExiting()) break block4;
                if (pmsg.getWhat() != PluginUpdate.DEACTIVATED) break block5;
                Iterator<Entry> iter = this.getAllPluginEntries(pmsg.getPluginJAR(), false);
                while (iter.hasNext()) {
                    Entry entry = iter.next();
                    if (entry.container == null) continue;
                    entry.container.remove(entry);
                }
                break block4;
            }
            if (pmsg.getWhat() != PluginUpdate.UNLOADED) break block4;
            Iterator<Entry> iter = this.getAllPluginEntries(pmsg.getPluginJAR(), true);
            while (iter.hasNext()) {
                Entry entry = iter.next();
                if (entry.container == null) continue;
                entry.container.unregister(entry);
                entry.win = null;
                entry.container = null;
            }
        }
    }

    void setResizePos(int resizePos, PanelWindowContainer resizing) {
        this.resizePos = resizePos;
        if (resizePos < 0) {
            resizePos = 0;
        }
        if (this.continuousLayout) {
            return;
        }
        Rectangle newResizeRect = new Rectangle(0, 0, 8, 8);
        if (resizing == this.top) {
            resizePos = Math.min(resizePos, this.getHeight() - this.top.buttonPanel.getHeight() - this.bottom.dockablePanel.getHeight() - this.bottom.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.top.dockablePanel.getX() + 1;
            newResizeRect.y = resizePos + this.top.buttonPanel.getHeight() + 1;
            newResizeRect.width = this.top.dockablePanel.getWidth() - 2;
        } else if (resizing == this.left) {
            resizePos = Math.min(resizePos, this.getWidth() - this.left.buttonPanel.getWidth() - this.right.dockablePanel.getWidth() - this.right.buttonPanel.getWidth() - 10);
            newResizeRect.x = resizePos + this.left.buttonPanel.getWidth() + 1;
            newResizeRect.y = this.left.dockablePanel.getY() + 1;
            newResizeRect.height = this.left.dockablePanel.getHeight() - 2;
        } else if (resizing == this.bottom) {
            resizePos = Math.min(resizePos, this.getHeight() - this.bottom.buttonPanel.getHeight() - this.top.dockablePanel.getHeight() - this.top.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.bottom.dockablePanel.getX() + 1;
            newResizeRect.y = this.getHeight() - this.bottom.buttonPanel.getHeight() - resizePos - 10 + 2;
            newResizeRect.width = this.bottom.dockablePanel.getWidth() - 2;
        } else if (resizing == this.right) {
            resizePos = Math.min(resizePos, this.getWidth() - this.right.buttonPanel.getWidth() - this.left.dockablePanel.getWidth() - this.left.buttonPanel.getWidth() - 10);
            newResizeRect.x = this.getWidth() - this.right.buttonPanel.getWidth() - resizePos - 10 + 1;
            newResizeRect.y = this.right.dockablePanel.getY() + 1;
            newResizeRect.height = this.right.dockablePanel.getHeight() - 2;
        }
        Rectangle toRepaint = this.resizeRect == null ? newResizeRect : this.resizeRect.union(newResizeRect);
        this.resizeRect = newResizeRect;
        this.repaint(toRepaint);
    }

    void finishResizing() {
        this.resizeRect = null;
        this.repaint();
    }

    @Override
    protected void propertiesChanged() {
        String[] windowList;
        if (this.view.isPlainView()) {
            return;
        }
        ((DockableLayout)this.getLayout()).setAlternateLayout(jEdit.getBooleanProperty("view.docking.alternateLayout"));
        for (String dockable : windowList = this.factory.getRegisteredDockableWindows()) {
            String newPosition;
            Entry entry = this.windows.get(dockable);
            if (entry == null || (newPosition = jEdit.getProperty(dockable + ".dock-position", "floating")).equals(entry.position)) continue;
            entry.position = newPosition;
            if (entry.container != null) {
                entry.container.unregister(entry);
                entry.container = null;
                if (entry.factory.movable && !newPosition.equals("floating")) {
                    if (entry.win instanceof DockableWindow) {
                        ((DockableWindow)((Object)entry.win)).move(newPosition);
                    }
                } else {
                    entry.win = null;
                }
            }
            if (newPosition.equals("floating")) continue;
            if (newPosition.equals("top")) {
                entry.container = this.top;
            } else if (newPosition.equals("left")) {
                entry.container = this.left;
            } else if (newPosition.equals("bottom")) {
                entry.container = this.bottom;
            } else if (newPosition.equals("right")) {
                entry.container = this.right;
            } else {
                Log.log(7, this, "Unknown position: " + newPosition);
                continue;
            }
            entry.container.register(entry);
        }
        this.top.sortDockables();
        this.left.sortDockables();
        this.bottom.sortDockables();
        this.right.sortDockables();
        this.continuousLayout = UIManager.getBoolean("SplitPane.continuousLayout");
        this.revalidate();
        this.repaint();
    }

    private void addEntry(DockableWindowFactory.Window factory) {
        Entry e;
        if (this.view.isPlainView()) {
            e = new Entry(factory, "floating");
        } else {
            e = new Entry(factory);
            if (!e.position.equals("floating")) {
                if (e.position.equals("top")) {
                    e.container = this.top;
                } else if (e.position.equals("left")) {
                    e.container = this.left;
                } else if (e.position.equals("bottom")) {
                    e.container = this.bottom;
                } else if (e.position.equals("right")) {
                    e.container = this.right;
                } else {
                    Log.log(7, this, "Unknown position: " + e.position);
                }
            }
            if (e.container != null) {
                e.container.register(e);
            }
        }
        this.windows.put(factory.name, e);
    }

    private Iterator<Entry> getAllPluginEntries(PluginJAR plugin, boolean remove) {
        Entry entry;
        LinkedList<Entry> returnValue = new LinkedList<Entry>();
        Iterator<Entry> iter = this.windows.values().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            if (!remove) continue;
            iter.remove();
        }
        iter = this.clones.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            iter.remove();
        }
        return returnValue.iterator();
    }

    @Override
    public void disposeDockableWindow(String name) {
    }

    static class Entry {
        DockableWindowFactory.Window factory;
        String position;
        DockableWindowContainer container;
        JComponent win;
        AbstractButton btn;

        Entry(DockableWindowFactory.Window factory) {
            this(factory, jEdit.getProperty(factory.name + ".dock-position", "floating"));
        }

        public String longTitle() {
            String title = jEdit.getProperty(this.factory.name + ".longtitle");
            if (title == null) {
                return this.shortTitle();
            }
            return title;
        }

        public String shortTitle() {
            String title = jEdit.getProperty(this.factory.name + ".title");
            if (title == null) {
                return "NO TITLE PROPERTY: " + this.factory.name;
            }
            return title;
        }

        public String label() {
            String retval = jEdit.getProperty(this.factory.name + ".label");
            retval = retval.replaceAll("\\$", "");
            return retval;
        }

        Entry(DockableWindowFactory.Window factory, String position) {
            this.factory = factory;
            this.position = position;
        }
    }

    public static class DockableWindowConfig
    extends DockableWindowManager.DockingLayout {
        public String top;
        public String left;
        public String bottom;
        public String right;
        public int topPos;
        public int leftPos;
        public int bottomPos;
        public int rightPos;

        public DefaultHandler getPerspectiveHandler() {
            return new PerspectiveHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean saveLayout(String baseName, int viewIndex) {
            String lineSep = System.getProperty("line.separator");
            String filename = this.getLayoutFilename(baseName, viewIndex);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(filename));
                out.write("<DOCKING LEFT=\"");
                out.write(this.left == null ? "" : this.left);
                out.write("\" TOP=\"");
                out.write(this.top == null ? "" : this.top);
                out.write("\" RIGHT=\"");
                out.write(this.right == null ? "" : this.right);
                out.write("\" BOTTOM=\"");
                out.write(this.bottom == null ? "" : this.bottom);
                out.write("\" LEFT_POS=\"");
                out.write(String.valueOf(this.leftPos));
                out.write("\" TOP_POS=\"");
                out.write(String.valueOf(this.topPos));
                out.write("\" RIGHT_POS=\"");
                out.write(String.valueOf(this.rightPos));
                out.write("\" BOTTOM_POS=\"");
                out.write(String.valueOf(this.bottomPos));
                out.write("\" />");
                out.write(lineSep);
            }
            catch (IOException e) {
                boolean bl;
                try {
                    Log.log(9, this, e, e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(out);
                    throw throwable;
                }
                IOUtilities.closeQuietly(out);
                return bl;
            }
            IOUtilities.closeQuietly(out);
            return true;
        }

        @Override
        public boolean loadLayout(String baseName, int viewIndex) {
            String filename = this.getLayoutFilename(baseName, viewIndex);
            DefaultHandler handler = this.getPerspectiveHandler();
            try {
                XMLUtilities.parseXML(new FileInputStream(filename), handler);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @Override
        public String getName() {
            return "DockableWindowManager";
        }

        public class PerspectiveHandler
        extends DefaultHandler {
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attrs) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.attribute(attrs.getQName(i), attrs.getValue(i));
                }
            }

            private void attribute(String aname, String value) {
                if (aname.equals("TOP")) {
                    DockableWindowConfig.this.top = value;
                } else if (aname.equals("LEFT")) {
                    DockableWindowConfig.this.left = value;
                } else if (aname.equals("BOTTOM")) {
                    DockableWindowConfig.this.bottom = value;
                } else if (aname.equals("RIGHT")) {
                    DockableWindowConfig.this.right = value;
                } else if (aname.equals("TOP_POS")) {
                    DockableWindowConfig.this.topPos = Integer.parseInt(value);
                } else if (aname.equals("LEFT_POS")) {
                    DockableWindowConfig.this.leftPos = Integer.parseInt(value);
                } else if (aname.equals("BOTTOM_POS")) {
                    DockableWindowConfig.this.bottomPos = Integer.parseInt(value);
                } else if (aname.equals("RIGHT_POS")) {
                    DockableWindowConfig.this.rightPos = Integer.parseInt(value);
                }
            }
        }
    }
}

