/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.MiscUtilities;

public class SplitConfigParser {
    private String splitConfig;
    private boolean includeSplits = true;
    private boolean includeFiles = true;
    private boolean includeRemotes = false;

    public SplitConfigParser(String splitConfig) {
        this.splitConfig = splitConfig == null ? "" : splitConfig;
    }

    public void setIncludeSplits(boolean b) {
        this.includeSplits = b;
    }

    public void setIncludeFiles(boolean b) {
        this.includeFiles = b;
    }

    public void setIncludeRemoteFiles(boolean b) {
        this.includeRemotes = this.includeFiles && b;
    }

    public String parse() {
        if (this.splitConfig == null || this.splitConfig.length() == 0) {
            return "";
        }
        ArrayDeque<Object> tokenStack = new ArrayDeque<Object>();
        ArrayDeque<Object> splitStack = new ArrayDeque<Object>();
        BufferSet bufferset = new BufferSet(this.includeFiles, this.includeRemotes);
        boolean haveSplit = false;
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(this.splitConfig));
            st.whitespaceChars(0, 32);
            st.wordChars(35, 126);
            st.commentChar(33);
            st.quoteChar(34);
            st.eolIsSignificant(false);
            int token = st.nextToken();
            while (token != -1) {
                switch (token) {
                    case -3: {
                        if ("vertical".equals(st.sval) || "horizontal".equals(st.sval)) {
                            if (!this.includeSplits) break;
                            Object right = splitStack.pop();
                            Object left = splitStack.pop();
                            Split split = new Split();
                            split.setLeft(left);
                            split.setRight(right);
                            split.setDirection(st.sval);
                            int offset = (Integer)tokenStack.pop();
                            split.setOffset(offset);
                            splitStack.push(split);
                            haveSplit = true;
                            break;
                        }
                        if ("buffer".equals(st.sval) || "buff".equals(st.sval)) {
                            Object filename = tokenStack.pop();
                            bufferset.addBuffer(filename.toString());
                            break;
                        }
                        if (!"bufferset".equals(st.sval)) break;
                        Object scope = tokenStack.pop();
                        bufferset.setScope(scope.toString());
                        splitStack.push(bufferset);
                        bufferset = new BufferSet(this.includeFiles, this.includeRemotes);
                        break;
                    }
                    case -2: {
                        tokenStack.push((int)st.nval);
                        break;
                    }
                    case 34: {
                        tokenStack.push(st.sval);
                    }
                }
                token = st.nextToken();
            }
            StringBuilder sb = new StringBuilder();
            if (haveSplit) {
                while (!splitStack.isEmpty()) {
                    sb.append(splitStack.pop().toString()).append(' ');
                }
            } else {
                BufferSet allBuffers = new BufferSet();
                while (!splitStack.isEmpty()) {
                    BufferSet bs = (BufferSet)splitStack.pop();
                    if (allBuffers.getScope() == null) {
                        allBuffers.setScope(bs.getScope());
                    }
                    allBuffers.addBufferSet(bs);
                }
                sb.append(allBuffers.toString());
            }
            return sb.toString().replaceAll("\\\\", "\\\\\\\\").trim();
        }
        catch (IOException iOException) {
            return this.splitConfig;
        }
    }

    private class Split {
        Object left = null;
        Object right = null;
        String direction = null;
        int offset = 0;

        private Split() {
        }

        public void setLeft(Object left) {
            this.left = left;
        }

        public void setRight(Object right) {
            this.right = right;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.left != null) {
                sb.append(this.left.toString()).append(' ');
            }
            if (this.right != null) {
                sb.append(this.right.toString()).append(' ');
            }
            sb.append(this.offset).append(' ').append(this.direction);
            return sb.toString();
        }
    }

    private class BufferSet {
        List<String> buffers = new ArrayList<String>();
        String scope = null;
        boolean includeFiles = true;
        boolean includeRemotes = false;

        public BufferSet() {
        }

        public BufferSet(boolean includeFiles, boolean includeRemotes) {
            this.includeFiles = includeFiles;
            this.includeRemotes = includeRemotes;
        }

        public void addBuffer(String s) {
            if (this.includeFiles) {
                if (this.includeRemotes) {
                    this.buffers.add(s);
                    return;
                }
                if (!this.isRemote(s)) {
                    this.buffers.add(s);
                }
            }
        }

        public List<String> getBuffers() {
            return this.buffers;
        }

        public void addBufferSet(BufferSet bs) {
            this.buffers.addAll(bs.getBuffers());
        }

        public void setScope(String s) {
            this.scope = s;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.buffers.size() == 0) {
                sb.append("\"Untitled-1\" buffer ");
            } else {
                for (int i = 0; i < this.buffers.size(); ++i) {
                    sb.append('\"').append(this.buffers.get(i)).append('\"');
                    sb.append(i == 0 ? " buffer " : " buff ");
                }
            }
            if (this.scope == null) {
                this.scope = "view";
            }
            sb.append('\"').append(this.scope).append("\" bufferset");
            return sb.toString();
        }

        public boolean isRemote(String uri) {
            if (MiscUtilities.isURL(uri)) {
                String protocol = MiscUtilities.getProtocolOfURL(uri);
                return !protocol.equals("file");
            }
            return false;
        }
    }
}

