/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.bsh.BshClassManager;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.TargetError;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.classpath.ClassManagerImpl;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public abstract class BeanShellFacade<T> {
    protected NameSpace global;
    protected BshClassManager classManager = new ClassManagerImpl();
    private static Interpreter interpForMethods;
    private static final Object[] NO_ARGS;

    protected BeanShellFacade() {
        this.global = new NameSpace(this.classManager, "jEdit embedded BeanShell interpreter");
        interpForMethods = BeanShellFacade.createInterpreter(this.global);
        this.init();
    }

    protected void init() {
        this.global.importPackage("org.gjt.sp.jedit");
        this.global.importPackage("org.gjt.sp.jedit.buffer");
        this.global.importPackage("org.gjt.sp.jedit.syntax");
        this.global.importPackage("org.gjt.sp.jedit.textarea");
        this.global.importPackage("org.gjt.sp.util");
    }

    public void evalSelection(T param, TextArea textArea) {
        String command = textArea.getSelectedText();
        if (command == null) {
            textArea.getToolkit().beep();
            return;
        }
        Object returnValue = this.eval(param, this.global, command);
        if (returnValue != null) {
            textArea.setSelectedText(returnValue.toString());
        }
    }

    public Object eval(T param, String command) {
        return this.eval(param, this.global, command);
    }

    public Object eval(T param, NameSpace namespace, String command) {
        try {
            return this._eval(param, namespace, command);
        }
        catch (Throwable e) {
            Log.log(9, BeanShellFacade.class, e);
            this.handleException(param, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _eval(T view, NameSpace namespace, String command) throws Exception {
        Interpreter interp = BeanShellFacade.createInterpreter(namespace);
        try {
            this.setupDefaultVariables(namespace, view);
            if (Debug.BEANSHELL_DEBUG) {
                Log.log(1, BeanShellFacade.class, command);
            }
            Object object = interp.eval(command);
            return object;
        }
        catch (Exception e) {
            BeanShellFacade.unwrapException(e);
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            try {
                this.resetDefaultVariables(namespace);
            }
            catch (UtilEvalError utilEvalError) {}
        }
    }

    public BshMethod cacheBlock(String id, String code, boolean namespace) throws Exception {
        NameSpace local = new NameSpace(this.global, "__internal_" + id);
        String name = "__runCachedMethod";
        if (namespace) {
            this._eval(null, local, name + "(ns) {\nthis.callstack.set(0,ns);\n" + code + "\n}");
            return local.getMethod(name, new Class[]{NameSpace.class});
        }
        this._eval(null, local, name + "() {\n" + code + "\n}");
        return local.getMethod(name, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runCachedBlock(BshMethod method, T param, NameSpace namespace) throws Exception {
        boolean useNamespace;
        if (namespace == null) {
            useNamespace = false;
            namespace = this.global;
        } else {
            useNamespace = true;
        }
        try {
            Object[] objectArray;
            this.setupDefaultVariables(namespace, param);
            if (useNamespace) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = namespace;
            } else {
                objectArray = NO_ARGS;
            }
            Object retVal = method.invoke(objectArray, interpForMethods, new CallStack(), null);
            if (retVal instanceof Primitive) {
                if (retVal == Primitive.VOID) {
                    Object var6_7 = null;
                    return var6_7;
                }
                Object object = ((Primitive)retVal).getValue();
                return object;
            }
            Object object = retVal;
            return object;
        }
        catch (Exception e) {
            Object var6_10 = null;
            return var6_10;
        }
        finally {
            this.resetDefaultVariables(namespace);
        }
    }

    public NameSpace getNameSpace() {
        return this.global;
    }

    void resetClassManager() {
        this.classManager.reset();
    }

    protected void setVariable(NameSpace nameSpace, String name, Object object) throws UtilEvalError {
        if (nameSpace.getVariable(name) == Primitive.VOID) {
            nameSpace.setVariable(name, object, false);
        }
    }

    protected abstract void setupDefaultVariables(NameSpace var1, T var2) throws UtilEvalError;

    protected abstract void resetDefaultVariables(NameSpace var1) throws UtilEvalError;

    protected abstract void handleException(T var1, String var2, Throwable var3);

    protected static Interpreter createInterpreter(NameSpace nameSpace) {
        return new Interpreter(null, System.out, System.err, false, nameSpace);
    }

    protected static void unwrapException(Exception e) throws Exception {
        Throwable t;
        if (e instanceof TargetError) {
            t = ((TargetError)e).getTarget();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        throw e;
    }

    static {
        NO_ARGS = new Object[0];
    }
}

