/*
 * Decompiled with CFR 0.152.
 */
package macosx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JCheckBox;
import macosx.MacOSXPlugin;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class MacOSXPluginOptionPane
extends AbstractOptionPane {
    private JCheckBox useQuartz;
    private JCheckBox ctrlAltSwapped;
    private JCheckBox disableOption;
    private JCheckBox multiShortcut;

    public MacOSXPluginOptionPane() {
        super("MacOSXPlugin");
    }

    protected void _init() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        this.useQuartz = new JCheckBox(jEdit.getProperty((String)"options.MacOSXPlugin.useQuartz"));
        this.useQuartz.setSelected(!new File(settingsDirectory, "noquartz").exists());
        this.addComponent(this.useQuartz);
        this.multiShortcut = new JCheckBox(jEdit.getProperty((String)"option.MacOSXPlugin.multiShortcut"));
        this.multiShortcut.setSelected(jEdit.getBooleanProperty((String)"menu.multiShortcut", (boolean)false));
        this.addComponent(this.multiShortcut);
        this.disableOption = new JCheckBox(jEdit.getProperty((String)"options.MacOSXPlugin.disableOption"));
        this.disableOption.setSelected(MacOSXPlugin.getDisableOption());
        this.addComponent(this.disableOption);
        this.ctrlAltSwapped = new JCheckBox(jEdit.getProperty((String)"options.MacOSXPlugin.ctrlAltSwapped"));
        this.ctrlAltSwapped.setSelected(MacOSXPlugin.isCtrlAltSwapped());
        this.addComponent(this.ctrlAltSwapped);
    }

    protected void _save() {
        this.setFileFlag("noquartz", !this.useQuartz.isSelected());
        jEdit.setBooleanProperty((String)"menu.multiShortcut", (boolean)this.multiShortcut.isSelected());
        MacOSXPlugin.setDisableOption(this.disableOption.isSelected());
        MacOSXPlugin.setCtrlAltSwapped(this.ctrlAltSwapped.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileFlag(String fileName, boolean present) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) return;
        File file = new File(settingsDirectory, fileName);
        if (!present) {
            file.delete();
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(10);
            out.close();
        }
        catch (IOException io) {
            try {
                Log.log((int)9, (Object)((Object)this), (Object)io);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(out);
                throw throwable;
            }
            IOUtilities.closeQuietly((OutputStream)out);
            return;
        }
        IOUtilities.closeQuietly((OutputStream)out);
        return;
    }
}

