/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import ise.java.awt.KappaLayout;
import ise.plugin.nav.EscapeDialog;
import ise.plugin.nav.NavPosition;
import ise.plugin.nav.NavStack;
import ise.plugin.nav.NavigatorPlugin;
import ise.plugin.nav.NumberTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class GoToLineDialog
extends EscapeDialog {
    static NavPosition previousEntry = null;
    private View parent;
    private JComboBox lineChooser;
    private JButton okButton;
    private JButton cancelButton;
    private boolean cancelled = false;

    public GoToLineDialog(View parent) {
        super((Frame)parent, jEdit.getProperty((String)"navigator.gotoLine", (String)"Go to line"), true);
        this.parent = parent;
        this.installComponents();
        this.installListeners();
        this.setVisible(true);
    }

    private void installComponents() {
        JPanel mainPanel = new JPanel((LayoutManager)new KappaLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
        Icon icon = GUIUtilities.loadIcon((String)"22x22/actions/go-jump.png");
        NavStack<NavPosition> combinedList = NavigatorPlugin.createNavigator(this.parent).getCombinedListModel();
        if (previousEntry != null) {
            combinedList.push(previousEntry);
        }
        NavStack<NavPosition> comboBoxModel = new NavStack<NavPosition>(combinedList.size());
        int editPaneHashCode = this.parent.getEditPane().hashCode();
        String bufferPath = this.parent.getBuffer().getPath();
        while (!combinedList.empty()) {
            NavPosition possible = combinedList.pop();
            if (possible.editPane != editPaneHashCode || !possible.path.equals(bufferPath) || comboBoxModel.contains(possible)) continue;
            comboBoxModel.push(possible);
        }
        this.lineChooser = new JComboBox(comboBoxModel);
        this.lineChooser.setEditable(true);
        if (previousEntry != null && comboBoxModel.size() > 0) {
            this.lineChooser.setSelectedIndex(0);
        }
        NumberTextField editor = new NumberTextField("", 15);
        editor.setMinValue(1);
        this.lineChooser.setEditor(editor);
        this.lineChooser.getEditor().selectAll();
        this.okButton = new JButton(jEdit.getProperty((String)"common.ok", (String)"OK"));
        this.cancelButton = new JButton(jEdit.getProperty((String)"common.cancel", (String)"Cancel"));
        KappaLayout buttonPanelLayout = new KappaLayout();
        JPanel buttonPanel = new JPanel((LayoutManager)buttonPanelLayout);
        buttonPanel.add("0, 0, 1, 1, 0, w, 3", this.okButton);
        buttonPanel.add("1, 0, 1, 1, 0, w, 3", this.cancelButton);
        buttonPanelLayout.makeColumnsSameWidth(0, 1);
        mainPanel.add("0, 0, 1, 1, E,, 3", new JLabel(icon));
        mainPanel.add("1, 0, 2, 1, W, w, 3", this.lineChooser);
        mainPanel.add("0, 1", KappaLayout.createVerticalStrut((int)11));
        mainPanel.add("1, 2, 2, 1, E,, 3", buttonPanel);
        this.setContentPane(mainPanel);
        this.pack();
        this.setLocationRelativeTo((Component)this.parent);
        this.lineChooser.requestFocus();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void installListeners() {
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GoToLineDialog.this.performEnterAction(null);
            }
        });
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GoToLineDialog.this.performEscapeAction(null);
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.parent.getTextArea().requestFocus();
    }

    public NavPosition getLineNumber() {
        if (this.cancelled) {
            return null;
        }
        return previousEntry;
    }

    @Override
    public void performEnterAction(KeyEvent e) {
        if (this.lineChooser.isPopupVisible()) {
            this.lineChooser.hidePopup();
        }
        Object selectedItem = null;
        String editorText = ((JTextField)((Object)this.lineChooser.getEditor())).getText();
        if (editorText == null || "".equals(editorText)) {
            this.cancelled = true;
        } else {
            selectedItem = this.lineChooser.getSelectedItem();
            if (selectedItem == null) {
                selectedItem = editorText;
            } else if (!selectedItem.toString().equals(editorText)) {
                selectedItem = editorText;
            }
            if (selectedItem instanceof NavPosition) {
                previousEntry = (NavPosition)selectedItem;
            } else {
                int offset;
                EditPane editPane = this.parent.getEditPane();
                JEditTextArea textArea = editPane.getTextArea();
                int line = Integer.parseInt(selectedItem.toString());
                if (line == 1) {
                    offset = 0;
                } else if (line >= textArea.getLineCount()) {
                    line = textArea.getLineCount() - 1;
                    offset = textArea.getBufferLength() - 1;
                } else {
                    offset = textArea.getLineStartOffset(--line);
                }
                previousEntry = new NavPosition(editPane, this.parent.getBuffer(), offset, textArea.getLineText(line));
            }
        }
        this.close();
    }

    @Override
    public void performEscapeAction(KeyEvent e) {
        this.cancelled = true;
        this.close();
    }
}

