/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import errorlist.DefaultErrorSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;
import sidekick.SideKickCompletion;
import sidekick.SideKickCompletionPopup;
import sidekick.SideKickParsedData;

public abstract class SideKickParser {
    public static final String SERVICE = "sidekick.SideKickParser";
    protected String name;

    public SideKickParser(String serviceName) {
        this.name = serviceName;
    }

    public final String getName() {
        return this.name;
    }

    public void stop() {
    }

    public void activate(View view) {
    }

    public void deactivate(View view) {
    }

    public void activate(EditPane editPane) {
        this.activate(editPane.getView());
        Log.log((int)1, (Object)this, (Object)(this.getName() + ": activated for " + editPane.getBuffer()));
    }

    public void deactivate(EditPane editPane) {
        this.deactivate(editPane.getView());
        Log.log((int)1, (Object)this, (Object)(this.getName() + ": deactivated"));
    }

    public abstract SideKickParsedData parse(Buffer var1, DefaultErrorSource var2);

    public boolean supportsCompletion() {
        return true;
    }

    public boolean canHandleBackspace() {
        return false;
    }

    public boolean canCompleteAnywhere() {
        return true;
    }

    public String getInstantCompletionTriggers() {
        return null;
    }

    public String getParseTriggers() {
        return null;
    }

    public SideKickCompletion complete(EditPane editPane, int caret) {
        try {
            String word;
            String[] keywords = editPane.getBuffer().getKeywordMapAtOffset(caret).getKeywords();
            if (keywords.length > 0 && (word = this.getWordAtCaret(editPane, caret)) != null && word.length() > 0) {
                ArrayList<String> possibles = new ArrayList<String>();
                for (int i = 0; i < keywords.length; ++i) {
                    String kw = keywords[i];
                    if (!kw.startsWith(word) || kw.equals(word)) continue;
                    possibles.add(keywords[i]);
                }
                Collections.sort(possibles);
                return new ConcreteSideKickCompletion(editPane.getView(), word, possibles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SideKickCompletionPopup getCompletionPopup(View view, int caretPosition, SideKickCompletion complete, boolean active) {
        return new SideKickCompletionPopup(view, this, caretPosition, complete, active);
    }

    public JPanel getPanel() {
        return null;
    }

    private String getWordAtCaret(EditPane editPane, int caret) {
        if (caret <= 0) {
            return "";
        }
        Buffer buffer = editPane.getBuffer();
        String text = buffer.getText(0, caret);
        Mode mode = buffer.getMode();
        String word_break_chars = (String)mode.getProperty("wordBreakChars");
        if (word_break_chars == null) {
            word_break_chars = "";
        }
        word_break_chars = word_break_chars + " \n\r\t";
        int offset = 0;
        for (int i = 0; i < word_break_chars.length(); ++i) {
            int maybe = text.lastIndexOf(word_break_chars.charAt(i)) + 1;
            if (maybe <= offset) continue;
            offset = maybe;
        }
        return text.substring(offset);
    }

    class ConcreteSideKickCompletion
    extends SideKickCompletion {
        public ConcreteSideKickCompletion(View view, String word, List possibles) {
            super(view, word, possibles);
        }
    }
}

