/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpHistoryModel;
import org.gjt.sp.jedit.jEdit;

public class HistoryButton
extends JPanel
implements ActionListener {
    public static final int BACK = 0;
    public static final int FORWARD = 1;
    private int type;
    private HelpHistoryModel history;
    private RolloverButton arrow_button;
    private RolloverButton drop_button;
    private JPopupMenu historyList;
    private ActionListener arrowActionListener;

    public HistoryButton(int type, HelpHistoryModel model) {
        this.arrow_button = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty(type == 0 ? "helpviewer.back.icon" : "helpviewer.forward.icon")));
        this.arrow_button.setToolTipText(jEdit.getProperty(type == 0 ? "helpviewer.back.label" : "helpviewer.forward.label"));
        Box box = new Box(0);
        this.drop_button = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
        this.drop_button.addActionListener(new DropActionHandler());
        box.add(this.arrow_button);
        box.add(this.drop_button);
        this.setMaximumSize(new Dimension(this.drop_button.getPreferredSize().width + this.arrow_button.getPreferredSize().width + 5, this.arrow_button.getPreferredSize().height + 10));
        this.add(box);
        this.type = type;
        this.history = model;
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.drop_button.setEnabled(state);
        this.arrow_button.setEnabled(state);
    }

    public void addActionListener(ActionListener al) {
        this.arrow_button.addActionListener(this);
        this.arrowActionListener = al;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.arrowActionListener.actionPerformed(new ActionEvent(this, 1001, evt.getActionCommand(), evt.getWhen(), evt.getModifiers()));
    }

    private HistoryButton getParentHistoryButton() {
        return this;
    }

    class HistoryListActionHandler
    extends AbstractAction {
        HelpHistoryModel.HistoryEntry entry;

        HistoryListActionHandler(HelpHistoryModel.HistoryEntry entry) {
            super(entry.title);
            this.entry = entry;
            this.putValue("ActionCommandKey", entry.url + ':' + entry.scrollPosition);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            HistoryButton.this.getParentHistoryButton().actionPerformed(ae);
            HistoryButton.this.history.setCurrentEntry(this.entry);
        }
    }

    class DropActionHandler
    implements ActionListener {
        DropActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HistoryButton.this.historyList = new JPopupMenu();
            HelpHistoryModel.HistoryEntry[] urls = HistoryButton.this.type == 0 ? HistoryButton.this.history.getPreviousURLs() : HistoryButton.this.history.getNextURLs();
            if (urls != null) {
                if (HistoryButton.this.type == 0) {
                    for (int i = urls.length - 1; i >= 0; --i) {
                        if (urls[i] == null) continue;
                        HistoryButton.this.historyList.add(new HistoryListActionHandler(urls[i]));
                    }
                } else {
                    for (HelpHistoryModel.HistoryEntry url : urls) {
                        if (url == null) continue;
                        HistoryButton.this.historyList.add(new HistoryListActionHandler(url));
                    }
                }
                HistoryButton.this.historyList.show((JComponent)evt.getSource(), 0, 0);
            }
        }
    }
}

