/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.util.Log;

public class PluginsProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu menu) {
        int count = 0;
        List[] letters = new List[26];
        for (int i = 0; i < letters.length; ++i) {
            letters[i] = new ArrayList();
        }
        PluginJAR[] pluginArray = jEdit.getPluginJARs();
        for (PluginJAR jar : pluginArray) {
            JMenuItem menuItem;
            EditPlugin plugin = jar.getPlugin();
            if (plugin == null || (menuItem = plugin.createMenuItems()) == null) continue;
            this.addToLetterMap(letters, menuItem);
            ++count;
        }
        if (count == 0) {
            JMenuItem menuItem = new JMenuItem(jEdit.getProperty("no-plugins.label"));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            return;
        }
        for (List letter1 : letters) {
            Collections.sort(letter1, new MenuItemTextComparator());
        }
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        if (count <= maxItems) {
            for (List items : letters) {
                for (JMenuItem item : items) {
                    menu.add(item);
                }
            }
            return;
        }
        count = 0;
        char first = 'A';
        JMenu submenu = new JMenu();
        menu.add(submenu);
        for (int i = 0; i < letters.length; ++i) {
            List letter = letters[i];
            if (count + letter.size() > maxItems && count != 0) {
                char last = (char)(i + 65 - 1);
                if (last == first) {
                    submenu.setText(String.valueOf(first));
                } else {
                    submenu.setText(first + " - " + last);
                }
                first = (char)(i + 65);
                count = 0;
                submenu = null;
            }
            for (JMenuItem item : letter) {
                if (submenu == null) {
                    submenu = new JMenu();
                    menu.add(submenu);
                }
                submenu.add(item);
            }
            count += letter.size();
        }
        if (submenu != null) {
            char last = 'Z';
            if (last == first) {
                submenu.setText(String.valueOf(first));
            } else {
                submenu.setText(first + " - " + last);
            }
        }
    }

    private void addToLetterMap(List<JMenuItem>[] letters, JMenuItem item) {
        char ch = item.getText().charAt(0);
        if ((ch = Character.toUpperCase(ch)) < 'A' || ch > 'Z') {
            Log.log(9, this, "Plugin menu item label must begin with A - Z, or a - z: " + item.getText());
        } else {
            letters[ch - 65].add(item);
        }
    }
}

