/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.ThreadUtilities;

public class BufferSwitcher
extends JComboBox {
    private final EditPane editPane;
    private boolean updating;
    private Object itemSelectedBefore;
    public static final DataFlavor BufferDataFlavor = new DataFlavor(BufferTransferableData.class, "application/x-java-jvm-local-objectref");

    public BufferSwitcher(final EditPane editPane) {
        this.editPane = editPane;
        this.setTransferHandler(new ComboBoxTransferHandler(this));
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BufferSwitcher.this.itemSelectedBefore = BufferSwitcher.this.getSelectedItem();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Buffer buffer;
                if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                    editPane.setBuffer(buffer);
                }
                editPane.getTextArea().requestFocus();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.itemSelectedBefore);
            }
        });
    }

    public void updateBufferList() {
        final BufferSet bufferSet = this.editPane.getBufferSet();
        if (bufferSet.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BufferSwitcher.this.updating = true;
                BufferSwitcher.this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
                BufferSwitcher.this.setModel(new DefaultComboBoxModel<Buffer>(bufferSet.getAllBuffers()));
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.editPane.getBuffer());
                BufferSwitcher.this.setToolTipText(BufferSwitcher.this.editPane.getBuffer().getPath(true));
                BufferSwitcher.this.addDnD();
                BufferSwitcher.this.updating = false;
            }
        };
        ThreadUtilities.runInDispatchThread(runnable);
    }

    private void addDnD() {
        ComboBoxUI ui = this.getUI();
        if (ui instanceof BasicComboBoxUI) {
            try {
                Field listBoxField = this.getField(ui.getClass(), "listBox");
                listBoxField.setAccessible(true);
                JList list = (JList)listBoxField.get(ui);
                list.setDragEnabled(true);
                list.setDropMode(DropMode.INSERT);
                list.setTransferHandler(new BufferSwitcherTransferHandler());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Field getField(Class aClass, String fieldName) throws NoSuchFieldException {
        if (aClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return aClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return this.getField(aClass.getSuperclass(), fieldName);
        }
    }

    private class BufferSwitcherTransferHandler
    extends TransferHandler {
        private BufferSwitcherTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            BufferTransferableData data;
            if (!support.isDataFlavorSupported(BufferDataFlavor)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            if (dl.getIndex() == -1) {
                return false;
            }
            Transferable t = support.getTransferable();
            try {
                data = (BufferTransferableData)t.getTransferData(BufferDataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            JComponent target = (JComponent)support.getComponent();
            EditPane sourceEditPane = (EditPane)GUIUtilities.getComponentParent(data.getSource(), EditPane.class);
            EditPane targetEditPane = (EditPane)GUIUtilities.getComponentParent(target, EditPane.class);
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            View sourceView = sourceEditPane.getView();
            View targetView = targetEditPane.getView();
            switch (scope) {
                case editpane: {
                    return sourceEditPane != targetEditPane;
                }
                case view: {
                    return sourceView != targetView;
                }
                case global: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            BufferTransferableData data;
            if (!support.isDrop()) {
                return false;
            }
            Transferable t = support.getTransferable();
            try {
                data = (BufferTransferableData)t.getTransferData(BufferDataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            JComponent target = (JComponent)support.getComponent();
            EditPane targetEditPane = (EditPane)GUIUtilities.getComponentParent(target, EditPane.class);
            Buffer buffer = data.getBuffer();
            View view = targetEditPane.getView();
            BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
            if (buffer != null) {
                bufferSetManager.addBuffer(targetEditPane, buffer);
                targetEditPane.setBuffer(buffer);
            }
            view.toFront();
            view.requestFocus();
            targetEditPane.requestFocus();
            return true;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            if (action == 2) {
                BufferTransferableData data;
                try {
                    data = (BufferTransferableData)t.getTransferData(BufferDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return;
                }
                catch (IOException e) {
                    return;
                }
                Buffer buffer = data.getBuffer();
                EditPane editPane = (EditPane)GUIUtilities.getComponentParent(c, EditPane.class);
                BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
                if (buffer != null) {
                    bufferSetManager.removeBuffer(editPane, buffer);
                }
            }
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            Buffer buffer = (Buffer)list.getSelectedValue();
            if (buffer == null) {
                return null;
            }
            return new BufferSwitcherTransferable(buffer, c);
        }
    }

    private class BufferTransferableData {
        private final Buffer buffer;
        private final JComponent source;

        public BufferTransferableData(Buffer buffer, JComponent source) {
            this.buffer = buffer;
            this.source = source;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        public JComponent getSource() {
            return this.source;
        }
    }

    private class BufferSwitcherTransferable
    implements Transferable {
        private final DataFlavor[] supportedDataFlavor = new DataFlavor[]{BufferDataFlavor};
        private final Buffer buffer;
        private final JComponent source;

        public BufferSwitcherTransferable(Buffer buffer, JComponent source) {
            this.buffer = buffer;
            this.source = source;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedDataFlavor;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BufferDataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return new BufferTransferableData(this.buffer, this.source);
        }
    }

    private class ComboBoxTransferHandler
    extends TransferHandler {
        JComboBox comboBox;

        public ComboBoxTransferHandler(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(BufferDataFlavor)) {
                return false;
            }
            if (!this.comboBox.isPopupVisible()) {
                this.comboBox.showPopup();
            }
            return false;
        }
    }

    static class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Buffer buffer = (Buffer)value;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
                this.setToolTipText(buffer.getPath());
            }
            return this;
        }
    }
}

