/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightCellEditor;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;

public class HighlightTablePanel
extends JPanel {
    private final HistoryTextField expressionField = new HistoryTextField("gatchan-highlight.expression");
    private final JCheckBox regexp = new JCheckBox("regexp");
    private final JCheckBox ignoreCase = new JCheckBox("ignore case");
    private final ColorWellButton colorBox = new ColorWellButton(Highlight.getNextColor());
    private HighlightCellEditor highlightCellEditor;
    private boolean initialized;
    private Color permanentScopeColor = this.getBackground();
    private static final Color SESSION_SCOPE_COLOR = new Color(204, 204, 255);
    private static final Color BUFFER_SCOPE_COLOR = new Color(255, 252, 192);

    public HighlightTablePanel() {
        super(new GridBagLayout());
        this.ignoreCase.setSelected(true);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridwidth = 0;
        this.add((Component)this.expressionField, cons);
        cons.weightx = 0.0;
        cons.fill = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        this.add((Component)this.regexp, cons);
        this.add((Component)this.ignoreCase, cons);
        cons.gridwidth = 0;
        this.add((Component)this.colorBox, cons);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setString(String s) {
        this.expressionField.setText(s);
    }

    public void setDialog(EnhancedDialog dialog) {
        this.expressionField.addActionListener((ActionListener)new MyActionListener(dialog));
    }

    public void setHighlight(Highlight highlight) {
        this.expressionField.setText(highlight.getStringToHighlight());
        this.regexp.setSelected(highlight.isRegexp());
        this.ignoreCase.setSelected(highlight.isIgnoreCase());
        this.colorBox.setSelectedColor(highlight.getColor());
        if (this.highlightCellEditor != null) {
            this.expressionField.getDocument().addDocumentListener(this.highlightCellEditor);
            if (!this.initialized) {
                this.regexp.addActionListener(this.highlightCellEditor);
                this.ignoreCase.addActionListener(this.highlightCellEditor);
                ActionListener[] actionListeners = this.colorBox.getActionListeners();
                if (actionListeners.length == 1) {
                    ActionListener actionListener = actionListeners[0];
                    this.colorBox.removeActionListener(actionListener);
                    this.colorBox.addActionListener((ActionListener)new SpecialColorWellButtonActionListener(actionListener, this.highlightCellEditor));
                }
                this.initialized = true;
            }
        }
        switch (highlight.getScope()) {
            case 1: {
                this.changeBackgroundColor(SESSION_SCOPE_COLOR);
                break;
            }
            case 2: {
                this.changeBackgroundColor(BUFFER_SCOPE_COLOR);
                break;
            }
            default: {
                this.changeBackgroundColor(this.permanentScopeColor);
            }
        }
    }

    public void changeBackgroundColor(Color bg) {
        this.setBackground(bg);
        this.regexp.setBackground(bg);
        this.ignoreCase.setBackground(bg);
    }

    public void focus() {
        this.expressionField.requestFocus();
    }

    public void save(Highlight highlight) throws InvalidHighlightException {
        String stringToHighlight = this.expressionField.getText();
        if (stringToHighlight.length() == 0) {
            throw new InvalidHighlightException("String cannot be empty");
        }
        highlight.init(stringToHighlight, this.regexp.isSelected(), this.ignoreCase.isSelected(), this.colorBox.getSelectedColor());
        this.expressionField.addCurrentToHistory();
    }

    public void stopEdition() {
        if (this.highlightCellEditor != null) {
            this.expressionField.getDocument().removeDocumentListener(this.highlightCellEditor);
        }
    }

    public void setCellEditor(HighlightCellEditor highlightCellEditor) {
        this.highlightCellEditor = highlightCellEditor;
    }

    private static class MyActionListener
    implements ActionListener {
        private final EnhancedDialog dialog;

        MyActionListener(EnhancedDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.ok();
        }
    }

    private static class SpecialColorWellButtonActionListener
    implements ActionListener {
        private final ActionListener actionListener;
        private final HighlightCellEditor highlightCellEditor;

        SpecialColorWellButtonActionListener(ActionListener actionListener, HighlightCellEditor highlightCellEditor) {
            this.actionListener = actionListener;
            this.highlightCellEditor = highlightCellEditor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionListener.actionPerformed(e);
            this.highlightCellEditor.stopCellEditing();
        }
    }
}

