/*
 * Decompiled with CFR 0.152.
 */
package ise.plugin.nav;

import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;

public class NavPosition {
    public int editPane = 0;
    public String path = null;
    public String name = null;
    public int caret = 0;
    public int lineno = 0;
    public String linetext = "";
    public Boolean fileJump = false;

    public NavPosition(EditPane editPane, Buffer buffer, int caretPosition, String linetext) {
        if (editPane == null) {
            throw new IllegalArgumentException("editPane cannot be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (caretPosition < 0) {
            throw new IllegalArgumentException("caret position cannot less than 0");
        }
        this.editPane = editPane.hashCode();
        this.path = buffer.getPath();
        this.name = buffer.getName();
        this.caret = caretPosition;
        this.lineno = buffer.getLineOfOffset(this.caret);
        this.linetext = linetext == null ? "" : linetext;
    }

    public NavPosition(NavPosition other) {
        this.editPane = other.editPane;
        this.path = other.path;
        this.name = other.name;
        this.caret = other.caret;
        this.lineno = other.lineno;
        this.linetext = other.linetext;
        this.fileJump = other.fileJump;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NavPosition)) {
            return false;
        }
        NavPosition other = (NavPosition)obj;
        boolean groupByFile = jEdit.getBooleanProperty((String)"navigator.groupByFile", (boolean)false);
        boolean groupByLine = jEdit.getBooleanProperty((String)"navigator.groupByLine", (boolean)false);
        if (groupByFile) {
            return this.path.equalsIgnoreCase(other.path);
        }
        if (groupByLine) {
            return this.path.equalsIgnoreCase(other.path) && this.lineno == other.lineno;
        }
        return this.path.equalsIgnoreCase(other.path) && this.lineno == other.lineno && this.caret == other.caret;
    }

    public int hashCode() {
        return (this.path + this.lineno + this.caret).hashCode();
    }

    public String toString() {
        return String.valueOf(this.lineno + 1);
    }

    public String plainText() {
        boolean showPath = jEdit.getBooleanProperty((String)"navigator.showPath", (boolean)true);
        boolean showLineNumber = jEdit.getBooleanProperty((String)"navigator.showLineNumber", (boolean)true);
        boolean showCaretOffset = jEdit.getBooleanProperty((String)"navigator.showCaretOffset", (boolean)true);
        StringBuilder sb = new StringBuilder();
        sb.append(showPath ? this.path : this.name);
        if (showLineNumber) {
            sb.append(":").append(this.lineno + 1);
        }
        if (showCaretOffset) {
            sb.append(":").append(this.caret);
        }
        return sb.toString();
    }

    public String htmlText() {
        return this.htmlText(Integer.MAX_VALUE);
    }

    public String htmlText(int maxLineLength) {
        boolean showPath = jEdit.getBooleanProperty((String)"navigator.showPath", (boolean)true);
        boolean showLineNumber = jEdit.getBooleanProperty((String)"navigator.showLineNumber", (boolean)true);
        boolean showCaretOffset = jEdit.getBooleanProperty((String)"navigator.showCaretOffset", (boolean)true);
        boolean showLineText = jEdit.getBooleanProperty((String)"navigator.showLineText", (boolean)false);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><tt>");
        sb.append(showPath ? this.path : this.name);
        if (showLineNumber) {
            sb.append(":").append(this.lineno + 1);
        }
        if (showCaretOffset) {
            sb.append(":").append(this.caret);
        }
        sb.append("</tt>");
        if (showLineText && this.linetext != null) {
            String text = this.linetext;
            text = text.trim();
            text = text.replaceAll("[<]", "&lt;");
            if ((text = text.replaceAll("[>]", "&gt;")).length() > maxLineLength) {
                text = text.substring(0, maxLineLength);
            }
            sb.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(text);
        }
        return sb.toString();
    }
}

