/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class OkCancelButtons
extends JPanel
implements ActionListener {
    private EnhancedDialog target;
    private JButton cancel;
    private JButton ok;

    public OkCancelButtons(EnhancedDialog target) {
        super(new FlowLayout());
        this.target = target;
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        this.ok.setPreferredSize(this.cancel.getPreferredSize());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add(this.ok);
        this.add(this.cancel);
        this.resizeButtons();
    }

    public void setOkText(String text) {
        this.ok.setText(text);
        this.resizeButtons();
    }

    public void setCancelText(String text) {
        this.cancel.setText(text);
        this.resizeButtons();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cancel) {
            this.target.cancel();
        } else if (ae.getSource() == this.ok) {
            this.target.ok();
        }
    }

    private void resizeButtons() {
        Dimension d1 = this.ok.getPreferredSize();
        Dimension d2 = this.cancel.getPreferredSize();
        if (d1.getWidth() > d2.getWidth()) {
            this.cancel.setPreferredSize(d1);
        } else {
            this.ok.setPreferredSize(d2);
        }
    }
}

