/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.gjt.sp.jedit.jEdit;

public class HistoryComboBox
extends JComboBox {
    private Stack entries;
    private int entryCount;
    private DefaultComboBoxModel model;
    private String propertyName;

    public HistoryComboBox(int entryCount, String propName) {
        this.propertyName = propName;
        this.setEditable(true);
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
        this.entryCount = entryCount;
        this.entries = new Stack();
        if (this.propertyName != null) {
            this.loadFromProperty(this.propertyName);
        }
    }

    public HistoryComboBox(int entryCount) {
        this(entryCount, null);
    }

    protected void addEntry() {
        this.model.addElement(this.getSelectedItem().toString());
        if (this.model.getSize() > this.entryCount) {
            this.model.removeElementAt(0);
        }
        this.setSelectedItem("");
        this.repaint();
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getKeyCode() == 10) {
            this.fireActionEvent();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        this.addEntry();
        if (this.propertyName != null) {
            this.storeToProperty(this.propertyName);
        }
    }

    protected void storeToProperty(String name) {
        int i;
        for (i = 1; i < this.getItemCount(); ++i) {
            jEdit.setProperty((String)(name + "." + i), (String)this.getItemAt(i).toString());
        }
        jEdit.unsetProperty((String)(name + "." + i));
    }

    protected void loadFromProperty(String name) {
        this.removeAllItems();
        int i = 1;
        String query = jEdit.getProperty((String)(name + "." + i));
        while (query != null) {
            if (!query.equals("")) {
                this.addItem(query);
            }
            query = jEdit.getProperty((String)(name + "." + i));
            ++i;
        }
        this.setSelectedItem("");
    }
}

