/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.Vector;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.Node;
import org.gjt.sp.jedit.textarea.Selection;

public class ColumnBlock
extends Selection.Rect
implements Node {
    private Node parent;
    private Vector<Node> children = new Vector();
    private Vector<ColumnBlockLine> lines = new Vector();
    float columnBlockWidth;
    private boolean tabSizesDirty = true;
    private JEditBuffer buffer;
    private boolean isDirty;

    @Override
    public void addChild(Node node) {
        ColumnBlock block = (ColumnBlock)node;
        ColumnBlock blockBelow = this.searchChildren(block.startLine);
        if (blockBelow != null) {
            if (blockBelow.isLineWithinThisBlock(block.endLine) >= 0) {
                throw new IllegalArgumentException("Overlapping column blocks: " + block + " \n&\n" + blockBelow);
            }
            int index = this.children.indexOf(blockBelow);
            this.children.add(index, node);
        } else {
            this.children.add(node);
        }
    }

    @Override
    public Vector<Node> getChildren() {
        return this.children;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    public void setWidth(int width) {
        this.columnBlockWidth = width;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void setLines(Vector<ColumnBlockLine> lines) {
        this.lines = lines;
    }

    public Vector<ColumnBlockLine> getLines() {
        return this.lines;
    }

    public ColumnBlock() {
    }

    public ColumnBlock(JEditBuffer buffer, int startLine, int startColumn, int endLine, int endColumn) {
        super(buffer, startLine, startColumn, endLine, endColumn);
        this.buffer = buffer;
    }

    public ColumnBlock(JEditBuffer buffer, int startLine, int endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.buffer = buffer;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public int getColumnWidth() {
        return (int)this.columnBlockWidth;
    }

    public int isLineWithinThisBlock(int line) {
        if (line < this.startLine) {
            return line - this.startLine;
        }
        if (line > this.endLine) {
            return line - this.endLine;
        }
        return 0;
    }

    public ColumnBlock getContainingBlock(int line, int offset) {
        ColumnBlock retBlock = null;
        if (line >= this.startLine && line <= this.endLine) {
            ColumnBlock block;
            ColumnBlockLine blockLine;
            int relativeOffset = offset - this.buffer.getLineStartOffset(line);
            if (this.lines != null && !this.lines.isEmpty() && (blockLine = this.lines.get(line - this.startLine)).getColumnEndIndex() >= relativeOffset && blockLine.getColumnStartIndex() <= relativeOffset) {
                retBlock = this;
            }
            if (retBlock == null && this.children != null && !this.children.isEmpty() && (block = this.searchChildren(line)) != null && block.isLineWithinThisBlock(line) == 0) {
                retBlock = block.getContainingBlock(line, offset);
            }
        }
        return retBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnBlock getColumnBlock(int line, int offset) {
        if (this.isDirty) {
            return null;
        }
        Object object = this.buffer.columnBlockLock;
        synchronized (object) {
            ColumnBlock colBlock = null;
            if (line >= this.startLine && line <= this.endLine) {
                ColumnBlockLine blockLine;
                if (this.lines != null && !this.lines.isEmpty() && (blockLine = this.lines.get(line - this.startLine)).getColumnEndIndex() + this.buffer.getLineStartOffset(line) == offset) {
                    colBlock = this;
                }
                if (colBlock == null && this.children != null && !this.children.isEmpty()) {
                    ColumnBlock block = this.searchChildren(line, 0, this.children.size() - 1);
                    if (block == null || block.isLineWithinThisBlock(line) != 0) {
                        this.throwException(offset, line);
                    }
                    colBlock = block.getColumnBlock(line, offset);
                }
            }
            if (colBlock == null) {
                this.throwException(offset, line);
            }
            return colBlock;
        }
    }

    public ColumnBlock searchChildren(int line) {
        if (this.children != null && !this.children.isEmpty()) {
            return this.searchChildren(line, 0, this.children.size() - 1);
        }
        return null;
    }

    private ColumnBlock searchChildren(int line, int startIndex, int stopIndex) {
        if (this.children != null) {
            if (startIndex > stopIndex) {
                return (ColumnBlock)this.children.get(startIndex);
            }
            int currentSearchIndex = (startIndex + stopIndex) / 2;
            int found = ((ColumnBlock)this.children.get(currentSearchIndex)).isLineWithinThisBlock(line);
            if (found == 0) {
                return (ColumnBlock)this.children.get(currentSearchIndex);
            }
            if (found > 0) {
                if (this.children.size() - 1 > currentSearchIndex) {
                    return this.searchChildren(line, currentSearchIndex + 1, stopIndex);
                }
                return null;
            }
            if (found < 0) {
                if (currentSearchIndex > 0) {
                    return this.searchChildren(line, startIndex, currentSearchIndex - 1);
                }
                return (ColumnBlock)this.children.get(0);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnBlock[startLine : ").append(this.startLine).append(" ,endLine : ").append(this.endLine).append(" ,columnBlockWidth : ").append(this.columnBlockWidth).append("] LINES:");
        for (i = 0; i < this.lines.size(); ++i) {
            buf.append('\n');
            buf.append("LINE ").append(i).append(':').append(this.lines.elementAt(i));
        }
        for (i = 0; i < this.children.size(); ++i) {
            buf.append('\n');
            buf.append("CHILD ").append(i).append(':').append(this.children.elementAt(i));
        }
        return buf.toString();
    }

    private void throwException(int offset, int line) {
        throw new IllegalArgumentException("{ELASTIC TABSTOP}CORRUPT DATA@{" + System.currentTimeMillis() + "} & Thread : " + Thread.currentThread().getName() + " :Cannot find the size for tab at offset " + (offset - this.buffer.getLineStartOffset(line)) + "in line " + line + "while searching in \n " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirtyStatus(boolean status) {
        Object object = this.buffer.columnBlockLock;
        synchronized (object) {
            this.isDirty = status;
        }
    }

    public void updateLineNo(int line) {
        int i;
        this.startLine += line;
        this.endLine += line;
        for (i = 0; i < this.lines.size(); ++i) {
            this.lines.elementAt(i).updateLineNo(line);
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((ColumnBlock)this.children.elementAt(i)).updateLineNo(line);
        }
    }

    public void updateColumnBlockLineOffset(int line, int offsetAdd, boolean increaseStartOffset) {
        if (line >= this.startLine && line <= this.endLine) {
            ColumnBlock block;
            if (this.lines != null && !this.lines.isEmpty()) {
                ColumnBlockLine blockLine = this.lines.get(line - this.startLine);
                if (increaseStartOffset) {
                    blockLine.colStartIndex += offsetAdd;
                }
                blockLine.colEndIndex += offsetAdd;
            }
            if (this.children != null && !this.children.isEmpty() && (block = this.searchChildren(line)) != null && block.isLineWithinThisBlock(line) == 0) {
                block.updateColumnBlockLineOffset(line, offsetAdd, true);
            }
        }
    }

    public void setTabSizeDirtyStatus(boolean dirty, boolean recursive) {
        this.tabSizesDirty = dirty;
        if (recursive && this.children != null && !this.children.isEmpty()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((ColumnBlock)this.children.elementAt(i)).setTabSizeDirtyStatus(true, true);
            }
        }
    }

    public boolean areTabSizesDirty() {
        return this.tabSizesDirty;
    }
}

