/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.Shell;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.jEdit;
import projectviewer.gui.OptionPaneBase;
import projectviewer.vpt.VPTProject;

public class ProjectCommandOptionPane
extends OptionPaneBase {
    private VPTProject proj;
    private JComboBox shell;
    private String _shell;
    private HistoryTextField compile;
    private HistoryTextField run;

    public ProjectCommandOptionPane(VPTProject proj) {
        super("pv.commands", "console");
        this.proj = proj;
    }

    protected void _init() {
        String _run;
        this.compile = new HistoryTextField("console.compile.project");
        this.run = new HistoryTextField("console.run.project");
        this.compile.setToolTipText(jEdit.getProperty((String)"options.pv.commands.tooltip"));
        this.run.setToolTipText(jEdit.getProperty((String)"options.pv.commands.tooltip"));
        this.shell = new JComboBox<String>(Shell.getShellNames());
        this.shell.setToolTipText(jEdit.getProperty((String)"options.pv.shell.tooltip"));
        this._shell = this.proj.getProperty("console.shell");
        if (this._shell != null && Shell.getShell(this._shell) == null) {
            this._shell = null;
        }
        if (this._shell == null) {
            this._shell = Console.shellForVFS(this.proj.getRootPath());
        }
        this.shell.setSelectedItem(this._shell);
        String _compile = this.proj.getProperty("console.compile");
        if (_compile != null) {
            this.compile.setText(_compile);
        }
        if ((_run = this.proj.getProperty("console.run")) != null) {
            this.run.setText(_run);
        }
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.pv.commands.help")));
        this.addComponent(jEdit.getProperty((String)"options.pv.commands.compile"), (Component)this.compile);
        this.addComponent(jEdit.getProperty((String)"options.pv.commands.run"), (Component)this.run);
        this.addComponent(jEdit.getProperty((String)"options.pv.shell"), this.shell);
    }

    protected void _save() {
        String favoriteShell;
        String rcmd;
        String ccmd = this.compile.getText();
        if (!ccmd.equals("")) {
            this.proj.setProperty("console.compile", this.compile.getText());
            this.compile.getModel().addItem(ccmd);
        }
        if (!(rcmd = this.run.getText()).equals("")) {
            this.run.getModel().addItem(rcmd);
            this.proj.setProperty("console.run", rcmd);
        }
        if (!(favoriteShell = this.shell.getSelectedItem().toString()).equals(this._shell)) {
            this.proj.setProperty("console.shell", favoriteShell);
        }
    }
}

