/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;

public class ThreadUtilities {
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new JEditThreadFactory());
    private static final int CORE_POOL_SIZE = 4;

    public static void runInDispatchThread(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void runInDispatchThreadAndWait(Runnable runnable) {
        boolean interrupted = false;
        MyRunnable run = new MyRunnable(runnable);
        ThreadUtilities.runInDispatchThread(run);
        while (run.done.getCount() > 0L) {
            try {
                run.done.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void runInDispatchThreadNow(Runnable runnable) {
        boolean interrupted = false;
        MyRunnable run = new MyRunnable(runnable);
        try {
            EventQueue.invokeAndWait(run);
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            Log.log(9, ThreadUtilities.class, "Invocation Target Exception:");
            Log.log(9, runnable.getClass(), cause);
        }
        while (run.done.getCount() > 0L) {
            try {
                run.done.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void runInBackground(Runnable runnable) {
        Task task = runnable instanceof Task ? (Task)runnable : TaskManager.decorate(runnable);
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    public static void runInBackground(Task task) {
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    private ThreadUtilities() {
    }

    static {
        ((ThreadPoolExecutor)threadPool).setCorePoolSize(4);
    }

    private static class MyRunnable
    implements Runnable {
        private final Runnable runnable;
        private CountDownLatch done = new CountDownLatch(1);

        private MyRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
            this.done.countDown();
        }
    }

    private static class JEditThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadIDs = new AtomicInteger(0);
        private final ThreadGroup threadGroup = new ThreadGroup("jEdit Workers");

        private JEditThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r);
            t.setName("jEdit Worker #" + this.threadIDs.getAndIncrement());
            return t;
        }
    }
}

