/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

class ChunkCache {
    private final TextArea textArea;
    private JEditBuffer buffer;
    private LineInfo[] lineInfo;
    private final List<Chunk> out;
    private int firstInvalidLine;
    private int lastScreenLineP;
    private int lastScreenLine;
    private boolean needFullRepaint;
    private final DisplayTokenHandler tokenHandler;

    ChunkCache(TextArea textArea) {
        this.textArea = textArea;
        this.out = new ArrayList<Chunk>();
        this.tokenHandler = new DisplayTokenHandler();
    }

    int getMaxHorizontalScrollWidth() {
        int max = 0;
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo info = this.lineInfo[i];
            if (info.width <= max) continue;
            max = info.width;
        }
        return max;
    }

    int getScreenLineOfOffset(int line, int offset) {
        if (this.lineInfo.length == 0) {
            return -1;
        }
        if (line < this.textArea.getFirstPhysicalLine()) {
            return -1;
        }
        if (line == this.textArea.getFirstPhysicalLine() && offset < this.getLineInfo((int)0).offset) {
            return -1;
        }
        if (line > this.textArea.getLastPhysicalLine()) {
            return -1;
        }
        if (line == this.lastScreenLineP) {
            LineInfo last = this.getLineInfo(this.lastScreenLine);
            if (offset >= last.offset && offset < last.offset + last.length) {
                return this.lastScreenLine;
            }
        }
        int screenLine = -1;
        for (int i = 0; i < this.textArea.getVisibleLines(); ++i) {
            LineInfo info = this.getLineInfo(i);
            if (info.physicalLine > line) {
                return i - 1;
            }
            if (info.physicalLine != line || offset < info.offset || offset >= info.offset + info.length) continue;
            screenLine = i;
            break;
        }
        if (screenLine == -1) {
            return -1;
        }
        this.lastScreenLineP = line;
        this.lastScreenLine = screenLine;
        return screenLine;
    }

    void recalculateVisibleLines() {
        int start;
        LineInfo[] newLineInfo = new LineInfo[this.textArea.getVisibleLines()];
        if (this.lineInfo == null) {
            start = 0;
        } else {
            start = Math.min(this.lineInfo.length, newLineInfo.length);
            System.arraycopy(this.lineInfo, 0, newLineInfo, 0, start);
        }
        for (int i = start; i < newLineInfo.length; ++i) {
            newLineInfo[i] = new LineInfo();
        }
        this.lineInfo = newLineInfo;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void setBuffer(JEditBuffer buffer) {
        this.buffer = buffer;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollDown(int amount) {
        int visibleLines = this.textArea.getVisibleLines();
        System.arraycopy(this.lineInfo, amount, this.lineInfo, 0, visibleLines - amount);
        for (int i = visibleLines - amount; i < visibleLines; ++i) {
            this.lineInfo[i] = new LineInfo();
        }
        this.firstInvalidLine -= amount;
        if (this.firstInvalidLine < 0) {
            this.firstInvalidLine = 0;
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            System.err.println("f > t.f: only " + amount + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void scrollUp(int amount) {
        System.arraycopy(this.lineInfo, 0, this.lineInfo, amount, this.textArea.getVisibleLines() - amount);
        for (int i = 0; i < amount; ++i) {
            this.lineInfo[i] = new LineInfo();
        }
        int oldFirstInvalidLine = this.firstInvalidLine;
        this.firstInvalidLine = 0;
        this.updateChunksUpTo(amount);
        this.firstInvalidLine = oldFirstInvalidLine + amount;
        if (this.firstInvalidLine > this.textArea.getVisibleLines()) {
            this.firstInvalidLine = this.textArea.getVisibleLines();
        }
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "f > t.f: only " + amount + " need updates");
        }
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateAll() {
        this.firstInvalidLine = 0;
        this.lastScreenLineP = -1;
        this.lastScreenLine = -1;
    }

    void invalidateChunksFromPhys(int physicalLine) {
        for (int i = 0; i < this.firstInvalidLine; ++i) {
            LineInfo info = this.lineInfo[i];
            if (info.physicalLine != -1 && info.physicalLine < physicalLine) continue;
            this.firstInvalidLine = i;
            if (i > this.lastScreenLine) break;
            this.lastScreenLineP = -1;
            this.lastScreenLine = -1;
            break;
        }
    }

    LineInfo getLineInfo(int screenLine) {
        this.updateChunksUpTo(screenLine);
        return this.lineInfo[screenLine];
    }

    int getLineSubregionCount(int physicalLine) {
        if (!this.textArea.softWrap) {
            return 1;
        }
        this.out.clear();
        this.lineToChunkList(physicalLine, this.out);
        int size = this.out.size();
        if (size == 0) {
            return 1;
        }
        return size;
    }

    static int getSubregionOfOffset(int offset, LineInfo[] lineInfos) {
        for (int i = 0; i < lineInfos.length; ++i) {
            LineInfo info = lineInfos[i];
            if (offset < info.offset || offset >= info.offset + info.length) continue;
            return i;
        }
        return -1;
    }

    int xToSubregionOffset(int physicalLine, int subregion, int x, boolean round) {
        LineInfo[] infos = this.getLineInfosForPhysicalLine(physicalLine);
        if (subregion == -1) {
            subregion += infos.length;
        }
        return ChunkCache.xToSubregionOffset(infos[subregion], x, round);
    }

    static int xToSubregionOffset(LineInfo info, int x, boolean round) {
        int offset = Chunk.xToOffset(info.chunks, x, round);
        if (offset == -1 || offset == info.offset + info.length) {
            offset = info.offset + info.length - 1;
        }
        return offset;
    }

    int subregionOffsetToX(int physicalLine, int offset) {
        LineInfo[] infos = this.getLineInfosForPhysicalLine(physicalLine);
        LineInfo info = infos[ChunkCache.getSubregionOfOffset(offset, infos)];
        return ChunkCache.subregionOffsetToX(info, offset);
    }

    static int subregionOffsetToX(LineInfo info, int offset) {
        return (int)Chunk.offsetToX(info.chunks, offset);
    }

    int getSubregionStartOffset(int line, int offset) {
        LineInfo[] lineInfos = this.getLineInfosForPhysicalLine(line);
        LineInfo info = lineInfos[ChunkCache.getSubregionOfOffset(offset, lineInfos)];
        return this.textArea.getLineStartOffset(info.physicalLine) + info.offset;
    }

    int getSubregionEndOffset(int line, int offset) {
        LineInfo[] lineInfos = this.getLineInfosForPhysicalLine(line);
        LineInfo info = lineInfos[ChunkCache.getSubregionOfOffset(offset, lineInfos)];
        return this.textArea.getLineStartOffset(info.physicalLine) + info.offset + info.length;
    }

    int getBelowPosition(int physicalLine, int offset, int x, boolean ignoreWrap) {
        LineInfo[] lineInfos = this.getLineInfosForPhysicalLine(physicalLine);
        int subregion = ChunkCache.getSubregionOfOffset(offset, lineInfos);
        if (subregion != lineInfos.length - 1 && !ignoreWrap) {
            return this.textArea.getLineStartOffset(physicalLine) + ChunkCache.xToSubregionOffset(lineInfos[subregion + 1], x, true);
        }
        int nextLine = this.textArea.displayManager.getNextVisibleLine(physicalLine);
        if (nextLine == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(nextLine) + this.xToSubregionOffset(nextLine, 0, x, true);
    }

    int getAbovePosition(int physicalLine, int offset, int x, boolean ignoreWrap) {
        LineInfo[] lineInfos = this.getLineInfosForPhysicalLine(physicalLine);
        int subregion = ChunkCache.getSubregionOfOffset(offset, lineInfos);
        if (subregion != 0 && !ignoreWrap) {
            return this.textArea.getLineStartOffset(physicalLine) + ChunkCache.xToSubregionOffset(lineInfos[subregion - 1], x, true);
        }
        int prevLine = this.textArea.displayManager.getPrevVisibleLine(physicalLine);
        if (prevLine == -1) {
            return -1;
        }
        return this.textArea.getLineStartOffset(prevLine) + this.xToSubregionOffset(prevLine, -1, x, true);
    }

    boolean needFullRepaint() {
        boolean retVal = this.needFullRepaint;
        this.needFullRepaint = false;
        return retVal;
    }

    LineInfo[] getLineInfosForPhysicalLine(int physicalLine) {
        this.out.clear();
        if (!this.buffer.isLoading()) {
            this.lineToChunkList(physicalLine, this.out);
        }
        if (this.out.isEmpty()) {
            this.out.add(null);
        }
        ArrayList<LineInfo> returnValue = new ArrayList<LineInfo>(this.out.size());
        this.getLineInfosForPhysicalLine(physicalLine, returnValue);
        return returnValue.toArray(new LineInfo[this.out.size()]);
    }

    private void getLineInfosForPhysicalLine(int physicalLine, List<LineInfo> list) {
        for (int i = 0; i < this.out.size(); ++i) {
            Chunk chunks = this.out.get(i);
            LineInfo info = new LineInfo();
            info.physicalLine = physicalLine;
            if (i == 0) {
                info.firstSubregion = true;
                info.offset = 0;
            } else {
                info.offset = chunks.offset;
            }
            if (i == this.out.size() - 1) {
                info.lastSubregion = true;
                info.length = this.textArea.getLineLength(physicalLine) - info.offset + 1;
            } else {
                info.length = this.out.get((int)(i + 1)).offset - info.offset;
            }
            info.chunks = chunks;
            list.add(info);
        }
    }

    private int getFirstScreenLine() {
        for (int i = this.firstInvalidLine - 1; i >= 0; --i) {
            if (!this.lineInfo[i].lastSubregion) continue;
            return i + 1;
        }
        return 0;
    }

    private int getUpdateStartLine(int firstScreenLine) {
        if (firstScreenLine == 0) {
            return this.textArea.getFirstPhysicalLine();
        }
        int prevPhysLine = this.lineInfo[firstScreenLine - 1].physicalLine;
        if (prevPhysLine == -1) {
            return -1;
        }
        return this.textArea.displayManager.getNextVisibleLine(prevPhysLine);
    }

    private void updateChunksUpTo(int lastScreenLine) {
        if (lastScreenLine >= this.lineInfo.length) {
            throw new ArrayIndexOutOfBoundsException(lastScreenLine);
        }
        if (lastScreenLine < this.firstInvalidLine) {
            return;
        }
        int firstScreenLine = this.getFirstScreenLine();
        int physicalLine = this.getUpdateStartLine(firstScreenLine);
        if (Debug.CHUNK_CACHE_DEBUG) {
            Log.log(1, this, "Updating chunks from " + firstScreenLine + " to " + lastScreenLine);
        }
        this.out.clear();
        for (int i = firstScreenLine; i <= lastScreenLine; ++i) {
            int length;
            int offset;
            Chunk chunks;
            LineInfo info = this.lineInfo[i];
            if (this.out.isEmpty()) {
                if (physicalLine != -1 && i != firstScreenLine) {
                    physicalLine = this.textArea.displayManager.getNextVisibleLine(physicalLine);
                }
                if (physicalLine == -1) {
                    info.chunks = null;
                    info.physicalLine = -1;
                    info.width = 0;
                    continue;
                }
                this.lineToChunkList(physicalLine, this.out);
                info.firstSubregion = true;
                if (this.out.isEmpty()) {
                    if (i == 0 && this.textArea.displayManager.firstLine.getSkew() > 0) {
                        Log.log(9, this, "BUG: skew=" + this.textArea.displayManager.firstLine.getSkew() + ",out.size()=" + this.out.size());
                        this.textArea.displayManager.firstLine.setSkew(0);
                        this.needFullRepaint = true;
                        lastScreenLine = this.lineInfo.length - 1;
                    }
                    chunks = null;
                    offset = 0;
                    length = 1;
                } else {
                    if (i == 0) {
                        int skew = this.textArea.displayManager.firstLine.getSkew();
                        if (skew >= this.out.size()) {
                            Log.log(9, this, "BUG: skew=" + skew + ",out.size()=" + this.out.size());
                            this.needFullRepaint = true;
                            lastScreenLine = this.lineInfo.length - 1;
                        } else if (skew > 0) {
                            info.firstSubregion = false;
                            for (int j = 0; j < skew; ++j) {
                                this.out.remove(0);
                            }
                        }
                    }
                    chunks = this.out.remove(0);
                    offset = chunks.offset;
                    length = !this.out.isEmpty() ? this.out.get((int)0).offset - offset : this.textArea.getLineLength(physicalLine) - offset + 1;
                }
            } else {
                info.firstSubregion = false;
                chunks = this.out.remove(0);
                offset = chunks.offset;
                length = !this.out.isEmpty() ? this.out.get((int)0).offset - offset : this.textArea.getLineLength(physicalLine) - offset + 1;
            }
            boolean lastSubregion = this.out.isEmpty();
            if (i == lastScreenLine && lastScreenLine != this.lineInfo.length - 1) {
                if (this.tokenHandler.getLineContext() != info.lineContext) {
                    ++lastScreenLine;
                    this.needFullRepaint = true;
                } else if (info.physicalLine != physicalLine || info.lastSubregion != lastSubregion) {
                    ++lastScreenLine;
                    this.needFullRepaint = true;
                } else if (!this.out.isEmpty()) {
                    ++lastScreenLine;
                }
            }
            info.physicalLine = physicalLine;
            info.lastSubregion = lastSubregion;
            info.offset = offset;
            info.length = length;
            info.chunks = chunks;
            info.lineContext = this.tokenHandler.getLineContext();
        }
        this.firstInvalidLine = Math.max(lastScreenLine + 1, this.firstInvalidLine);
    }

    private void lineToChunkList(int physicalLine, List<Chunk> out) {
        TextAreaPainter painter = this.textArea.getPainter();
        TabExpander expander = this.textArea.getTabExpander();
        this.tokenHandler.init(painter.getStyles(), painter.getFontRenderContext(), expander, out, this.textArea.softWrap ? (float)this.textArea.wrapMargin : 0.0f, this.buffer.getLineStartOffset(physicalLine));
        this.buffer.markTokens(physicalLine, this.tokenHandler);
    }

    static class LineInfo {
        int physicalLine;
        int offset;
        int length;
        boolean firstSubregion;
        boolean lastSubregion;
        Chunk chunks;
        int width;
        TokenMarker.LineContext lineContext;

        LineInfo() {
        }

        public String toString() {
            return "LineInfo[" + this.physicalLine + ',' + this.offset + ',' + this.length + ',' + this.firstSubregion + ',' + this.lastSubregion + "]";
        }
    }
}

