/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import org.gjt.sp.jedit.search.SearchMatcher;

public class BoyerMooreSearchMatcher
extends SearchMatcher {
    private char[] pattern;
    private int pattern_end;
    private boolean ignoreCase;
    private int[] fwd_skip;
    private int[] fwd_suffix;
    private int[] back_skip;
    private int[] back_suffix;

    public BoyerMooreSearchMatcher(String pattern, boolean ignoreCase) {
        this(pattern, ignoreCase, false);
    }

    public BoyerMooreSearchMatcher(String pattern, boolean ignoreCase, boolean wholeWord) {
        this.pattern = pattern.toCharArray();
        if (ignoreCase) {
            for (int i = 0; i < this.pattern.length; ++i) {
                this.pattern[i] = Character.toUpperCase(this.pattern[i]);
            }
        }
        this.ignoreCase = ignoreCase;
        this.pattern_end = this.pattern.length - 1;
        this.wholeWord = wholeWord;
    }

    @Override
    public SearchMatcher.Match nextMatch(CharSequence text, boolean start, boolean end, boolean firstTime, boolean reverse) {
        int pos = this.match(text, reverse);
        if (pos == -1) {
            return null;
        }
        this.returnValue.start = pos;
        int _end = this.returnValue.end = pos + this.pattern.length;
        if (this.wholeWord) {
            CharSequence subText = text;
            while (!this.isWholeWord(text, this.returnValue.start, this.returnValue.end)) {
                SearchMatcher.Match match = this.nextMatch(subText = subText.subSequence(this.returnValue.end, text.length()), start, end, firstTime, reverse);
                if (match == null) {
                    return null;
                }
                match.start += _end;
                _end += match.end;
                match.end = match.start + this.pattern.length;
            }
        }
        return this.returnValue;
    }

    public int match(CharSequence text, boolean reverse) {
        int[] suffix;
        int[] skip;
        if (reverse) {
            if (this.back_skip == null) {
                this.back_skip = this.generateSkipArray(true);
                this.back_suffix = this.generateSuffixArray(true);
            }
            skip = this.back_skip;
            suffix = this.back_suffix;
        } else {
            if (this.fwd_skip == null) {
                this.fwd_skip = this.generateSkipArray(false);
                this.fwd_suffix = this.generateSuffixArray(false);
            }
            skip = this.fwd_skip;
            suffix = this.fwd_suffix;
        }
        int anchor = 0;
        char ch = '\u0000';
        block0: while (anchor + this.pattern_end < text.length()) {
            for (int pos = this.pattern_end; pos >= 0; --pos) {
                ch = text.charAt(pos + anchor);
                if (this.ignoreCase) {
                    ch = Character.toUpperCase(ch);
                }
                if (!(reverse ? ch != this.pattern[this.pattern_end - pos] : ch != this.pattern[pos])) continue;
                int bad_char = pos - skip[BoyerMooreSearchMatcher.getSkipIndex(ch)];
                int good_suffix = suffix[pos];
                int skip_index = bad_char > good_suffix ? bad_char : good_suffix;
                anchor += skip_index;
                continue block0;
            }
            return anchor;
        }
        return -1;
    }

    public String toString() {
        return "BoyerMooreSearchMatcher[" + new String(this.pattern) + ',' + this.ignoreCase + ']';
    }

    private int[] generateSkipArray(boolean reverse) {
        int[] skip = new int[256];
        if (this.pattern.length == 0) {
            return skip;
        }
        int pos = 0;
        do {
            skip[BoyerMooreSearchMatcher.getSkipIndex((char)this.pattern[reverse ? this.pattern_end - pos : pos])] = pos++;
        } while (pos < this.pattern.length);
        return skip;
    }

    private static int getSkipIndex(char ch) {
        return ch & 0xFF;
    }

    private int[] generateSuffixArray(boolean reverse) {
        int m = this.pattern.length;
        int j = m + 1;
        int[] suffix = new int[j];
        int[] tmp = new int[j];
        tmp[m] = j;
        for (int i = m; i > 0; --i) {
            while (j <= m && this.pattern[reverse ? this.pattern_end - i + 1 : i - 1] != this.pattern[reverse ? this.pattern_end - j + 1 : j - 1]) {
                if (suffix[j] == 0) {
                    suffix[j] = j - i;
                }
                j = tmp[j];
            }
            tmp[i - 1] = --j;
        }
        int k = tmp[0];
        for (j = 0; j <= m; ++j) {
            if (j > 0) {
                int n = suffix[j - 1] = suffix[j] == 0 ? k : suffix[j];
            }
            if (j != k) continue;
            k = tmp[k];
        }
        return suffix;
    }
}

