/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaClassWrapperFactory;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.ScriptableDelegate;
import org.lobobrowser.util.Objects;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class JavaScript {
    private static JavaScript instance = new JavaScript();
    private final WeakHashMap javaObjectToWrapper = new WeakHashMap();

    public static JavaScript getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getJavascriptObject(Object object, Scriptable scriptable) {
        if (object instanceof String || object instanceof Scriptable) {
            return object;
        }
        if (object == null) {
            return null;
        }
        if (object.getClass().isPrimitive()) {
            return object;
        }
        if (object instanceof ScriptableDelegate) {
            JavaScript javaScript = this;
            synchronized (javaScript) {
                Object object2 = ((ScriptableDelegate)object).getScriptable();
                if (object2 == null) {
                    JavaObjectWrapper javaObjectWrapper = new JavaObjectWrapper(JavaClassWrapperFactory.getInstance().getClassWrapper(object.getClass()), object);
                    object2 = javaObjectWrapper;
                    javaObjectWrapper.setParentScope(scriptable);
                    ((ScriptableDelegate)object).setScriptable((Scriptable)javaObjectWrapper);
                }
                object2.setParentScope(scriptable);
                return object2;
            }
        }
        if (Objects.isBoxClass(object.getClass())) {
            return object;
        }
        WeakHashMap weakHashMap = this.javaObjectToWrapper;
        synchronized (weakHashMap) {
            WeakReference weakReference = (WeakReference)this.javaObjectToWrapper.get(object);
            JavaObjectWrapper javaObjectWrapper = null;
            if (weakReference != null) {
                javaObjectWrapper = (JavaObjectWrapper)((Object)weakReference.get());
            }
            if (javaObjectWrapper == null) {
                Class<?> clazz = object.getClass();
                JavaClassWrapper javaClassWrapper = JavaClassWrapperFactory.getInstance().getClassWrapper(clazz);
                javaObjectWrapper = new JavaObjectWrapper(javaClassWrapper, object);
                this.javaObjectToWrapper.put(object, new WeakReference<JavaObjectWrapper>(javaObjectWrapper));
            }
            javaObjectWrapper.setParentScope(scriptable);
            return javaObjectWrapper;
        }
    }

    private static String getStringValue(Object object) {
        if (object instanceof Undefined) {
            return "undefined";
        }
        if (object instanceof Scriptable) {
            return (String)((Scriptable)object).getDefaultValue(String.class);
        }
        return String.valueOf(object);
    }

    public Object getJavaObject(Object object, Class clazz) {
        if (object instanceof JavaObjectWrapper) {
            Object object2 = ((JavaObjectWrapper)((Object)object)).getJavaObject();
            if (String.class == clazz) {
                return String.valueOf(object2);
            }
            return object2;
        }
        if (object == null) {
            return null;
        }
        if (clazz == String.class) {
            if (object instanceof String) {
                return object;
            }
            if (object instanceof Double) {
                String string = String.valueOf(object);
                if (string.endsWith(".0")) {
                    return string.substring(0, string.length() - 2);
                }
                return string;
            }
            return JavaScript.getStringValue(object);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (object instanceof Double) {
                return new Integer(((Double)object).intValue());
            }
            if (object instanceof Integer) {
                return object;
            }
            if (object instanceof String) {
                return Integer.valueOf((String)object);
            }
            if (object instanceof Short) {
                return new Integer(((Short)object).shortValue());
            }
            if (object instanceof Long) {
                return new Integer(((Long)object).intValue());
            }
            if (object instanceof Float) {
                return new Integer(((Float)object).intValue());
            }
            return object;
        }
        return object;
    }
}

