/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaException;

public class JEditTextArea
extends TextArea {
    private View view;
    public static final String FOLD_PAINTER_PROPERTY = "foldPainter";
    public static final String FOLD_PAINTER_SERVICE = "org.gjt.sp.jedit.textarea.FoldPainter";
    public static final String DEFAULT_FOLD_PAINTER_SERVICE = "Triangle";

    public JEditTextArea(View view) {
        super(jEdit.getPropertyManager(), view);
        this.enableEvents(12L);
        this.view = view;
        this.setRightClickPopupEnabled(true);
        this.painter.setLineExtraSpacing(jEdit.getIntegerProperty("options.textarea.lineSpacing", 0));
        EditBus.addToBus(this);
    }

    @Override
    public void dispose() {
        EditBus.removeFromBus(this);
        super.dispose();
    }

    @Override
    public FoldPainter getFoldPainter() {
        FoldPainter foldPainter = (FoldPainter)ServiceManager.getService(FOLD_PAINTER_SERVICE, JEditTextArea.getFoldPainterName());
        if (foldPainter == null) {
            foldPainter = (FoldPainter)ServiceManager.getService(FOLD_PAINTER_SERVICE, DEFAULT_FOLD_PAINTER_SERVICE);
        }
        return foldPainter;
    }

    @Override
    public void home(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + select + ");");
                }
                this.goToStartOfWhiteSpace(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + select + ");");
                }
                this.goToStartOfLine(select);
            }
        }
    }

    @Override
    public void end(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + select + ");");
                }
                this.goToEndOfWhiteSpace(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + select + ");");
                }
                this.goToEndOfLine(select);
            }
        }
    }

    @Override
    public void smartHome(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + select + ");");
                }
                this.goToStartOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + select + ");");
                }
                this.goToStartOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToFirstVisibleLine(" + select + ");");
                }
                this.goToFirstVisibleLine(select);
            }
        }
    }

    @Override
    public void smartEnd(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + select + ");");
                }
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + select + ");");
                }
                this.goToEndOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToLastVisibleLine(" + select + ");");
                }
                this.goToLastVisibleLine(select);
            }
        }
    }

    @Override
    public void goToBufferEnd(boolean select) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferEnd(select);
    }

    @Override
    public void goToMatchingBracket() {
        int dot;
        int bracket;
        if (this.getLineLength(this.caretLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (dot = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            EditBus.send(new PositionChanging(this));
            this.selectNone();
            this.moveCaretPosition(bracket + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    @Override
    public void goToBufferStart(boolean select) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferStart(select);
    }

    @Override
    public int replaceSelection(String selectedText) {
        EditBus.send(new PositionChanging(this));
        return super.replaceSelection(selectedText);
    }

    public void showGoToLineDialog() {
        int maxLine = this.buffer.getLineCount();
        String line = GUIUtilities.input(this.view, "goto-line", new Integer[]{1, maxLine}, null);
        if (line == null) {
            return;
        }
        try {
            int lineNumber = Integer.parseInt(line) - 1;
            if (lineNumber > --maxLine) {
                lineNumber = maxLine;
            }
            EditBus.send(new PositionChanging(this));
            this.setCaretPosition(this.getLineStartOffset(lineNumber));
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
    }

    @Override
    public void userInput(char ch) {
        if (ch == ' ' && Abbrevs.getExpandOnInput() && Abbrevs.expandAbbrev(this.view, false)) {
            return;
        }
        super.userInput(ch);
    }

    @Override
    public void addExplicitFold() {
        try {
            super.addExplicitFold();
        }
        catch (TextAreaException e) {
            GUIUtilities.error(this.view, "folding-not-explicit", null);
        }
    }

    @Override
    public void formatParagraph() {
        try {
            super.formatParagraph();
        }
        catch (TextAreaException e) {
            GUIUtilities.error(this.view, "format-maxlinelen", null);
        }
    }

    protected static void doWordCount(View view, String text) {
        char[] chars = text.toCharArray();
        int characters = chars.length;
        int words = 0;
        int lines = 1;
        boolean word = true;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\n': 
                case '\r': {
                    ++lines;
                }
                case '\t': 
                case ' ': {
                    word = true;
                    continue block4;
                }
                default: {
                    if (!word) continue block4;
                    ++words;
                    word = false;
                }
            }
        }
        Object[] args = new Object[]{characters, words, lines};
        GUIUtilities.message(view, "wordcount", args);
    }

    public void showWordCountDialog() {
        String selection = this.getSelectedText();
        if (selection != null) {
            JEditTextArea.doWordCount(this.view, selection);
            return;
        }
        JEditTextArea.doWordCount(this.view, this.buffer.getText(0, this.buffer.getLength()));
    }

    public View getView() {
        return this.view;
    }

    public static String getFoldPainterName() {
        return jEdit.getProperty(FOLD_PAINTER_PROPERTY, DEFAULT_FOLD_PAINTER_SERVICE);
    }

    @Override
    public void handlePopupTrigger(MouseEvent evt) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.createPopupMenu(evt);
            int x = evt.getX();
            int y = evt.getY();
            int dragStart = this.xyToOffset(x, y, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
            if (this.getSelectionCount() == 0 || this.multi) {
                this.moveCaretPosition(dragStart, false);
            }
            GUIUtilities.showPopupMenu(this.popup, this.painter, x, y);
        }
    }

    @Override
    public void createPopupMenu(MouseEvent evt) {
        this.popup = GUIUtilities.loadPopupMenu("view.context", this, evt);
        if (!jEdit.getBooleanProperty("options.context.includeOptionsLink")) {
            return;
        }
        JMenuItem customize = new JMenuItem(jEdit.getProperty("view.context.customize"));
        customize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new GlobalOptions((Frame)JEditTextArea.this.view, "context");
            }
        });
        this.popup.addSeparator();
        this.popup.add(customize);
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.painter.setLineExtraSpacing(jEdit.getIntegerProperty("options.textarea.lineSpacing", 0));
    }
}

