/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.StandardUtilities;

public class SyntaxHiliteOptionPane
extends AbstractOptionPane {
    public static final EmptyBorder noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private StyleTableModel styleModel;
    private JTable styleTable;

    public SyntaxHiliteOptionPane() {
        super("syntax");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout(6, 6));
        this.add("Center", this.createStyleTableScroller());
    }

    @Override
    protected void _save() {
        this.styleModel.save();
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = SyntaxHiliteOptionPane.createStyleTableModel();
        this.styleTable = new JTable(this.styleModel);
        this.styleTable.setRowSelectionAllowed(false);
        this.styleTable.setColumnSelectionAllowed(false);
        this.styleTable.setCellSelectionEnabled(false);
        this.styleTable.getTableHeader().setReorderingAllowed(false);
        this.styleTable.addMouseListener(new MouseHandler());
        TableColumnModel tcm = this.styleTable.getColumnModel();
        TableColumn styleColumn = tcm.getColumn(1);
        styleColumn.setCellRenderer(new StyleTableModel.StyleRenderer());
        Dimension d = this.styleTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.styleTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private static StyleTableModel createStyleTableModel() {
        return new StyleTableModel();
    }

    private static class StyleTableModel
    extends AbstractTableModel {
        private final List<StyleChoice> styleChoices = new Vector<StyleChoice>(23);

        StyleTableModel() {
            for (int i = 1; i < 19; ++i) {
                String tokenName = Token.tokenToString((byte)i);
                this.addStyleChoice(tokenName, "view.style." + tokenName.toLowerCase());
            }
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.1"), "view.style.foldLine.1");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.2"), "view.style.foldLine.2");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.3"), "view.style.foldLine.3");
            this.addStyleChoice(jEdit.getProperty("options.syntax.foldLine.0"), "view.style.foldLine.0");
            Collections.sort(this.styleChoices, new StandardUtilities.StringCompare(true));
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.styleChoices.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StyleChoice ch = this.styleChoices.get(row);
            switch (col) {
                case 0: {
                    return ch.label;
                }
                case 1: {
                    return ch.style;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            StyleChoice ch = this.styleChoices.get(row);
            if (col == 1) {
                ch.style = (SyntaxStyle)value;
            }
            this.fireTableRowsUpdated(row, row);
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.syntax.object");
                }
                case 1: {
                    return jEdit.getProperty("options.syntax.style");
                }
            }
            return null;
        }

        public void save() {
            for (int i = 0; i < this.styleChoices.size(); ++i) {
                StyleChoice ch = this.styleChoices.get(i);
                jEdit.setProperty(ch.property, GUIUtilities.getStyleString(ch.style));
            }
        }

        private void addStyleChoice(String label, String property) {
            this.styleChoices.add(new StyleChoice(label, property, GUIUtilities.parseStyle(jEdit.getProperty(property), "Dialog", 12)));
        }

        static class StyleRenderer
        extends JLabel
        implements TableCellRenderer {
            StyleRenderer() {
                this.setOpaque(true);
                this.setBorder(noFocusBorder);
                this.setText("Hello World");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
                if (value != null) {
                    SyntaxStyle style = (SyntaxStyle)value;
                    this.setForeground(style.getForegroundColor());
                    if (style.getBackgroundColor() != null) {
                        this.setBackground(style.getBackgroundColor());
                    } else {
                        this.setBackground(jEdit.getColorProperty("view.bgColor"));
                    }
                    this.setFont(style.getFont());
                }
                this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        }

        private static class StyleChoice {
            private String label;
            private String property;
            private SyntaxStyle style;

            StyleChoice(String label, String property, SyntaxStyle style) {
                this.label = label;
                this.property = property;
                this.style = style;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            SyntaxStyle style;
            int row = SyntaxHiliteOptionPane.this.styleTable.rowAtPoint(evt.getPoint());
            if (row == -1) {
                return;
            }
            SyntaxStyle current = (SyntaxStyle)SyntaxHiliteOptionPane.this.styleModel.getValueAt(row, 1);
            String token = (String)SyntaxHiliteOptionPane.this.styleModel.getValueAt(row, 0);
            JDialog dialog = GUIUtilities.getParentDialog(SyntaxHiliteOptionPane.this);
            if (dialog != null) {
                style = new StyleEditor(dialog, current, token).getStyle();
            } else {
                View view = GUIUtilities.getView(SyntaxHiliteOptionPane.this);
                style = new StyleEditor(view, current, token).getStyle();
            }
            if (style != null) {
                SyntaxHiliteOptionPane.this.styleModel.setValueAt(style, row, 1);
            }
        }
    }
}

