/*
 * Decompiled with CFR 0.152.
 */
package macosx;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import macosx.OSXAdapter;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AboutDialog;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.options.CombinedOptions;

public class MacOSXPlugin
extends EBPlugin {
    private static final Pattern ctrlPat = Pattern.compile("\\bctrl\\b");
    private boolean fullScreenFailed = false;

    public void start() {
        if (this.osok()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MacOSXPlugin macOSXPlugin = MacOSXPlugin.this;
                        Class<?> clazz = ((Object)((Object)macOSXPlugin)).getClass();
                        OSXAdapter.setQuitHandler((Object)macOSXPlugin, clazz.getDeclaredMethod("handleQuit", null));
                        OSXAdapter.setAboutHandler((Object)macOSXPlugin, clazz.getDeclaredMethod("handleAbout", null));
                        OSXAdapter.setPreferencesHandler((Object)macOSXPlugin, clazz.getDeclaredMethod("handlePreferences", null));
                        OSXAdapter.setFileHandler((Object)macOSXPlugin, clazz.getDeclaredMethod("handleOpenFile", String.class));
                        OSXAdapter.setReOpenApplicationHandler((Object)macOSXPlugin, clazz.getDeclaredMethod("handleReOpenApplication", null));
                        String string = jEdit.getProperty((String)"lookAndFeel");
                        if (string != null && string.length() != 0 && !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                            Log.log((int)1, (Object)this, (Object)"Fixing keybindingds on current LNF");
                            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                            MacOSXPlugin.fixMacKeyBindings(uIDefaults);
                        }
                    }
                    catch (Exception exception) {
                        Log.log((int)9, (Object)this, (Object)"Error while loading the OSXAdapter:", (Throwable)exception);
                    }
                }
            };
            ThreadUtilities.runInDispatchThread((Runnable)runnable);
            Debug.ALT_KEY_PRESSED_DISABLED = jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.disableOption");
            boolean bl = MacOSXPlugin.isCtrlAltSwapped();
            if (bl) {
                MacOSXPlugin.setCtrlAltSwapped(true);
            }
        }
    }

    public void stop() {
    }

    public boolean handleQuit() {
        jEdit.exit((View)jEdit.getActiveView(), (boolean)true);
        return false;
    }

    public void handlePreferences() {
        new CombinedOptions((Frame)jEdit.getActiveView());
    }

    public void handleAbout() {
        new AboutDialog(jEdit.getActiveView());
    }

    public void handleOpenFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            if (jEdit.isStartupDone()) {
                View view = jEdit.getActiveView();
                if (view == null) {
                    view = PerspectiveManager.loadPerspective((jEdit.getBooleanProperty((String)"restore") && jEdit.getBooleanProperty((String)"restore.cli") ? 1 : 0) != 0);
                }
                if (jEdit.openFile((View)view, (String)file.getPath()) == null) {
                    Log.log((int)9, (Object)((Object)this), (Object)("Unable to open file: " + string));
                }
            } else {
                jEdit.openFileAfterStartup((String)file.getPath());
            }
        } else {
            Log.log((int)9, (Object)((Object)this), (Object)("Cannot open non-existing file: " + string));
        }
    }

    public void handleReOpenApplication() {
        if (jEdit.getActiveView() != null) {
            jEdit.getActiveView().requestFocus();
        } else {
            PerspectiveManager.loadPerspective((boolean)jEdit.getBooleanProperty((String)"restore"));
        }
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            View[] viewArray;
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            Buffer buffer = bufferUpdate.getBuffer();
            for (View view : viewArray = jEdit.getViews()) {
                if (view.getBuffer() != buffer) continue;
                this.refreshProxyIcon(view);
            }
        } else if (eBMessage instanceof ViewUpdate) {
            ViewUpdate viewUpdate = (ViewUpdate)eBMessage;
            this.refreshProxyIcon(viewUpdate.getView());
            if (viewUpdate.getWhat() == ViewUpdate.CREATED) {
                this.enableFullScreenMode(viewUpdate.getView());
            }
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            this.refreshProxyIcon(editPaneUpdate.getEditPane().getView());
        }
    }

    public void refreshProxyIcon(View view) {
        if (view == null) {
            return;
        }
        Buffer buffer = view.getBuffer();
        if (buffer == null) {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("Window.documentFile", null);
            return;
        }
        if (buffer.isDirty()) {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            view.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        } else {
            view.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            view.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        }
        if (buffer.isNewFile()) {
            view.getRootPane().putClientProperty("Window.documentFile", null);
        } else {
            view.getRootPane().putClientProperty("Window.documentFile", new File(buffer.getPath()));
        }
    }

    public static void fixMacKeyBindings(UIDefaults uIDefaults) {
        Object[] objectArray;
        for (Object object : objectArray = uIDefaults.keySet().toArray()) {
            InputMap inputMap;
            KeyStroke[] keyStrokeArray;
            Object object2 = uIDefaults.get(object);
            if (!(object2 instanceof InputMap) || (keyStrokeArray = (inputMap = (InputMap)object2).keys()) == null) continue;
            for (KeyStroke keyStroke : keyStrokeArray) {
                String string = keyStroke.toString();
                if (string.indexOf("ctrl ") < 0) continue;
                Object object3 = inputMap.get(keyStroke);
                string = ctrlPat.matcher(string).replaceAll("meta");
                inputMap.remove(keyStroke);
                keyStroke = KeyStroke.getKeyStroke(string);
                inputMap.put(keyStroke, object3);
            }
        }
    }

    public static boolean isCtrlAltSwapped() {
        return jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.ctrlAltSwapped");
    }

    public static void setCtrlAltSwapped(boolean bl) {
        boolean bl2 = MacOSXPlugin.isCtrlAltSwapped();
        jEdit.setBooleanProperty((String)"plugin.MacOSXPlugin.ctrlAltSwapped", (boolean)bl);
        if (bl) {
            KeyEventTranslator.setModifierMapping((int)2, (int)4, (int)8, (int)1);
        } else if (bl2) {
            KeyEventTranslator.setModifierMapping((int)4, (int)2, (int)8, (int)1);
        }
    }

    public static void setDisableOption(boolean bl) {
        Debug.ALT_KEY_PRESSED_DISABLED = bl;
        jEdit.setBooleanProperty((String)"plugin.MacOSXPlugin.disableOption", (boolean)bl);
    }

    public static boolean getDisableOption() {
        return jEdit.getBooleanProperty((String)"plugin.MacOSXPlugin.disableOption");
    }

    public void enableFullScreenMode(View view) {
        if (this.fullScreenFailed) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] classArray = new Class[]{Window.class, Boolean.TYPE};
            Method method = clazz.getMethod("setWindowCanFullScreen", classArray);
            method.invoke(clazz, view, true);
        }
        catch (Exception exception) {
            Log.log((int)1, (Object)((Object)this), (Object)("Unable to enable OS X native full screen mode: " + exception));
            this.fullScreenFailed = true;
        }
    }

    private boolean osok() {
        if (!OperatingSystem.isMacOS()) {
            Log.log((int)9, (Object)((Object)this), (Object)jEdit.getProperty((String)"MacOSXPlugin.dialog.osname.message"));
            return false;
        }
        return true;
    }
}

