/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks;

import gatchan.jedit.hyperlinks.Hyperlink;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class HyperlinkTextAreaPainter
extends TextAreaExtension {
    private final JEditTextArea textArea;
    private Hyperlink hyperLink;
    static Color color;

    public HyperlinkTextAreaPainter(JEditTextArea textArea) {
        this.textArea = textArea;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        Hyperlink link = this.hyperLink;
        if (link == null) {
            return;
        }
        if (link.getStartLine() != physicalLine) {
            return;
        }
        Point startPoint = this.textArea.offsetToXY(link.getStartOffset());
        if (startPoint == null) {
            return;
        }
        int startX = startPoint.x;
        Point endPoint = this.textArea.offsetToXY(link.getEndOffset());
        if (endPoint == null) {
            return;
        }
        int endX = endPoint.x;
        gfx.setColor(color);
        FontMetrics fm = this.textArea.getPainter().getFontMetrics();
        gfx.drawLine(startX, (y += fm.getAscent()) + 1, endX, y + 1);
    }

    public String getToolTipText(int x, int y) {
        Hyperlink link = this.hyperLink;
        if (link == null) {
            return null;
        }
        int offset = this.textArea.xyToOffset(x, y);
        if (this.hyperLink.getStartOffset() <= offset && this.hyperLink.getEndOffset() >= offset) {
            return this.hyperLink.getTooltip();
        }
        return null;
    }

    public Hyperlink getHyperLink() {
        return this.hyperLink;
    }

    public void setHyperLink(Hyperlink hyperLink) {
        if (hyperLink != this.hyperLink) {
            if (hyperLink == null) {
                int line = this.hyperLink.getStartLine();
                this.textArea.invalidateLine(line);
            } else {
                int lineNew = hyperLink.getStartLine();
                this.textArea.invalidateLine(lineNew);
                if (this.hyperLink != null) {
                    int lineOld = this.hyperLink.getStartLine();
                    this.textArea.invalidateLine(lineOld);
                }
            }
            this.hyperLink = hyperLink;
        }
    }
}

