/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.Objects;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class JavaFunctionObject
extends ScriptableObject
implements Function {
    private static final Logger logger = Logger.getLogger(JavaFunctionObject.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private final String className;
    private final ArrayList methods = new ArrayList();

    public JavaFunctionObject(String string) {
        this.className = string;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public String getClassName() {
        return this.className;
    }

    private String getTypeName(Object object) {
        return object == null ? "[null]" : object.getClass().getName();
    }

    private Method getBestMethod(Object[] objectArray) {
        ArrayList arrayList = this.methods;
        int n = arrayList.size();
        int n2 = 0;
        Method method = null;
        for (int i = 0; i < n; ++i) {
            Method method2 = (Method)arrayList.get(i);
            Class[] classArray = method2.getParameterTypes();
            if (objectArray == null) {
                if (classArray != null && classArray.length != 0) continue;
                return method2;
            }
            if (classArray == null || objectArray.length < classArray.length) continue;
            if (Objects.areAssignableTo(objectArray, classArray)) {
                return method2;
            }
            if (method != null && classArray.length <= n2) continue;
            n2 = classArray.length;
            method = method2;
        }
        if (n == 0) {
            throw new IllegalStateException("zero methods");
        }
        return method;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Object object2;
        JavaObjectWrapper javaObjectWrapper = (JavaObjectWrapper)scriptable2;
        Method method = this.getBestMethod(objectArray);
        if (method == null) {
            throw new EvaluatorException("No method matching " + this.className + " with " + (objectArray == null ? 0 : objectArray.length) + " arguments.");
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        Object[] objectArray2 = objectArray == null ? new Object[]{} : new Object[n];
        boolean bl = loggableInfo;
        if (bl) {
            object2 = javaObjectWrapper.getJavaObject();
            logger.info("call(): Calling method " + method.getName() + " on object " + object2 + " of type " + this.getTypeName(object2));
        }
        object2 = JavaScript.getInstance();
        for (int i = 0; i < n; ++i) {
            object = objectArray[i];
            Object object3 = ((JavaScript)object2).getJavaObject(object, classArray[i]);
            if (bl) {
                logger.info("call(): For method=" + method.getName() + ": Converted arg=" + object + " (type=" + this.getTypeName(object) + ") into actualArg=" + object3 + ". Type expected by method is " + classArray[i].getName() + ".");
            }
            objectArray2[i] = object3;
        }
        try {
            Object object4 = method.invoke(javaObjectWrapper.getJavaObject(), objectArray2);
            return ((JavaScript)object2).getJavascriptObject(object4, scriptable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call " + this.className + ".", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WrappedException((Throwable)new InvocationTargetException(invocationTargetException.getCause(), "Unable to call " + this.className + " on " + javaObjectWrapper.getJavaObject() + "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new StringBuffer();
            for (int i = 0; i < objectArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(objectArray2[i] == null ? "<null>" : objectArray2[i].getClass().getName());
            }
            throw new WrappedException((Throwable)new IllegalArgumentException("Unable to call " + this.className + ". Argument types: " + object + ".", illegalArgumentException));
        }
    }

    public Object getDefaultValue(Class clazz) {
        if (loggableInfo) {
            logger.info("getDefaultValue(): hint=" + clazz + ",this=" + (Object)((Object)this));
        }
        if (clazz == null || String.class.equals((Object)clazz)) {
            return "function " + this.className;
        }
        return super.getDefaultValue(clazz);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw new UnsupportedOperationException();
    }
}

