/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.renderer.BaseControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlValues;

class ImgControl
extends BaseControl
implements ImageListener {
    private volatile Image image;
    private String lastSrc;
    private int valign = 5;
    private Dimension preferredSize;
    private int declaredWidth;
    private int declaredHeight;

    public ImgControl(HTMLImageElementImpl hTMLImageElementImpl) {
        super(hTMLImageElementImpl);
        hTMLImageElementImpl.addImageListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Object object = this;
        synchronized (object) {
        }
        object = this.image;
        if (object != null) {
            graphics.drawImage((Image)object, insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom, this);
        }
    }

    public void reset(int n, int n2) {
        HTMLElementImpl hTMLElementImpl = this.controlElement;
        int n3 = HtmlValues.getOldSyntaxPixelSize(hTMLElementImpl.getAttribute("width"), n, -1);
        int n4 = HtmlValues.getOldSyntaxPixelSize(hTMLElementImpl.getAttribute("height"), n2, -1);
        this.declaredWidth = n3;
        this.declaredHeight = n4;
        this.preferredSize = this.createPreferredSize(n3, n4);
        String string = hTMLElementImpl.getAttribute("align");
        int n5 = string == null ? 5 : ("middle".equals(string = string.toLowerCase().trim()) ? 1 : ("absmiddle".equals(string) ? 3 : ("top".equals(string) ? 0 : ("bottom".equals(string) ? 2 : ("baseline".equals(string) ? 5 : ("absbottom".equals(string) ? 4 : 5))))));
        this.valign = n5;
    }

    public int getVAlign() {
        return this.valign;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.preferredSize;
        return dimension == null ? new Dimension(0, 0) : dimension;
    }

    public Dimension createPreferredSize(int n, int n2) {
        int n3;
        int n4;
        Image image = this.image;
        if (n == -1) {
            if (n2 != -1) {
                n4 = image == null ? -1 : image.getWidth(this);
                int n5 = n3 = image == null ? -1 : image.getHeight(this);
                n = n3 == 0 ? (n4 == -1 ? 0 : n4) : (n4 == -1 || n3 == -1 ? 0 : n2 * n4 / n3);
            } else {
                int n6 = n = image == null ? -1 : image.getWidth(this);
                if (n == -1) {
                    n = 0;
                }
            }
        }
        if (n2 == -1) {
            if (n != -1) {
                n4 = image == null ? -1 : image.getWidth(this);
                int n7 = n3 = image == null ? -1 : image.getHeight(this);
                n2 = n4 == 0 ? (n3 == -1 ? 0 : n3) : (n4 == -1 || n3 == -1 ? 0 : n * n3 / n4);
            } else {
                int n8 = n2 = image == null ? -1 : image.getHeight(this);
                if (n2 == -1) {
                    n2 = 0;
                }
            }
        }
        return new Dimension(n, n2);
    }

    private final boolean checkPreferredSizeChange() {
        Dimension dimension = this.createPreferredSize(this.declaredWidth, this.declaredHeight);
        Dimension dimension2 = this.preferredSize;
        if (dimension2 == null) {
            return true;
        }
        if (dimension2.width != dimension.width || dimension2.height != dimension.height) {
            this.preferredSize = dimension;
            return true;
        }
        return false;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0 || (n & 0x10) != 0) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!ImgControl.this.checkPreferredSizeChange()) {
                        ImgControl.this.repaint();
                    } else {
                        ImgControl.this.ruicontrol.preferredSizeInvalidated();
                    }
                }
            });
        }
        return true;
    }

    public void imageUpdate(Image image, int n, int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!ImgControl.this.checkPreferredSizeChange()) {
                    ImgControl.this.repaint();
                } else {
                    ImgControl.this.ruicontrol.preferredSizeInvalidated();
                }
            }
        });
    }

    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        return bl;
    }

    public void imageLoaded(ImageEvent imageEvent) {
        Image image;
        this.image = image = imageEvent.image;
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        if (n != -1 && n2 != -1) {
            this.imageUpdate(image, n, n2);
        }
    }

    public String toString() {
        return "ImgControl[src=" + this.lastSrc + "]";
    }
}

