/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;

public class ErrorsWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        ErrorWidget errorWidget = new ErrorWidget(view);
        return errorWidget;
    }

    private static class ErrorDialog
    extends EnhancedDialog {
        private final JTextArea textArea;
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final PrintStream printStream = new PrintStream(this.byteArrayOutputStream);
        private final JButton removeThisError;
        private final JButton removeAllErrors;
        private final Object[] throwables = Log.throwables.toArray();
        private final JComboBox combo;

        private ErrorDialog(Frame view) {
            super(view, "Errors", false);
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            if (this.throwables.length != 0) {
                Throwable throwable = (Throwable)this.throwables[0];
                this.setThrowable(throwable);
            }
            this.combo = new JComboBox<Object>(this.throwables);
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ErrorDialog.this.setThrowable((Throwable)ErrorDialog.this.combo.getSelectedItem());
                }
            });
            this.getContentPane().add((Component)this.combo, "North");
            this.getContentPane().add(new JScrollPane(this.textArea));
            Box buttons = new Box(0);
            buttons.add(Box.createGlue());
            this.removeThisError = new JButton(jEdit.getProperty("grab-key.remove"));
            buttons.add(this.removeThisError);
            buttons.add(Box.createHorizontalStrut(6));
            this.removeAllErrors = new JButton(jEdit.getProperty("common.clearAll"));
            buttons.add(this.removeAllErrors);
            MyActionListener actionListener = new MyActionListener();
            this.removeThisError.addActionListener(actionListener);
            this.removeAllErrors.addActionListener(actionListener);
            buttons.add(Box.createGlue());
            this.getContentPane().add((Component)buttons, "South");
            this.pack();
            GUIUtilities.loadGeometry(this, "status.errorWidget");
            this.setVisible(true);
        }

        private void setThrowable(Throwable throwable) {
            if (throwable == null) {
                this.textArea.setText(null);
            } else {
                throwable.printStackTrace(this.printStream);
                this.textArea.setText(this.byteArrayOutputStream.toString());
                this.textArea.setCaretPosition(0);
                this.byteArrayOutputStream.reset();
            }
        }

        @Override
        public void dispose() {
            GUIUtilities.saveGeometry(this, "status.errorWidget");
            super.dispose();
        }

        @Override
        public void ok() {
            this.dispose();
        }

        @Override
        public void cancel() {
            this.dispose();
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == ErrorDialog.this.removeThisError) {
                    Throwable throwable = (Throwable)ErrorDialog.this.combo.getSelectedItem();
                    if (throwable != null) {
                        Log.throwables.remove(throwable);
                        ErrorDialog.this.combo.removeItem(throwable);
                        if (ErrorDialog.this.combo.getItemCount() == 0) {
                            ErrorDialog.this.dispose();
                        }
                    }
                } else if (source == ErrorDialog.this.removeAllErrors) {
                    for (Object throwable : ErrorDialog.this.throwables) {
                        Log.throwables.remove(throwable);
                    }
                    ErrorDialog.this.dispose();
                }
            }
        }
    }

    private static class ErrorHighlight
    extends JLabel
    implements ActionListener {
        private int currentSize;
        private final Color foregroundColor;
        private Timer timer;

        ErrorHighlight(View view) {
            String defaultFont = jEdit.getProperty("view.font");
            int defaultFontSize = jEdit.getIntegerProperty("view.fontsize", 12);
            SyntaxStyle invalid = GUIUtilities.parseStyle(jEdit.getProperty("view.style.invalid"), defaultFont, defaultFontSize);
            this.foregroundColor = invalid.getForegroundColor();
            this.setForeground(this.foregroundColor);
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.addMouseListener(new MyMouseAdapter(view));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.update();
            int millisecondsPerMinute = 1000;
            this.timer = new Timer(millisecondsPerMinute, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        private void update() {
            int size = Log.throwables.size();
            if (size != this.currentSize) {
                this.currentSize = size;
                if (size == 0) {
                    this.setText(null);
                    this.setToolTipText(size + " error");
                } else {
                    this.setForeground(this.foregroundColor);
                    this.setText(Integer.toString(size) + " error(s)");
                    this.setToolTipText(size + " error(s)");
                }
            }
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private final View view;

            MyMouseAdapter(View view) {
                this.view = view;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Log.throwables.isEmpty()) {
                    return;
                }
                if (GUIUtilities.isRightButton(e.getModifiers())) {
                    JPopupMenu menu = GUIUtilities.loadPopupMenu("errorwidget.popupmenu");
                    GUIUtilities.showPopupMenu(menu, ErrorHighlight.this, e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    new ErrorDialog((Frame)this.view);
                }
            }
        }
    }

    private static class ErrorWidget
    implements Widget {
        private final ErrorHighlight errorHighlight;

        ErrorWidget(View view) {
            this.errorHighlight = new ErrorHighlight(view);
        }

        @Override
        public JComponent getComponent() {
            return this.errorHighlight;
        }

        @Override
        public void update() {
            this.errorHighlight.update();
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

