/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DockableWindowFactory {
    private static DockableWindowFactory instance;
    private final Map<String, Window> dockableWindowFactories = new HashMap<String, Window>();

    public static synchronized DockableWindowFactory getInstance() {
        if (instance == null) {
            instance = new DockableWindowFactory();
        }
        return instance;
    }

    public void loadDockableWindows(PluginJAR plugin, URL uri, PluginJAR.PluginCacheEntry cache) {
        try {
            Log.log(1, DockableWindowManager.class, "Loading dockables from " + uri);
            DockableListHandler dh = new DockableListHandler(plugin, uri);
            boolean failure = XMLUtilities.parseXML(uri.openStream(), dh);
            if (!failure && cache != null) {
                cache.cachedDockableNames = dh.getCachedDockableNames();
                cache.cachedDockableActionFlags = dh.getCachedDockableActionFlags();
                cache.cachedDockableMovableFlags = dh.getCachedDockableMovableFlags();
            }
        }
        catch (IOException e) {
            Log.log(9, DockableWindowManager.class, e);
        }
    }

    public void unloadDockableWindows(PluginJAR plugin) {
        Iterator<Map.Entry<String, Window>> entries = this.dockableWindowFactories.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Window> entry = entries.next();
            Window factory = entry.getValue();
            if (factory.plugin != plugin) continue;
            entries.remove();
        }
    }

    public void cacheDockableWindows(PluginJAR plugin, String[] name, boolean[] actions, boolean[] movable) {
        for (int i = 0; i < name.length; ++i) {
            Window factory = new Window(plugin, name[i], null, actions[i], movable[i]);
            this.dockableWindowFactories.put(name[i], factory);
        }
    }

    public void registerDockableWindow(PluginJAR plugin, String name, String code, boolean actions, boolean movable) {
        Window factory = this.dockableWindowFactories.get(name);
        if (factory != null) {
            factory.code = code;
            factory.loaded = true;
        } else {
            factory = new Window(plugin, name, code, actions, movable);
            this.dockableWindowFactories.put(name, factory);
        }
    }

    public String[] getRegisteredDockableWindows() {
        String[] retVal = new String[this.dockableWindowFactories.size()];
        Iterator<Window> entries = this.dockableWindowFactories.values().iterator();
        int i = 0;
        while (entries.hasNext()) {
            Window factory = entries.next();
            retVal[i++] = factory.name;
        }
        return retVal;
    }

    public Window getDockableWindowFactory(String name) {
        return this.dockableWindowFactories.get(name);
    }

    public String getDockableWindowPluginClass(String name) {
        Window w = this.getDockableWindowFactory(name);
        if (w == null || w.plugin == null || w.plugin.getPlugin() == null) {
            return null;
        }
        return w.plugin.getPlugin().getClassName();
    }

    Iterator<Window> getDockableWindowIterator() {
        return this.dockableWindowFactories.values().iterator();
    }

    class Window {
        PluginJAR plugin;
        String name;
        String code;
        boolean loaded;
        boolean movable;
        boolean isBeingCreated = false;

        Window(PluginJAR plugin, String name, String code, boolean actions, boolean movable) {
            this.plugin = plugin;
            this.name = name;
            this.code = code;
            this.movable = movable;
            if (code != null) {
                this.loaded = true;
            }
            if (actions) {
                ActionSet actionSet = plugin == null ? jEdit.getBuiltInActionSet() : plugin.getActionSet();
                actionSet.addAction(new OpenAction(name));
                actionSet.addAction(new ToggleAction(name));
                actionSet.addAction(new FloatAction(name));
                String label = jEdit.getProperty(name + ".label");
                if (label == null) {
                    label = "NO LABEL PROPERTY: " + name;
                }
                Object[] args = new String[]{label};
                jEdit.setTemporaryProperty(name + ".label", label);
                jEdit.setTemporaryProperty(name + "-toggle.label", jEdit.getProperty("view.docking.toggle.label", args));
                jEdit.setTemporaryProperty(name + "-toggle.toggle", "true");
                jEdit.setTemporaryProperty(name + "-float.label", jEdit.getProperty("view.docking.float.label", args));
            }
        }

        void load() {
            if (this.loaded) {
                return;
            }
            DockableWindowFactory.this.loadDockableWindows(this.plugin, this.plugin.getDockablesURI(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JComponent createDockableWindow(View view, String position) {
            Window window = this;
            synchronized (window) {
                if (this.isBeingCreated) {
                    return null;
                }
                this.isBeingCreated = true;
            }
            this.load();
            if (!this.loaded) {
                Log.log(7, this, "Outdated cache");
                return null;
            }
            NameSpace nameSpace = new NameSpace(BeanShell.getNameSpace(), "DockableWindowManager.Factory.createDockableWindow()");
            try {
                nameSpace.setVariable("position", position);
            }
            catch (UtilEvalError e) {
                Log.log(9, this, e);
            }
            JComponent win = (JComponent)BeanShell.eval(view, nameSpace, this.code);
            Window window2 = this;
            synchronized (window2) {
                this.isBeingCreated = false;
            }
            return win;
        }

        class FloatAction
        extends EditAction {
            private String dockable;

            FloatAction(String name) {
                super(name + "-float");
                this.dockable = name;
            }

            @Override
            public void invoke(View view) {
                view.getDockableWindowManager().floatDockableWindow(this.dockable);
            }

            @Override
            public String getCode() {
                return "view.getDockableWindowManager().floatDockableWindow(\"" + this.dockable + "\");";
            }
        }

        class ToggleAction
        extends EditAction {
            private String dockable;

            ToggleAction(String name) {
                super(name + "-toggle");
                this.dockable = name;
            }

            @Override
            public void invoke(View view) {
                view.getDockableWindowManager().toggleDockableWindow(this.dockable);
            }

            public boolean isSelected(View view) {
                return view.getDockableWindowManager().isDockableWindowVisible(this.dockable);
            }

            @Override
            public String getCode() {
                return "view.getDockableWindowManager().toggleDockableWindow(\"" + this.dockable + "\");";
            }
        }

        class OpenAction
        extends EditAction {
            private String dockable;

            OpenAction(String name) {
                super(name);
                this.dockable = name;
            }

            @Override
            public void invoke(View view) {
                view.getDockableWindowManager().showDockableWindow(this.dockable);
            }

            @Override
            public String getCode() {
                return "view.getDockableWindowManager().showDockableWindow(\"" + this.dockable + "\");";
            }
        }
    }

    class DockableListHandler
    extends DefaultHandler {
        private PluginJAR plugin;
        private URL uri;
        private List<String> cachedDockableNames;
        private List<Boolean> cachedDockableActionFlags;
        private List<Boolean> cachedDockableMovableFlags;
        private String dockableName;
        private StringBuilder code;
        private boolean actions;
        private boolean movable;
        static final boolean MOVABLE_DEFAULT = false;
        private Stack<String> stateStack;

        DockableListHandler(PluginJAR plugin, URL uri) {
            this.plugin = plugin;
            this.uri = uri;
            this.stateStack = new Stack();
            this.actions = true;
            this.movable = false;
            this.code = new StringBuilder();
            this.cachedDockableNames = new LinkedList<String>();
            this.cachedDockableActionFlags = new LinkedList<Boolean>();
            this.cachedDockableMovableFlags = new LinkedList<Boolean>();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "dockables.dtd", MiscUtilities.class);
        }

        @Override
        public void characters(char[] c, int off, int len) {
            String tag = this.peekElement();
            if (tag.equals("DOCKABLE")) {
                this.code.append(c, off, len);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            String tag = this.pushElement(qName);
            if (tag.equals("DOCKABLE")) {
                this.dockableName = attrs.getValue("NAME");
                this.actions = "FALSE".equals(attrs.getValue("NO_ACTIONS"));
                String movableAttr = attrs.getValue("MOVABLE");
                if (movableAttr != null) {
                    this.movable = movableAttr.equalsIgnoreCase("TRUE");
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            if (name == null) {
                return;
            }
            String tag = this.peekElement();
            if (name.equals(tag)) {
                if (tag.equals("DOCKABLE")) {
                    DockableWindowFactory.this.registerDockableWindow(this.plugin, this.dockableName, this.code.toString(), this.actions, this.movable);
                    this.cachedDockableNames.add(this.dockableName);
                    this.cachedDockableActionFlags.add(this.actions);
                    this.cachedDockableMovableFlags.add(this.movable);
                    this.actions = true;
                    this.movable = false;
                    this.code.setLength(0);
                }
            } else {
                throw new InternalError();
            }
            this.popElement();
        }

        @Override
        public void startDocument() {
            try {
                this.pushElement(null);
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
        }

        public String[] getCachedDockableNames() {
            return this.cachedDockableNames.toArray(new String[this.cachedDockableNames.size()]);
        }

        public boolean[] getCachedDockableActionFlags() {
            return this.booleanListToArray(this.cachedDockableActionFlags);
        }

        public boolean[] getCachedDockableMovableFlags() {
            return this.booleanListToArray(this.cachedDockableMovableFlags);
        }

        private boolean[] booleanListToArray(List<Boolean> list) {
            boolean[] returnValue = new boolean[list.size()];
            int i = 0;
            for (Boolean value : list) {
                returnValue[i++] = value;
            }
            return returnValue;
        }

        private String pushElement(String name) {
            name = name == null ? null : name.intern();
            this.stateStack.push(name);
            return name;
        }

        private String peekElement() {
            return this.stateStack.peek();
        }

        private String popElement() {
            return this.stateStack.pop();
        }
    }
}

