/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;

public class CompletionPopup
extends JWindow {
    private final View view;
    private final KeyHandler keyHandler;
    private Candidates candidates;
    private final JList list;

    public CompletionPopup(View view) {
        super(view);
        this.view = view;
        this.keyHandler = new KeyHandler();
        this.candidates = null;
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new CellRenderer());
        this.list.addKeyListener(this.keyHandler);
        this.list.addMouseListener(new MouseHandler());
        JPanel content = new JPanel(new BorderLayout());
        content.setFocusTraversalKeysEnabled(false);
        JScrollPane scroller = new JScrollPane(this.list, 22, 31);
        content.add((Component)scroller, "Center");
        this.setContentPane(content);
        this.addWindowFocusListener(new WindowFocusHandler());
    }

    public CompletionPopup(View view, Point location) {
        this(view);
        if (location != null) {
            this.setLocation(location);
        }
    }

    @Override
    public void dispose() {
        if (this.isDisplayable()) {
            if (this.view.getKeyEventInterceptor() == this.keyHandler) {
                this.view.setKeyEventInterceptor(null);
            }
            super.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompletionPopup.this.view.getTextArea().requestFocus();
                }
            });
        }
    }

    public void reset(Candidates candidates, boolean active) {
        if (candidates == null || !candidates.isValid() || candidates.getSize() <= 0) {
            this.dispose();
            return;
        }
        this.candidates = candidates;
        this.list.setModel(new CandidateListModel());
        this.list.setVisibleRowCount(Math.min(candidates.getSize(), 8));
        this.pack();
        this.setLocation(CompletionPopup.fitInScreen(this.getLocation(null), this, this.view.getTextArea().getPainter().getLineHeight()));
        if (active) {
            this.setSelectedIndex(0);
            GUIUtilities.requestFocus(this, this.list);
        }
        this.setVisible(true);
        this.view.setKeyEventInterceptor(this.keyHandler);
    }

    public Candidates getCandidates() {
        return this.candidates;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (this.candidates != null && 0 <= index && index < this.candidates.getSize()) {
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
            String description = this.candidates.getDescription(index);
            if (description != null) {
                this.view.getStatus().setMessageAndClear(description);
            }
        }
    }

    public boolean doSelectedCompletion() {
        int selected = this.list.getSelectedIndex();
        if (this.candidates != null && 0 <= selected && selected < this.candidates.getSize()) {
            this.candidates.complete(selected);
            this.dispose();
            return true;
        }
        return false;
    }

    protected void keyPressed(KeyEvent e) {
    }

    protected void keyTyped(KeyEvent e) {
    }

    private static Point fitInScreen(Point p, Window w, int lineHeight) {
        Rectangle screenSize = w.getGraphicsConfiguration().getBounds();
        if (p.y + w.getHeight() >= screenSize.height) {
            p.y = p.y - w.getHeight() - lineHeight;
        }
        return p;
    }

    private void moveRelative(int n) {
        int selected = this.list.getSelectedIndex();
        int newSelect = selected + n;
        if (newSelect < 0) {
            newSelect = 0;
        } else {
            int numItems = this.list.getModel().getSize();
            if (numItems < 1) {
                return;
            }
            if (newSelect >= numItems) {
                newSelect = numItems - 1;
            }
        }
        if (newSelect != selected) {
            this.setSelectedIndex(newSelect);
        }
    }

    private void moveRelativePages(int n) {
        int pageSize = this.list.getVisibleRowCount() - 1;
        this.moveRelative(pageSize * n);
    }

    private void passKeyEventToView(KeyEvent e) {
        assert (this.view.getKeyEventInterceptor() == this.keyHandler);
        this.view.setKeyEventInterceptor(null);
        this.view.getInputHandler().processKeyEvent(e, 2, false);
        if (this.isDisplayable()) {
            this.view.setKeyEventInterceptor(this.keyHandler);
        }
    }

    private class WindowFocusHandler
    implements WindowFocusListener {
        private WindowFocusHandler() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            CompletionPopup.this.dispose();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CompletionPopup.this.doSelectedCompletion()) {
                e.consume();
            } else {
                CompletionPopup.this.dispose();
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            CompletionPopup.this.keyPressed(e);
            if (CompletionPopup.this.candidates == null || !CompletionPopup.this.candidates.isValid()) {
                CompletionPopup.this.dispose();
            } else if (!e.isConsumed()) {
                switch (e.getKeyCode()) {
                    case 9: 
                    case 10: {
                        if (CompletionPopup.this.doSelectedCompletion()) {
                            e.consume();
                            break;
                        }
                        CompletionPopup.this.dispose();
                        break;
                    }
                    case 27: {
                        CompletionPopup.this.dispose();
                        e.consume();
                        break;
                    }
                    case 38: {
                        CompletionPopup.this.moveRelative(-1);
                        e.consume();
                        break;
                    }
                    case 40: {
                        CompletionPopup.this.moveRelative(1);
                        e.consume();
                        break;
                    }
                    case 80: {
                        if (e.getModifiersEx() != 128) break;
                        CompletionPopup.this.moveRelative(-1);
                        e.consume();
                        break;
                    }
                    case 78: {
                        if (e.getModifiersEx() != 128) break;
                        CompletionPopup.this.moveRelative(1);
                        e.consume();
                        break;
                    }
                    case 33: {
                        CompletionPopup.this.moveRelativePages(-1);
                        e.consume();
                        break;
                    }
                    case 34: {
                        CompletionPopup.this.moveRelativePages(1);
                        e.consume();
                        break;
                    }
                    default: {
                        if (e.isActionKey() || e.isAltDown() || e.isMetaDown()) {
                            CompletionPopup.this.dispose();
                            break;
                        }
                        if (!e.isControlDown()) break;
                        e.consume();
                    }
                }
            }
            if (!e.isConsumed()) {
                CompletionPopup.this.passKeyEventToView(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.isControlDown()) {
                e.consume();
            } else {
                CompletionPopup.this.keyTyped(e);
            }
            if (CompletionPopup.this.candidates == null || !CompletionPopup.this.candidates.isValid()) {
                CompletionPopup.this.dispose();
            }
            if (!e.isConsumed()) {
                CompletionPopup.this.passKeyEventToView(e);
            }
        }
    }

    private class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return CompletionPopup.this.candidates.getCellRenderer(list, index, isSelected, cellHasFocus);
        }
    }

    private class CandidateListModel
    extends AbstractListModel {
        private CandidateListModel() {
        }

        @Override
        public int getSize() {
            return CompletionPopup.this.candidates.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return CompletionPopup.this.candidates;
        }
    }

    public static interface Candidates {
        public int getSize();

        public boolean isValid();

        public void complete(int var1);

        public Component getCellRenderer(JList var1, int var2, boolean var3, boolean var4);

        public String getDescription(int var1);
    }
}

