/*
 * Decompiled with CFR 0.152.
 */
package sidekick.enhanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import marker.MarkerSetsPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import sidekick.IAsset;
import sidekick.SideKickPlugin;
import sidekick.SideKickTree;

public class SourceTree
extends SideKickTree {
    private static boolean _hasMarker;
    private static boolean _showMarkers;
    private static Color _markerColor;
    private HashMap _actionShortcuts = new HashMap();
    public JPopupMenu popup;

    public SourceTree(View view, boolean bl) {
        super(view, bl);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new Renderer()));
        this.tree.addKeyListener(new KeyHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.tree.addMouseListener(mouseHandler);
        if (bl) {
            this.tree.addMouseMotionListener(mouseHandler);
        }
        this.update();
    }

    protected void createPopup() {
        Mode mode = this.view.getBuffer().getMode();
        String string = mode == null ? "" : "." + mode.getName();
        String string2 = "sidekick-tree" + string + ".menu";
        if (jEdit.getProperty((String)string2) == null) {
            string2 = "sidekick-tree.menu";
        }
        this.popup = GUIUtilities.loadPopupMenu((String)string2);
    }

    protected void update() {
        super.update();
        this.createPopup();
    }

    private boolean hasMarker(int n, int n2) {
        EditPlugin editPlugin = SideKickPlugin.getMarkerSetsPlugin();
        if (editPlugin != null && ((MarkerSetsPlugin)editPlugin).hasMarker(this.view.getBuffer(), n, n2)) {
            return true;
        }
        return this.view.getBuffer().getMarkerInRange(n, n2) != null;
    }

    public static void toggleMarkersFlag() {
        _showMarkers = !_showMarkers;
    }

    public static boolean isRegisteredDockable(String string) {
        String[] stringArray = DockableWindowFactory.getInstance().getRegisteredDockableWindows();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isMarkersFlagSet() {
        return _showMarkers;
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (bufferUpdate.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            this.update();
        }
    }

    public void handleKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        KeyEventTranslator.Key key = KeyEventTranslator.translateKeyEvent((KeyEvent)keyEvent);
        if (this._actionShortcuts.containsKey(key)) {
            this.view.getInputHandler().handleKey(key);
        } else if (!(n != 27 && n != 3 || keyEvent.isConsumed())) {
            this.view.getTextArea().requestFocus();
        }
    }

    public void handleMouse(MouseEvent mouseEvent) {
        if (GUIUtilities.isPopupTrigger((MouseEvent)mouseEvent)) {
            GUIUtilities.showPopupMenu((JPopupMenu)this.popup, (Component)this, (int)mouseEvent.getX(), (int)mouseEvent.getY());
            this.view.getTextArea().requestFocus();
        }
    }

    protected void propertiesChanged() {
        super.propertiesChanged();
        Color color = jEdit.getColorProperty((String)"view.gutter.markerColor");
        if (!_markerColor.equals(color)) {
            _markerColor = color;
            this.repaint();
        }
        if (jEdit.getBooleanProperty((String)"sidekick.showToolTips")) {
            ToolTipManager.sharedInstance().registerComponent(this.tree);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        }
    }

    static {
        _showMarkers = true;
        _markerColor = jEdit.getColorProperty((String)"view.gutter.markerColor");
    }

    protected class Renderer
    extends EnhancedTreeCellRenderer {
        protected Renderer() {
        }

        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            _hasMarker = false;
            if (defaultMutableTreeNode.getParent() == null) {
                this.setIcon(FileCellRenderer.fileIcon);
            }
            if (object2 instanceof IAsset) {
                IAsset iAsset = (IAsset)defaultMutableTreeNode.getUserObject();
                this.setIcon(iAsset.getIcon());
                this.setText(iAsset.getShortString());
                _hasMarker = SourceTree.this.hasMarker(iAsset.getStart().getOffset(), iAsset.getEnd().getOffset());
                this.setToolTipText(this.getToolTipText(defaultMutableTreeNode, iAsset));
            } else {
                this.setIcon(null);
            }
        }

        private void wrap(StringBuffer stringBuffer, String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n", false);
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (stringBuilder.length() + string3.length() >= 80) {
                    stringBuffer.append(stringBuilder + "<br>" + string);
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3 + " ");
            }
            stringBuffer.append((CharSequence)stringBuilder);
        }

        private String getToolTipText(DefaultMutableTreeNode defaultMutableTreeNode, IAsset iAsset) {
            StringBuffer stringBuffer = new StringBuffer("<html><body>");
            stringBuffer.append(iAsset.getLongString());
            stringBuffer.append("<br><br>");
            StringBuffer stringBuffer2 = new StringBuffer();
            for (TreeNode treeNode : defaultMutableTreeNode.getPath()) {
                boolean bl;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode;
                Object object = defaultMutableTreeNode2.getUserObject();
                boolean bl2 = bl = treeNode == defaultMutableTreeNode;
                if (bl) {
                    stringBuffer.append("<b>");
                }
                String string = object instanceof IAsset ? ((IAsset)object).getShortString() : object.toString();
                this.wrap(stringBuffer, stringBuffer2.toString(), string);
                if (bl) {
                    stringBuffer.append("</b>");
                }
                if (bl) continue;
                stringBuffer.append("<br>");
                stringBuffer2.append("&nbsp;&nbsp;");
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append("</body></html>");
            return stringBuffer.toString();
        }

        public void paintComponent(Graphics graphics) {
            if (SourceTree.isMarkersFlagSet() && _hasMarker) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = this.getHeight() - 3;
                int n2 = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
                graphics.setColor(_markerColor);
                graphics.fillRect(n2, n, fontMetrics.stringWidth(this.getText()), 3);
            }
            super.paintComponent(graphics);
        }

        protected TreeCellRenderer newInstance() {
            return new Renderer();
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SourceTree.this.handleMouse(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TreePath treePath = SourceTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                SourceTree.this.view.getStatus().setMessage(null);
            } else {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (object instanceof IAsset) {
                    IAsset iAsset = (IAsset)object;
                    SourceTree.this.view.getStatus().setMessage(iAsset.getShortString());
                    SourceTree.this.setStatus(iAsset.getLongString() == null ? iAsset.getShortString() : iAsset.getLongString());
                }
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            SourceTree.this.handleKey(keyEvent);
        }
    }
}

