/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.Asset;
import sidekick.SideKick;
import sidekick.SideKickParsedData;
import sidekick.SideKickUpdate;

public class SideKickToolBar
extends JToolBar
implements ActionListener {
    private View view;
    private JButton select;
    private JComboBox combo;
    private boolean followCaret;
    private CaretListener caretListener;
    private Timer caretTimer;
    private SideKickParsedData data;
    private boolean automaticUpdate = false;
    private int delayMs;
    private boolean splitCombo;
    private JPanel splitComboPanel;
    private ArrayList<JComboBox> combos;
    private ComboCellRenderer renderer;
    private boolean singleIconInCombo;

    public SideKickToolBar(View view) {
        this.view = view;
        this.setFloatable(jEdit.getBooleanProperty((String)"view.toolbar.floatable"));
        this.select = new JButton(jEdit.getProperty((String)"sidekick-toolbar.select"));
        this.select.addActionListener(this);
        this.add(this.select);
        this.renderer = new ComboCellRenderer();
        this.splitCombo = jEdit.getBooleanProperty((String)"sidekick.splitCombo");
        if (this.splitCombo) {
            this.createSplitComboPanel();
        } else {
            this.createSingleCombo();
        }
        this.singleIconInCombo = jEdit.getBooleanProperty((String)"sidekick.singleIconInCombo");
        this.followCaret = SideKick.isFollowCaret();
        this.update();
        this.delayMs = jEdit.getIntegerProperty((String)"sidekick.toolBarUpdateDelay", (int)200);
        if (this.followCaret) {
            this.addCaretListener();
        }
        EditBus.addToBus((Object)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.select) {
            Object object = this.combo.getSelectedItem();
            if (!(object instanceof NodeWrapper)) {
                return;
            }
            NodeWrapper nodeWrapper = (NodeWrapper)object;
            nodeWrapper.select();
        }
    }

    @EditBus.EBHandler
    public void handleSideKickUpdate(SideKickUpdate sideKickUpdate) {
        if (sideKickUpdate.getView() == this.view) {
            this.update();
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        boolean bl;
        boolean bl2 = jEdit.getBooleanProperty((String)"sidekick.splitCombo");
        if (bl2 != this.splitCombo) {
            this.splitCombo = bl2;
            if (this.splitCombo) {
                this.removeSingleCombo();
                this.createSplitComboPanel();
            } else {
                this.removeSplitComboPanel();
                this.createSingleCombo();
            }
            this.update();
        } else if (!this.splitCombo && (bl = jEdit.getBooleanProperty((String)"sidekick.singleIconInCombo")) != this.singleIconInCombo) {
            this.singleIconInCombo = bl;
            this.update();
        }
        this.delayMs = jEdit.getIntegerProperty((String)"sidekick.toolBarUpdateDelay", (int)200);
        bl = SideKick.isFollowCaret();
        if (bl != this.followCaret) {
            this.followCaret = bl;
            if (this.followCaret) {
                this.addCaretListener();
            } else {
                this.removeCaretListener();
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        if (!this.followCaret) {
            return;
        }
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPaneUpdate.getWhat() == EditPaneUpdate.CREATED) {
            editPane.getTextArea().addCaretListener(this.caretListener);
        } else if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
            editPane.getTextArea().removeCaretListener(this.caretListener);
        }
    }

    private void addCaretListener() {
        this.caretListener = new CaretHandler();
        for (EditPane editPane : this.view.getEditPanes()) {
            editPane.getTextArea().addCaretListener(this.caretListener);
        }
    }

    private void removeCaretListener() {
        for (EditPane editPane : this.view.getEditPanes()) {
            editPane.getTextArea().removeCaretListener(this.caretListener);
        }
        this.caretListener = null;
    }

    private void update() {
        this.automaticUpdate = true;
        this.data = SideKickParsedData.getParsedData(this.view);
        if (this.splitCombo) {
            this.updateSplitCombo();
        } else {
            this.updateSingleCombo();
        }
        if (this.followCaret) {
            this.updateSelectionByCaretPosition();
        }
        this.automaticUpdate = false;
    }

    private void updateSelectionByCaretPosition() {
        int n;
        JEditTextArea jEditTextArea = this.view.getTextArea();
        Selection selection = jEditTextArea.getSelectionAtOffset(n = jEditTextArea.getCaretPosition());
        this.selectItemAtPosition(selection == null ? n : selection.getStart());
    }

    public void dispose() {
        EditBus.removeFromBus((Object)this);
    }

    private void selectItemAtPosition(int n) {
        if (this.splitCombo) {
            this.selectItemAtPositionSplitCombo(n);
        } else {
            this.selectItemAtPositionSingleCombo(n);
        }
    }

    private void createSingleCombo() {
        this.combo = new JComboBox();
        this.combo.setRenderer(this.renderer);
        this.combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (SideKickToolBar.this.automaticUpdate) {
                    return;
                }
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (!(object instanceof NodeWrapper)) {
                    return;
                }
                ((NodeWrapper)object).jump();
            }
        });
        this.add(this.combo);
    }

    private void removeSingleCombo() {
        if (this.combo == null) {
            return;
        }
        this.remove(this.combo);
        this.combo = null;
    }

    private void updateSingleCombo() {
        this.combo.removeAllItems();
        if (this.data == null) {
            this.combo.addItem(jEdit.getProperty((String)"sidekick-tree.not-parsed"));
        } else {
            this.addTree(this.data.root, null);
        }
    }

    private void addTree(TreeNode treeNode, NodeWrapper nodeWrapper) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            NodeWrapper nodeWrapper2 = new NodeWrapper(nodeWrapper, treeNode2);
            if (nodeWrapper2.isAsset()) {
                this.combo.addItem(nodeWrapper2);
            }
            this.addTree(treeNode2, nodeWrapper2);
        }
    }

    private void selectItemAtPositionSingleCombo(int n) {
        NodeWrapper nodeWrapper = null;
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            NodeWrapper nodeWrapper2;
            Object e = this.combo.getItemAt(i);
            if (e == null || !(e instanceof NodeWrapper) || !(nodeWrapper2 = (NodeWrapper)e).contains(n) || !nodeWrapper2.isBetterThan(nodeWrapper)) continue;
            nodeWrapper = nodeWrapper2;
        }
        if (nodeWrapper != null) {
            this.automaticUpdate = true;
            this.combo.setSelectedItem(nodeWrapper);
            this.automaticUpdate = false;
        }
    }

    private void createSplitComboPanel() {
        this.combos = new ArrayList();
        this.splitComboPanel = new JPanel(new FlowLayout(0));
        this.add(this.splitComboPanel);
        this.getSplitCombo(0);
    }

    private void removeSplitComboPanel() {
        if (this.combos == null) {
            return;
        }
        for (JComboBox jComboBox : this.combos) {
            this.splitComboPanel.remove(jComboBox);
        }
        this.combos = null;
        this.remove(this.splitComboPanel);
        this.splitComboPanel = null;
    }

    private void updateSplitCombo() {
        JComboBox jComboBox = this.combos.get(0);
        jComboBox.removeAllItems();
        if (this.data == null) {
            jComboBox.addItem(jEdit.getProperty((String)"sidekick-tree.not-parsed"));
        } else {
            this.addFirstTreeLevel(this.data.root);
        }
    }

    private void addFirstTreeLevel(TreeNode treeNode) {
        JComboBox jComboBox = this.combos.get(0);
        this.addChildrenToSplitCombo(treeNode, jComboBox, 0);
    }

    private void addChildrenToSplitCombo(TreeNode treeNode, JComboBox jComboBox, int n) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            NodeWrapper nodeWrapper = new NodeWrapper(treeNode2);
            jComboBox.addItem(nodeWrapper);
        }
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.updateNextTreeLevel((NodeWrapper)object, n + 1);
        }
    }

    private JComboBox getSplitCombo(final int n) {
        if (n < this.combos.size()) {
            return this.combos.get(n);
        }
        JComboBox jComboBox = new JComboBox();
        jComboBox.setRenderer(this.renderer);
        this.combos.add(jComboBox);
        this.splitComboPanel.add(jComboBox);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (SideKickToolBar.this.automaticUpdate) {
                    return;
                }
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (!(object instanceof NodeWrapper)) {
                    return;
                }
                NodeWrapper nodeWrapper = (NodeWrapper)object;
                SideKickToolBar.this.updateNextTreeLevel(nodeWrapper, n + 1);
            }
        });
        return jComboBox;
    }

    private void updateNextTreeLevel(NodeWrapper nodeWrapper, int n) {
        if (nodeWrapper.node == null) {
            return;
        }
        int n2 = nodeWrapper.node.getChildCount();
        if (n2 == 0) {
            while (this.combos.size() > n) {
                JComboBox jComboBox = this.combos.remove(n);
                this.splitComboPanel.remove(jComboBox);
            }
            if (!this.automaticUpdate) {
                nodeWrapper.jump();
            }
        } else {
            JComboBox jComboBox = this.getSplitCombo(n);
            jComboBox.removeAllItems();
            this.addChildrenToSplitCombo(nodeWrapper.node, jComboBox, n);
        }
    }

    private void selectItemAtPositionSplitCombo(int n) {
        TreePath treePath = this.data.getTreePathForPosition(n);
        if (treePath == null) {
            return;
        }
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            Object object = treePath.getPathComponent(i);
            JComboBox jComboBox = this.getSplitCombo(i - 1);
            boolean bl = false;
            for (int j = 0; j < jComboBox.getItemCount(); ++j) {
                NodeWrapper nodeWrapper = (NodeWrapper)jComboBox.getItemAt(j);
                if (nodeWrapper.node != object) continue;
                this.automaticUpdate = true;
                jComboBox.setSelectedIndex(j);
                this.updateNextTreeLevel(nodeWrapper, i);
                this.automaticUpdate = false;
                bl = true;
                break;
            }
            if (!bl) break;
        }
    }

    private class ComboCellRenderer
    extends JPanel
    implements ListCellRenderer {
        public ComboCellRenderer() {
            this.setLayout(new FlowLayout(0, 3, 1));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color;
            ((FlowLayout)this.getLayout()).setHgap(SideKickToolBar.this.singleIconInCombo ? 7 : 3);
            this.removeAll();
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                color = jList.getSelectionForeground();
            } else {
                this.setBackground(jList.getBackground());
                color = jList.getForeground();
            }
            if (object instanceof NodeWrapper) {
                NodeWrapper nodeWrapper = (NodeWrapper)object;
                nodeWrapper.addLabel(this, color);
            }
            return this;
        }
    }

    private class NodeWrapper {
        public NodeWrapper parent;
        public String str;
        public Icon icon;
        public Asset asset;
        public TreeNode node;

        public NodeWrapper(TreeNode treeNode) {
            this(null, treeNode);
        }

        public NodeWrapper(NodeWrapper nodeWrapper, TreeNode treeNode) {
            this.parent = nodeWrapper;
            this.node = treeNode;
            if (treeNode instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                Object object = defaultMutableTreeNode.getUserObject();
                if (object == null) {
                    this.str = "";
                } else if (object instanceof Asset) {
                    this.asset = (Asset)object;
                    this.icon = this.asset.getIcon();
                    this.str = this.asset.getShortString();
                } else {
                    this.str = object.toString();
                }
            }
        }

        public void jump() {
            if (this.asset == null) {
                return;
            }
            SideKickToolBar.this.view.getTextArea().setCaretPosition(this.asset.start.getOffset());
        }

        public void select() {
            if (this.asset == null) {
                return;
            }
            SideKickToolBar.this.view.getTextArea().setSelection((Selection)new Selection.Range(this.asset.start.getOffset(), this.asset.end.getOffset()));
        }

        public boolean contains(int n) {
            return this.asset != null && this.asset.getStart().getOffset() <= n && this.asset.getEnd().getOffset() > n;
        }

        public boolean isBetterThan(NodeWrapper nodeWrapper) {
            return nodeWrapper == null || this.asset.getStart().getOffset() > nodeWrapper.asset.getStart().getOffset() || this.asset.getEnd().getOffset() < nodeWrapper.asset.getEnd().getOffset();
        }

        public boolean isAsset() {
            return this.asset != null;
        }

        public void addParentLabel(JPanel jPanel, Icon icon, Color color) {
            if (this.parent != null) {
                this.parent.addParentLabel(jPanel, icon, color);
            }
            JLabel jLabel = new JLabel();
            jLabel.setForeground(color);
            jLabel.setText(this.str);
            if (SideKickToolBar.this.singleIconInCombo) {
                if (this.parent == null) {
                    jLabel.setIcon(icon);
                }
            } else {
                jLabel.setIcon(this.icon);
            }
            jPanel.add(jLabel);
        }

        public void addLabel(JPanel jPanel, Color color) {
            if (this.parent != null) {
                this.parent.addParentLabel(jPanel, this.icon, color);
            }
            JLabel jLabel = new JLabel();
            jLabel.setForeground(color);
            jLabel.setText(this.str);
            if (!SideKickToolBar.this.singleIconInCombo || this.parent == null) {
                jLabel.setIcon(this.icon);
            }
            jPanel.add(jLabel);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getSource() != SideKickToolBar.this.view.getTextArea()) {
                return;
            }
            if (SideKickToolBar.this.caretTimer != null) {
                SideKickToolBar.this.caretTimer.stop();
            } else {
                SideKickToolBar.this.caretTimer = new Timer(0, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SideKickToolBar.this.updateSelectionByCaretPosition();
                    }
                });
                SideKickToolBar.this.caretTimer.setRepeats(false);
            }
            SideKickToolBar.this.caretTimer.setInitialDelay(SideKickToolBar.this.delayMs);
            SideKickToolBar.this.caretTimer.start();
        }
    }
}

