/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.IAsset;
import sidekick.SideKickCompletion;
import sidekick.SideKickCompletionPopup;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;

public class SideKickActions {
    private static boolean completeDelay;
    private static boolean completeInstant;
    private static boolean autoCompletePopupGetFocus;
    private static int delay;
    private static WeakReference<JEditTextArea> delayedCompletionTarget;
    private static int caretWhenCompleteKeyPressed;
    private static Timer timer;
    private static SideKickCompletionPopup popup;
    public static final int COMPLETE_COMMAND = 0;
    public static final int COMPLETE_DELAY_KEY = 1;
    public static final int COMPLETE_INSTANT_KEY = 2;
    public static String acceptChars;
    public static String insertChars;

    public static void keyComplete(View view) {
        if (timer != null) {
            timer.stop();
        }
        if (!completeInstant) {
            return;
        }
        SideKickActions.complete(view, 2);
    }

    public static void keyCompleteWithDelay(View view) {
        if (!completeDelay) {
            return;
        }
        if (timer != null) {
            timer.stop();
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        if (delayedCompletionTarget == null || delayedCompletionTarget.get() != jEditTextArea) {
            delayedCompletionTarget = new WeakReference<JEditTextArea>(jEditTextArea);
        }
        caretWhenCompleteKeyPressed = jEditTextArea.getCaretPosition();
        if (timer == null) {
            timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JEditTextArea jEditTextArea = (JEditTextArea)delayedCompletionTarget.get();
                    if (jEditTextArea != null && caretWhenCompleteKeyPressed == jEditTextArea.getCaretPosition()) {
                        SideKickActions.complete(jEditTextArea.getView(), 1);
                    }
                }
            });
            timer.setInitialDelay(delay);
            timer.setRepeats(false);
        }
        timer.start();
    }

    public static void complete(View view, int n) {
        EditPane editPane = view.getEditPane();
        Buffer buffer = editPane.getBuffer();
        JEditTextArea jEditTextArea = editPane.getTextArea();
        SideKickParser sideKickParser = SideKickPlugin.getParserForBuffer(buffer);
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData(view);
        SideKickCompletion sideKickCompletion = null;
        if (buffer.isEditable() && sideKickParsedData != null && sideKickParser != null && sideKickParser.supportsCompletion()) {
            sideKickCompletion = sideKickParser.complete(editPane, jEditTextArea.getCaretPosition());
        }
        if (sideKickCompletion == null || sideKickCompletion.size() == 0) {
            if (n == 2 || n == 1) {
                return;
            }
            view.getToolkit().beep();
            return;
        }
        if (sideKickCompletion.size() == 1 && (n == 0 || n == 2)) {
            sideKickCompletion.insert(0);
            return;
        }
        if (popup != null) {
            return;
        }
        boolean bl = n == 0 || autoCompletePopupGetFocus;
        popup = sideKickParser.getCompletionPopup(view, jEditTextArea.getCaretPosition(), sideKickCompletion, bl);
        popup.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                popup = null;
            }
        });
    }

    public static void selectAsset(View view) {
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData(view);
        if (sideKickParsedData == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        IAsset iAsset = sideKickParsedData.getAssetAtOffset(jEditTextArea.getCaretPosition());
        if (iAsset == null || iAsset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        int n = iAsset.getEnd().getOffset();
        if (n > jEditTextArea.getBuffer().getLength()) {
            view.getToolkit().beep();
            return;
        }
        jEditTextArea.setCaretPosition(n);
        jEditTextArea.addToSelection((Selection)new Selection.Range(iAsset.getStart().getOffset(), n));
    }

    public static void narrowToAsset(View view) {
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData(view);
        if (sideKickParsedData == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        TreePath treePath = sideKickParsedData.getTreePathForPosition(jEditTextArea.getCaretPosition());
        if (treePath == null) {
            view.getToolkit().beep();
            return;
        }
        IAsset iAsset = (IAsset)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        if (iAsset == null || iAsset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        jEditTextArea.getDisplayManager().narrow(jEditTextArea.getLineOfOffset(iAsset.getStart().getOffset()), jEditTextArea.getLineOfOffset(iAsset.getStart().getOffset()));
    }

    public static void goToPrevAsset(View view) {
        Object object;
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData(view);
        if (sideKickParsedData == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        int n = jEditTextArea.getCaretPosition();
        TreePath treePath = sideKickParsedData.getTreePathForPosition(n);
        if (treePath == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            IAsset iAsset;
            object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
            if (!(object instanceof IAsset) || (iAsset = (IAsset)object).getEnd() == null || n != iAsset.getEnd().getOffset()) continue;
            jEditTextArea.setCaretPosition(iAsset.getStart().getOffset());
            return;
        }
        IAsset iAsset = (IAsset)defaultMutableTreeNode.getUserObject();
        if (n == iAsset.getStart().getOffset()) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (object != null) {
                for (int i = 0; i < ((DefaultMutableTreeNode)object).getChildCount(); ++i) {
                    if (defaultMutableTreeNode != ((DefaultMutableTreeNode)object).getChildAt(i)) continue;
                    if (i == 0) {
                        if (((DefaultMutableTreeNode)object).getUserObject() instanceof IAsset) {
                            jEditTextArea.setCaretPosition(((IAsset)((DefaultMutableTreeNode)object).getUserObject()).getStart().getOffset());
                        }
                    } else {
                        IAsset iAsset2;
                        Object object2 = ((DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(i - 1)).getUserObject();
                        if (object2 instanceof IAsset && (iAsset2 = (IAsset)object2).getEnd() != null) {
                            jEditTextArea.setCaretPosition(iAsset2.getEnd().getOffset());
                        }
                    }
                    return;
                }
            }
        } else {
            jEditTextArea.setCaretPosition(iAsset.getStart().getOffset());
        }
    }

    public static void goToNextAsset(View view) {
        int n;
        SideKickParsedData sideKickParsedData = SideKickParsedData.getParsedData(view);
        if (sideKickParsedData == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        int n2 = jEditTextArea.getCaretPosition();
        TreePath treePath = sideKickParsedData.getTreePathForPosition(n2);
        if (treePath == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            IAsset iAsset;
            Object object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n)).getUserObject();
            if (!(object instanceof IAsset) || n2 != (iAsset = (IAsset)object).getEnd().getOffset()) continue;
            if (n == defaultMutableTreeNode.getChildCount() - 1) break;
            IAsset iAsset2 = (IAsset)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n + 1)).getUserObject();
            int n3 = iAsset2.getStart().getOffset() >= jEditTextArea.getBufferLength() ? jEditTextArea.getBufferLength() - 1 : iAsset2.getStart().getOffset();
            jEditTextArea.setCaretPosition(n3);
            return;
        }
        n = (n = ((IAsset)defaultMutableTreeNode.getUserObject()).getEnd().getOffset()) >= jEditTextArea.getBufferLength() ? jEditTextArea.getBufferLength() - 1 : n;
        jEditTextArea.setCaretPosition(n);
    }

    public static void propertiesChanged() {
        completeDelay = jEdit.getBooleanProperty((String)"sidekick.complete-delay.toggle");
        completeInstant = jEdit.getBooleanProperty((String)"sidekick.complete-instant.toggle");
        autoCompletePopupGetFocus = jEdit.getBooleanProperty((String)"sidekick.auto-complete-popup-get-focus");
        acceptChars = MiscUtilities.escapesToChars((String)jEdit.getProperty((String)"sidekick.complete-popup.accept-characters"));
        insertChars = MiscUtilities.escapesToChars((String)jEdit.getProperty((String)"sidekick.complete-popup.insert-characters"));
        delay = jEdit.getIntegerProperty((String)"sidekick.complete-delay", (int)500);
        if (timer != null) {
            timer.setInitialDelay(delay);
        }
    }

    public static class ToggleParser
    extends SideKickAction {
        public String getLabel() {
            return this.parserName + " (Toggle)";
        }

        public ToggleParser(String string) {
            super("sidekick.parser." + string + "-toggle", string);
            this.parserName = string;
        }

        public String getCode() {
            return "new sidekick.SideKickActions.ToggleAction(\"" + this.parserName + "\").invoke(view)";
        }

        public void invoke(View view) {
        }
    }

    public static abstract class SideKickAction
    extends EditAction {
        protected String parserName;

        protected SideKickAction(String string, String string2) {
            super(string, new Object[]{string2});
            this.parserName = string2;
        }
    }
}

