/*
 * Decompiled with CFR 0.152.
 */
package gatchan.jedit.hyperlinks;

import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.jEdit;

public class ModeServiceAssociationTableModel
extends AbstractTableModel {
    private Vector<Entry> modes;
    private String col1;
    private String col2;
    private String defaultOption;
    private String propertySuffix;

    private ModeServiceAssociationTableModel(String col1, String col2, String defaultOption, String propertySuffix) {
        this.col1 = col1;
        this.col2 = col2;
        this.defaultOption = defaultOption;
        this.propertySuffix = propertySuffix;
        Mode[] modes = jEdit.getModes();
        this.modes = new Vector(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            this.modes.add(new Entry(modes[i].getName()));
        }
        Collections.sort(this.modes);
    }

    public static JTable getTable(String serviceName, String col2, String defaultValue, String propertySuffix) {
        ModeServiceAssociationTableModel tableModel = new ModeServiceAssociationTableModel("Mode", col2, defaultValue, propertySuffix);
        JTable table = new JTable(tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        String[] serviceNames = ServiceManager.getServiceNames((String)serviceName);
        Vector<String> serviceVector = new Vector<String>(serviceNames.length + 2);
        serviceVector.add(null);
        serviceVector.add(defaultValue);
        for (int i = 0; i < serviceNames.length; ++i) {
            serviceVector.add(serviceNames[i]);
        }
        Collections.sort(serviceVector, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                a = a == null ? "" : a;
                b = b == null ? "" : b;
                return a.compareToIgnoreCase(b);
            }
        });
        MyCellRenderer comboBox = new MyCellRenderer((Vector)serviceVector);
        table.setRowHeight(comboBox.getPreferredSize().height);
        TableColumn column = table.getColumnModel().getColumn(1);
        column.setCellRenderer(comboBox);
        column.setCellEditor(new DefaultCellEditor(new MyCellRenderer((Vector)serviceVector)));
        return table;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.modes.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int row, int col) {
        Entry entry = this.modes.elementAt(row);
        switch (col) {
            case 0: {
                return entry.mode;
            }
            case 1: {
                return entry.serviceName;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry entry = this.modes.elementAt(row);
        switch (col) {
            case 1: {
                entry.serviceName = (String)value;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return this.col1;
            }
            case 1: {
                return this.col2;
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.modes.size(); ++i) {
            this.modes.get(i).save();
        }
    }

    private static class MyCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        MyCellRenderer(Vector vector) {
            super(vector);
            this.setRequestFocusEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedItem(value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    implements Comparable<Entry> {
        private final String mode;
        private String serviceName;

        Entry(String mode) {
            this.mode = mode;
            this.serviceName = jEdit.getProperty((String)("mode." + this.mode + '.' + ModeServiceAssociationTableModel.this.propertySuffix));
        }

        void save() {
            if (ModeServiceAssociationTableModel.this.defaultOption.equals(this.serviceName)) {
                jEdit.resetProperty((String)("mode." + this.mode + '.' + ModeServiceAssociationTableModel.this.propertySuffix));
            } else {
                jEdit.setProperty((String)("mode." + this.mode + '.' + ModeServiceAssociationTableModel.this.propertySuffix), (String)this.serviceName);
            }
        }

        @Override
        public int compareTo(Entry a) {
            return this.mode.compareToIgnoreCase(a.mode);
        }
    }
}

