/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.ErrorMatcher;
import console.gui.Button;
import console.gui.Label;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Caret;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StringList;

class ErrorMatcherPanel
extends AbstractOptionPane {
    private ErrorMatcher matcher;
    private ErrorMatcher testMatcher;
    private JTextField errorName;
    private JTextField error;
    private JTextField warning;
    private JTextField extra;
    private JTextField filename;
    private JTextField line;
    private JTextField message;
    private JTextArea testArea;
    private Button test;
    private Button restore;
    private boolean isOK;

    public ErrorMatcherPanel(String name, ErrorMatcher matcher) {
        super(name);
        this.matcher = matcher;
        this.testMatcher = (ErrorMatcher)matcher.clone();
        this.test = new Button("options.console.errors.apply");
        this.restore = new Button("options.console.errors.reload");
        ActionHandler handler = new ActionHandler();
        this.test.addActionListener(handler);
        this.restore.addActionListener(handler);
        Box box = new Box(0);
        box.add(this.test);
        box.add(this.restore);
        Label label = new Label("options.console.errors.name", 4);
        this.errorName = new JTextField(20);
        this.addComponent(label, this.errorName);
        label = new Label("options.console.errors.match", 4);
        this.error = new JTextField(20);
        this.addComponent(label, this.error, 1);
        label = new Label("options.console.errors.warning", 4);
        this.warning = new JTextField(20);
        this.addComponent(label, this.warning, 2);
        label = new Label("options.console.errors.extra", 4);
        this.extra = new JTextField(20);
        this.addComponent(label, this.extra, 2);
        label = new Label("options.console.errors.filename", 4);
        this.filename = new JTextField(20);
        this.addComponent(label, this.filename, 2);
        label = new Label("options.console.errors.line", 4);
        this.line = new JTextField(20);
        this.addComponent(label, this.line, 2);
        label = new Label("options.console.errors.message", 4);
        this.message = new JTextField(20);
        this.addComponent(label, this.message, 2);
        label = new Label("options.console.errors.testarea.label", 4);
        this.testArea = new JTextArea();
        this.testArea.setFocusable(true);
        this.testArea.addKeyListener(new KeyHandler());
        JScrollPane scrollPane = new JScrollPane(this.testArea);
        scrollPane.setMinimumSize(new Dimension(300, 150));
        scrollPane.setBorder(new TitledBorder(label.getText()));
        this.addComponent(scrollPane, 1);
        JTextArea info = new JTextArea();
        info.setLineWrap(true);
        info.setWrapStyleWord(true);
        info.setOpaque(false);
        String text = jEdit.getProperty((String)"options.console.errors.info");
        info.append(text);
        info.setEditable(false);
        this.addComponent(box, 10);
        this.addComponent(info, 2);
        this.validateTree();
        this.init();
    }

    protected void _init() {
        this.initialized = true;
        this.updateTextFields(this.matcher);
    }

    protected void _save() {
        this.commitTextFields(this.matcher);
        this.matcher.save();
    }

    public void updateTextFields(ErrorMatcher m) {
        this.errorName.setText(m.name);
        this.error.setText(m.error);
        this.warning.setText(m.warning);
        this.extra.setText(m.extraPattern);
        this.filename.setText(m.fileBackref);
        this.line.setText(m.lineBackref);
        this.message.setText(m.messageBackref);
        this.testArea.setText(m.testText);
    }

    public void commitTextFields(ErrorMatcher m) {
        m.clear();
        m.user = true;
        m.name = this.errorName.getText();
        m.error = this.error.getText();
        m.warning = this.warning.getText();
        m.extraPattern = this.extra.getText();
        m.fileBackref = this.filename.getText();
        m.lineBackref = this.line.getText();
        m.messageBackref = this.message.getText();
        m.testText = this.testArea.getText();
    }

    public void validateRegex() {
        this.commitTextFields(this.testMatcher);
        this.isOK = this.testMatcher.isValid();
        if (this.isOK) {
            this.commitTextFields(this.matcher);
        }
    }

    public void testRegex() {
        this.validateRegex();
        String testString = this.testArea.getText();
        jEdit.setProperty((String)"options.console.errors.testarea", (String)testString);
        StringList matches = this.matcher.findMatches(testString);
        if (matches.size() == 0) {
            matches.add((Object)"No Matches");
        }
        StringList errors = this.testMatcher.errors;
        errors.addAll((Collection)matches);
        String errorString = errors.join("\n");
        GUIUtilities.error((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (String)"options.console.errors.checking", (Object[])new String[]{errorString});
    }

    public void apply() {
        this.validateRegex();
        if (!this.isOK) {
            String errorString = this.testMatcher.errors.join("\n");
            GUIUtilities.error((Component)JOptionPane.getFrameForComponent((Component)((Object)this)), (String)"options.console.errors.checking", (Object[])new String[]{errorString});
        } else {
            this.testMatcher.user = true;
            this.matcher.user = true;
        }
    }

    public void cancel() {
        this.updateTextFields(this.matcher);
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                Caret caret = ErrorMatcherPanel.this.testArea.getCaret();
                ErrorMatcherPanel.this.testArea.insert("\n", caret.getDot());
                evt.consume();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ErrorMatcherPanel.this.test) {
                ErrorMatcherPanel.this.testRegex();
            } else if (evt.getSource() == ErrorMatcherPanel.this.restore) {
                ErrorMatcherPanel.this.cancel();
            }
        }
    }
}

