/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.CommandOutputParser;
import console.Console;
import console.ConsolePane;
import console.ConsoleProcess;
import console.Output;
import errorlist.DefaultErrorSource;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class StreamThread
extends Thread {
    private ConsoleProcess process;
    private boolean aborted;
    private InputStream in;
    CommandOutputParser copt = null;
    private StringBuilder lineBuffer;
    private boolean pendingCr;
    private int uncoloredWritten;

    StreamThread(ConsoleProcess process, InputStream in, Color defaultColor) {
        this.process = process;
        this.in = in;
        String currentDirectory = process.getCurrentDirectory();
        Console console = process.getConsole();
        DefaultErrorSource es = console.getErrorSource();
        this.copt = new CommandOutputParser(console.getView(), es, defaultColor);
        this.copt.setDirectory(currentDirectory);
        this.lineBuffer = new StringBuilder(100);
        this.pendingCr = false;
        this.uncoloredWritten = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(this.in, jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        Output output = this.process.getOutput();
        try {
            char[] input = new char[1024];
            while (!this.aborted) {
                int read = isr.read(input, 0, input.length);
                if (this.aborted) {
                    break;
                }
                if (read == -1) {
                    if (this.pendingCr) {
                        this.flushLine(output, "\r");
                    } else if (this.lineBuffer.length() > 0) {
                        this.flushLine(output, "");
                    }
                    break;
                }
                for (int i = 0; i < read; ++i) {
                    char c = input[i];
                    if (c == '\n') {
                        if (this.pendingCr) {
                            this.flushLine(output, "\r\n");
                            continue;
                        }
                        this.flushLine(output, "\n");
                        continue;
                    }
                    if (this.pendingCr) {
                        this.flushLine(output, "\r");
                    }
                    if (c == '\r') {
                        this.pendingCr = true;
                        continue;
                    }
                    this.lineBuffer.append(c);
                }
                if (this.lineBuffer.length() <= this.uncoloredWritten) continue;
                String tail = this.lineBuffer.substring(this.uncoloredWritten);
                output.writeAttrs(null, tail);
                this.uncoloredWritten += tail.length();
            }
        }
        catch (Exception e) {
            if (!this.aborted) {
                Log.log((int)9, (Object)e, (Object)e);
                Console console = this.process.getConsole();
                Output error = this.process.getErrorOutput();
                if (console != null) {
                    Object[] args = new String[]{e.toString()};
                    error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error", (Object[])args));
                }
            }
        }
        finally {
            this.copt.finishErrorParsing();
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.process.threadDone();
        }
    }

    void abort() {
        this.aborted = true;
        this.interrupt();
    }

    private void flushLine(Output output, String eol) {
        String line = this.lineBuffer.toString();
        this.copt.processLine(line);
        AttributeSet color = ConsolePane.colorAttributes(this.copt.getColor());
        if (this.uncoloredWritten > 0) {
            output.setAttrs(this.uncoloredWritten, color);
            output.writeAttrs(color, this.lineBuffer.substring(this.uncoloredWritten) + eol);
        } else {
            try {
                output.writeAttrs(color, line + eol);
            }
            catch (Exception err) {
                Log.log((int)9, (Object)this, (Object)"Can't Flush:", (Throwable)err);
            }
        }
        this.lineBuffer.setLength(0);
        this.pendingCr = false;
        this.uncoloredWritten = 0;
    }
}

