/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredTreeModel
implements TreeModel {
    private boolean ignoreCase;
    private FilteredTreeModelListener listener;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private TreeModel model;
    private ParentProvider parentProvider;
    private TreeMap<String, List<Object>> searchMap = new TreeMap();
    private Set<Object> visibleNodes;

    public FilteredTreeModel(DefaultTreeModel model, boolean ignoreCase) {
        this(model, ignoreCase, new TreeNodeParentProvider());
    }

    public FilteredTreeModel(TreeModel model, boolean ignoreCase, ParentProvider parentProvider) {
        this.ignoreCase = ignoreCase;
        this.listener = new FilteredTreeModelListener();
        this.setModel(model, parentProvider);
    }

    public void addSearchKey(Object node, String key) {
        List<Object> value = this.searchMap.get(key = this.normalize(key));
        if (value == null) {
            value = new ArrayList<Object>(1);
            this.searchMap.put(key, value);
        }
        value.add(node);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void clearFilter() {
        this.filterByText(null);
    }

    protected SortedMap<String, List<Object>> getMatches(String text) {
        TreeMap<String, List<Object>> map = new TreeMap<String, List<Object>>();
        for (String s : this.searchMap.keySet()) {
            if (s.indexOf(text) == -1) continue;
            map.put(s, this.searchMap.get(s));
        }
        return map;
    }

    public void filterByText(String text) {
        if ((text = this.normalize(text)) == null || text.length() == 0) {
            this.visibleNodes = null;
        } else {
            this.visibleNodes = new HashSet<Object>();
            String[] keywords = text.split(" ");
            for (int i = 0; i < keywords.length; ++i) {
                SortedMap<String, List<Object>> nodeListByKey = this.getMatches(text);
                if (i == 0) {
                    for (List<Object> nodes : nodeListByKey.values()) {
                        this.visibleNodes.addAll(nodes);
                    }
                    continue;
                }
                HashSet<Object> allNew = new HashSet<Object>();
                for (List<Object> nodes : nodeListByKey.values()) {
                    allNew.addAll(nodes);
                }
                this.visibleNodes.retainAll(allNew);
            }
            this.ensureParentsVisible();
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.visibleNodes == null) {
            return this.model.getChild(parent, index);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            Object node = this.model.getChild(parent, i);
            if (!this.visibleNodes.contains(node) || index != visibleIndex++) continue;
            return node;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.visibleNodes == null) {
            return this.model.getChildCount(parent);
        }
        int visibleCount = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            if (!this.visibleNodes.contains(this.model.getChild(parent, i))) continue;
            ++visibleCount;
        }
        return visibleCount;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.visibleNodes == null) {
            return this.model.getIndexOfChild(parent, child);
        }
        int visibleIndex = 0;
        int count = this.model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            Object node = this.model.getChild(parent, i);
            if (!this.visibleNodes.contains(node)) continue;
            if (node == child) {
                return visibleIndex;
            }
            ++visibleIndex;
        }
        return -1;
    }

    public TreeModel getModel() {
        return this.model;
    }

    @Override
    public Object getRoot() {
        return this.model.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    public boolean isVisible(Object node) {
        return this.visibleNodes == null || this.visibleNodes.contains(node);
    }

    private String normalize(String text) {
        if (text != null && this.ignoreCase) {
            text = text.toLowerCase();
        }
        return text;
    }

    public void reload() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    public void removeSearchKey(Object node, String key) {
        List<Object> value = this.searchMap.get(key = this.normalize(key));
        if (value != null) {
            value.remove(node);
            if (value.isEmpty()) {
                this.searchMap.remove(key);
            }
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void setModel(DefaultTreeModel model) {
        this.setModel(model, new TreeNodeParentProvider());
    }

    public void setModel(TreeModel model, ParentProvider parentProvider) {
        if (model == null || parentProvider == null) {
            throw new IllegalArgumentException();
        }
        if (this.model != null) {
            this.model.removeTreeModelListener(this.listener);
        }
        this.model = model;
        this.parentProvider = parentProvider;
        this.model.addTreeModelListener(this.listener);
        this.searchMap.clear();
        this.reset();
    }

    public void reset() {
        this.visibleNodes = null;
        this.reload();
    }

    private void ensureParentsVisible() {
        HashSet<Object> parentNodes = new HashSet<Object>();
        for (Object node : this.visibleNodes) {
            Object parentNode = this.parentProvider.getParent(node);
            while (parentNode != null) {
                parentNodes.add(parentNode);
                parentNode = this.parentProvider.getParent(parentNode);
            }
        }
        this.visibleNodes.addAll(parentNodes);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    public static interface ParentProvider {
        public Object getParent(Object var1);
    }

    public static class TreeNodeParentProvider
    implements ParentProvider {
        public Object getParent(Object node) {
            return ((TreeNode)node).getParent();
        }
    }

    private class FilteredTreeModelListener
    implements TreeModelListener {
        private FilteredTreeModelListener() {
        }

        public TreeModelEvent refactorEvent(TreeModelEvent event) {
            if (FilteredTreeModel.this.visibleNodes != null) {
                ArrayList<Object> children = new ArrayList<Object>(event.getChildren().length);
                ArrayList<Integer> indicieList = new ArrayList<Integer>(event.getChildIndices().length);
                for (Object node : event.getChildren()) {
                    FilteredTreeModel.this.visibleNodes.add(node);
                }
                Object parent = event.getTreePath().getLastPathComponent();
                for (Object node : event.getChildren()) {
                    children.add(node);
                    indicieList.add(FilteredTreeModel.this.getIndexOfChild(parent, node));
                }
                int[] indicies = new int[indicieList.size()];
                for (int i = 0; i < indicies.length; ++i) {
                    indicies[i] = (Integer)indicieList.get(i);
                }
                event = new TreeModelEvent(event.getSource(), event.getTreePath(), indicies, children.toArray(new Object[0]));
            }
            return event;
        }

        public void treeNodesChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesChanged(event);
            }
        }

        public void treeNodesInserted(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            event = this.refactorEvent(event);
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        public void treeNodesRemoved(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }

        public void treeStructureChanged(TreeModelEvent event) {
            if (!FilteredTreeModel.this.isVisible(event.getTreePath().getLastPathComponent())) {
                return;
            }
            for (TreeModelListener listener : FilteredTreeModel.this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }
}

