/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Stack;
import javax.swing.text.Segment;
import org.gjt.sp.util.Log;

public class StandardUtilities {
    public static final DecimalFormat KB_FORMAT = new DecimalFormat("#.# kB");
    public static final DecimalFormat MB_FORMAT = new DecimalFormat("#.# MB");

    public static String charsToEscapes(String str) {
        return StandardUtilities.charsToEscapes(str, "\n\t\\\"'");
    }

    public static String charsToEscapes(String str, String toEscape) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (toEscape.indexOf(c) != -1) {
                if (c == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    buf.append("\\t");
                    continue;
                }
                buf.append('\\');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String getIndentString(String str) {
        char ch;
        StringBuilder indentString = new StringBuilder();
        for (int i = 0; i < str.length() && Character.isWhitespace(ch = str.charAt(i)); ++i) {
            indentString.append(ch);
        }
        return indentString.toString();
    }

    public static int getLeadingWhiteSpace(String str) {
        return StandardUtilities.getLeadingWhiteSpace((CharSequence)str);
    }

    public static int getLeadingWhiteSpace(CharSequence str) {
        int whitespace;
        block3: for (whitespace = 0; whitespace < str.length(); ++whitespace) {
            switch (str.charAt(whitespace)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return whitespace;
    }

    public static int getTrailingWhiteSpace(String str) {
        int whitespace = 0;
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            switch (str.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++whitespace;
                    continue block3;
                }
            }
        }
        return whitespace;
    }

    public static int getLeadingWhiteSpaceWidth(String str, int tabSize) {
        return StandardUtilities.getLeadingWhiteSpaceWidth((CharSequence)str, tabSize);
    }

    public static int getLeadingWhiteSpaceWidth(CharSequence str, int tabSize) {
        int whitespace = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
            }
        }
        return whitespace;
    }

    public static String createWhiteSpace(int len, int tabSize) {
        return StandardUtilities.createWhiteSpace(len, tabSize, 0);
    }

    public static String truncateWhiteSpace(int len, int tabSize, String indentStr) {
        StringBuilder buf = new StringBuilder();
        int indent = 0;
        for (int i = 0; indent < len && i < indentStr.length(); ++i) {
            char c = indentStr.charAt(i);
            if (c == ' ') {
                ++indent;
                buf.append(c);
                continue;
            }
            if (c != '\t') continue;
            int withTab = indent + tabSize - indent % tabSize;
            if (withTab > len) {
                while (indent < len) {
                    buf.append(' ');
                    ++indent;
                }
                continue;
            }
            indent = withTab;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String createWhiteSpace(int len, int tabSize, int start) {
        StringBuilder buf = new StringBuilder();
        if (tabSize == 0) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else if (len == 1) {
            buf.append(' ');
        } else {
            int count = (len + start % tabSize) / tabSize;
            if (count != 0) {
                len += start;
            }
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static int getVirtualWidth(Segment seg, int tabSize) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                virtualPosition += tabSize - virtualPosition % tabSize;
                continue;
            }
            ++virtualPosition;
        }
        return virtualPosition;
    }

    public static int getOffsetOfVirtualColumn(Segment seg, int tabSize, int column, int[] totalVirtualWidth) {
        int virtualPosition = 0;
        for (int i = 0; i < seg.count; ++i) {
            char ch = seg.array[seg.offset + i];
            if (ch == '\t') {
                int tabWidth = tabSize - virtualPosition % tabSize;
                if (virtualPosition >= column) {
                    return i;
                }
                virtualPosition += tabWidth;
                continue;
            }
            if (virtualPosition >= column) {
                return i;
            }
            ++virtualPosition;
        }
        if (totalVirtualWidth != null) {
            totalVirtualWidth[0] = virtualPosition;
        }
        return -1;
    }

    public static int compareStrings(String str1, String str2, boolean ignoreCase) {
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int len = Math.min(char1.length, char2.length);
        int i = 0;
        for (int j = 0; i < len && j < len; ++i, ++j) {
            char ch1 = char1[i];
            char ch2 = char2[j];
            if (Character.isDigit(ch1) && Character.isDigit(ch2) && ch1 != '0' && ch2 != '0') {
                int _i;
                int _j = j + 1;
                for (_i = i + 1; _i < char1.length && Character.isDigit(char1[_i]); ++_i) {
                }
                while (_j < char2.length && Character.isDigit(char2[_j])) {
                    ++_j;
                }
                int len1 = _i - i;
                int len2 = _j - j;
                if (len1 > len2) {
                    return 1;
                }
                if (len1 < len2) {
                    return -1;
                }
                for (int k = 0; k < len1; ++k) {
                    ch1 = char1[i + k];
                    ch2 = char2[j + k];
                    if (ch1 == ch2) continue;
                    return ch1 - ch2;
                }
                i = _i - 1;
                j = _j - 1;
                continue;
            }
            if (ignoreCase) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return char1.length - char2.length;
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String globToRE(String glob) {
        if (glob.startsWith("(re)")) {
            return glob.substring(4);
        }
        Object NEG = new Object();
        Object GROUP = new Object();
        Stack<Object> state = new Stack<Object>();
        StringBuilder buf = new StringBuilder();
        boolean backslash = false;
        block10: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    backslash = true;
                    continue block10;
                }
                case '?': {
                    buf.append('.');
                    continue block10;
                }
                case '(': 
                case ')': 
                case '+': 
                case '.': {
                    buf.append('\\');
                    buf.append(c);
                    continue block10;
                }
                case '*': {
                    buf.append(".*");
                    continue block10;
                }
                case '|': {
                    if (backslash) {
                        buf.append("\\|");
                        continue block10;
                    }
                    buf.append('|');
                    continue block10;
                }
                case '{': {
                    buf.append('(');
                    if (i + 1 != glob.length() && glob.charAt(i + 1) == '!') {
                        buf.append('?');
                        state.push(NEG);
                        continue block10;
                    }
                    state.push(GROUP);
                    continue block10;
                }
                case ',': {
                    if (!state.isEmpty() && state.peek() == GROUP) {
                        buf.append('|');
                        continue block10;
                    }
                    buf.append(',');
                    continue block10;
                }
                case '}': {
                    if (!state.isEmpty()) {
                        buf.append(')');
                        if (state.pop() != NEG) continue block10;
                        buf.append(".*");
                        continue block10;
                    }
                    buf.append('}');
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static boolean regionMatches(CharSequence seq, int toff, CharSequence other, int ooff, int len) {
        if (toff < 0 || ooff < 0 || len < 0) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < len; ++i) {
            if (i + toff >= seq.length()) {
                ret = false;
                break;
            }
            char c1 = seq.charAt(i + toff);
            if (i + ooff >= other.length()) {
                ret = false;
                break;
            }
            char c2 = other.charAt(i + ooff);
            if (c1 == c2) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean startsWith(CharSequence seq, String str) {
        boolean ret = true;
        for (int i = 0; i < str.length(); ++i) {
            if (i < seq.length() && seq.charAt(i) == str.charAt(i)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean getBoolean(Object obj, boolean def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if ("true".equals(obj) || "yes".equals(obj) || "on".equals(obj)) {
            return true;
        }
        if ("false".equals(obj) || "no".equals(obj) || "off".equals(obj)) {
            return false;
        }
        return def;
    }

    public static String formatFileSize(long length) {
        if (length < 1024L) {
            return length + " Bytes";
        }
        if (length < 0x100000L) {
            return KB_FORMAT.format((double)length / 1024.0);
        }
        return MB_FORMAT.format((double)length / 1024.0 / 1024.0);
    }

    private StandardUtilities() {
    }

    public static byte[] md5(String s) {
        byte[] dummy = new byte[1];
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            Log.log(9, StandardUtilities.class, "Can't Calculate MD5 hash!", e);
            return dummy;
        }
    }

    public static class StringCompare<E>
    implements Comparator<E> {
        private boolean icase;

        public StringCompare(boolean icase) {
            this.icase = icase;
        }

        public StringCompare() {
        }

        @Override
        public int compare(E obj1, E obj2) {
            return StandardUtilities.compareStrings(obj1.toString(), obj2.toString(), this.icase);
        }
    }
}

