/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.PingPongList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EncodingsOptionPane
extends AbstractOptionPane {
    private JComboBox defaultEncoding;
    private JCheckBox encodingAutodetect;
    private JTextField encodingDetectors;
    private JTextField fallbackEncodings;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private PingPongList<String> pingPongList;

    public EncodingsOptionPane() {
        super("encodings");
    }

    @Override
    protected void _init() {
        String[] encodings = MiscUtilities.getEncodings(true);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        this.defaultEncoding = new JComboBox<String>(encodings);
        this.defaultEncoding.setEditable(true);
        this.defaultEncoding.setSelectedItem(jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
        this.addComponent(jEdit.getProperty("options.general.encoding"), (Component)this.defaultEncoding);
        this.encodingAutodetect = new JCheckBox(jEdit.getProperty("options.general.encodingAutodetect"));
        this.encodingAutodetect.setSelected(jEdit.getBooleanProperty("buffer.encodingAutodetect"));
        this.addComponent((Component)this.encodingAutodetect, 1);
        this.encodingDetectors = new JTextField(jEdit.getProperty("encodingDetectors", ""));
        this.addComponent(jEdit.getProperty("options.general.encodingDetectors"), (Component)this.encodingDetectors);
        this.fallbackEncodings = new JTextField(jEdit.getProperty("fallbackEncodings", ""));
        this.fallbackEncodings.setToolTipText(jEdit.getProperty("options.general.fallbackEncodings.tooltip"));
        this.addComponent(jEdit.getProperty("options.general.fallbackEncodings"), (Component)this.fallbackEncodings);
        encodings = MiscUtilities.getEncodings(false);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        ArrayList<String> availableEncodings = new ArrayList<String>();
        ArrayList<String> selectedEncodings = new ArrayList<String>();
        for (String encoding : encodings) {
            boolean selected;
            boolean bl = selected = !jEdit.getBooleanProperty("encoding.opt-out." + encoding, false);
            if (selected) {
                selectedEncodings.add(encoding);
                continue;
            }
            availableEncodings.add(encoding);
        }
        this.pingPongList = new PingPongList(availableEncodings, selectedEncodings);
        this.pingPongList.setLeftTitle(jEdit.getProperty("options.encodings.available"));
        this.pingPongList.setRightTitle(jEdit.getProperty("options.encodings.selected"));
        this.pingPongList.setLeftTooltip(jEdit.getProperty("options.encodings.available.tooltip"));
        this.pingPongList.setRightTooltip(jEdit.getProperty("options.encodings.selected.tooltip"));
        this.addComponent(this.pingPongList, 1);
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(Box.createHorizontalStrut(12));
        ActionHandler actionHandler = new ActionHandler();
        this.selectAllButton = new JButton(jEdit.getProperty("options.encodings.selectAll"));
        this.selectAllButton.addActionListener(actionHandler);
        this.selectAllButton.setEnabled(this.pingPongList.getLeftSize() != 0);
        buttonsBox.add(this.selectAllButton);
        buttonsBox.add(Box.createHorizontalStrut(12));
        this.selectNoneButton = new JButton(jEdit.getProperty("options.encodings.selectNone"));
        this.selectNoneButton.addActionListener(actionHandler);
        this.selectNoneButton.setEnabled(this.pingPongList.getRightSize() != 0);
        buttonsBox.add(this.selectNoneButton);
        buttonsBox.add(Box.createHorizontalStrut(12));
        this.addComponent(buttonsBox);
    }

    @Override
    protected void _save() {
        jEdit.setProperty("buffer.encoding", (String)this.defaultEncoding.getSelectedItem());
        jEdit.setBooleanProperty("buffer.encodingAutodetect", this.encodingAutodetect.isSelected());
        jEdit.setProperty("encodingDetectors", this.encodingDetectors.getText());
        jEdit.setProperty("fallbackEncodings", this.fallbackEncodings.getText());
        Iterator<String> available = this.pingPongList.getLeftDataIterator();
        while (available.hasNext()) {
            String encoding = available.next();
            jEdit.setBooleanProperty("encoding.opt-out." + encoding, true);
        }
        Iterator<String> selected = this.pingPongList.getRightDataIterator();
        while (selected.hasNext()) {
            String encoding = selected.next();
            jEdit.unsetProperty("encoding.opt-out." + encoding);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == EncodingsOptionPane.this.selectAllButton) {
                EncodingsOptionPane.this.pingPongList.moveAllToRight();
            } else if (source == EncodingsOptionPane.this.selectNoneButton) {
                EncodingsOptionPane.this.pingPongList.moveAllToLeft();
            }
        }
    }
}

