/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.StandardUtilities;

public class FilePropertiesDialog
extends EnhancedDialog {
    private final VFSBrowser browser;
    private final VFSFile[] selectedFiles;
    private final VFSFile local;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameTextField;
    private JLabel infoIcon;
    private JCheckBox readable;
    private JCheckBox write;

    public FilePropertiesDialog(View view, VFSBrowser browser, VFSFile[] files) {
        super(view, jEdit.getProperty("vfs.browser.properties.title"), true);
        GUIUtilities.loadGeometry(this, "propdialog");
        this.browser = browser;
        this.selectedFiles = files.length > 0 ? files : browser.getSelectedFiles();
        this.local = this.selectedFiles[0];
        this.createAndShowGUI();
    }

    public void addComponentsToPane() {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 5, 0, 5));
        this.setContentPane(content);
        if (this.selectedFiles.length == 1) {
            content.add("North", this.createNorthPanel());
            content.add("Center", this.createCenterPanel());
            content.add("South", this.createSouthPanel());
        } else if (this.selectedFiles.length > 1) {
            content.add("North", this.createNorthPanelAll());
            content.add("Center", this.createCenterPanelAll());
            content.add("South", this.createSouthPanelAll());
        }
    }

    public JPanel createNorthPanelAll() {
        JPanel northPanel = new JPanel(new BorderLayout());
        this.infoIcon = new JLabel();
        this.infoIcon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        northPanel.add("West", this.infoIcon);
        int filesCounter = 0;
        int directoriesCounter = 0;
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            if (this.selectedFiles[i].getType() == 1) {
                ++directoriesCounter;
                continue;
            }
            if (this.selectedFiles[i].getType() != 0) continue;
            ++filesCounter;
        }
        JPanel nameField = new JPanel();
        nameField.add(new JLabel(jEdit.getProperty("fileprop.selectedFiles") + ": " + filesCounter + ", " + jEdit.getProperty("fileprop.selectedDirectories") + ": " + directoriesCounter));
        northPanel.add("Center", nameField);
        northPanel.add("South", new JPanel());
        return northPanel;
    }

    public JPanel createCenterPanelAll() {
        long filesSize = 0L;
        JPanel centerPanel = new JPanel(new BorderLayout());
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            if (this.selectedFiles[i].getType() == 1) {
                File ioFile = new File(this.selectedFiles[i].getPath());
                filesSize += IOUtilities.fileLength(ioFile);
                continue;
            }
            if (this.selectedFiles[i].getType() != 0) continue;
            filesSize += this.selectedFiles[i].getLength();
        }
        JPanel propField = new JPanel();
        propField.setLayout(new GridLayout(2, 1));
        String path = this.local.getPath();
        path = OperatingSystem.isWindows() || OperatingSystem.isWindows9x() || OperatingSystem.isWindowsNT() ? path.substring(0, path.lastIndexOf(92)) : path.substring(0, path.lastIndexOf(47));
        propField.add(new JLabel(jEdit.getProperty("fileprop.path") + ": " + path));
        propField.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(filesSize)));
        Border etch = BorderFactory.createEtchedBorder();
        propField.setBorder(BorderFactory.createTitledBorder(etch, jEdit.getProperty("fileprop.properties")));
        centerPanel.add("Center", propField);
        return centerPanel;
    }

    public JPanel createSouthPanelAll() {
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel buttonsField = new JPanel();
        this.okButton = new JButton(jEdit.getProperty("fileprop.okBtn"));
        buttonsField.add(this.okButton);
        this.okButton.addActionListener(actionHandler);
        this.cancelButton = new JButton(jEdit.getProperty("fileprop.cancelBtn"));
        buttonsField.add(this.cancelButton);
        this.cancelButton.addActionListener(actionHandler);
        southPanel.add("East", buttonsField);
        return southPanel;
    }

    public JPanel createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        this.infoIcon = new JLabel();
        this.infoIcon.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        northPanel.add("West", this.infoIcon);
        JPanel nameField = new JPanel();
        nameField.add(new JLabel(jEdit.getProperty("fileprop.name") + ": "));
        this.nameTextField = new JTextField(this.local.getName(), 20);
        nameField.add(this.nameTextField);
        northPanel.add("Center", nameField);
        northPanel.add("South", new JPanel());
        return northPanel;
    }

    public JPanel createCenterPanel() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel propField = new JPanel();
        propField.setLayout(new GridLayout(4, 1));
        propField.add(new JLabel(jEdit.getProperty("fileprop.name") + ": " + this.local.getName()));
        propField.add(new JLabel(jEdit.getProperty("fileprop.path") + ": " + this.local.getPath()));
        if (this.local instanceof FileVFS.LocalFile) {
            propField.add(new JLabel(jEdit.getProperty("fileprop.lastmod") + ": " + sdf.format(new Date(((FileVFS.LocalFile)this.local).getModified()))));
        }
        if (this.local.getType() == 1) {
            File ioFile = new File(this.local.getPath());
            propField.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(IOUtilities.fileLength(ioFile))));
        } else {
            propField.add(new JLabel(jEdit.getProperty("fileprop.size") + ": " + StandardUtilities.formatFileSize(this.local.getLength())));
        }
        Border etch = BorderFactory.createEtchedBorder();
        propField.setBorder(BorderFactory.createTitledBorder(etch, jEdit.getProperty("fileprop.properties")));
        centerPanel.add("Center", propField);
        JPanel attributeField = new JPanel();
        attributeField.setLayout(new GridLayout(1, 2));
        this.readable = new JCheckBox(jEdit.getProperty("fileprop.readable"));
        this.readable.setSelected(this.local.isReadable());
        this.readable.setEnabled(false);
        attributeField.add(this.readable);
        this.write = new JCheckBox(jEdit.getProperty("fileprop.writeable"));
        this.write.setSelected(this.local.isWriteable());
        this.write.setEnabled(false);
        attributeField.add(this.write);
        attributeField.setBorder(BorderFactory.createTitledBorder(etch, jEdit.getProperty("fileprop.attribute")));
        centerPanel.add("South", attributeField);
        return centerPanel;
    }

    public JPanel createSouthPanel() {
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel buttonsField = new JPanel();
        this.okButton = new JButton(jEdit.getProperty("fileprop.okBtn"));
        buttonsField.add(this.okButton);
        this.okButton.addActionListener(actionHandler);
        this.cancelButton = new JButton(jEdit.getProperty("fileprop.cancelBtn"));
        buttonsField.add(this.cancelButton);
        this.cancelButton.addActionListener(actionHandler);
        southPanel.add("East", buttonsField);
        return southPanel;
    }

    @Override
    public void ok() {
        if (this.nameTextField != null) {
            this.browser.rename(this.browser.getSelectedFiles()[0].getPath(), this.nameTextField.getText());
        }
        GUIUtilities.saveGeometry(this, "propdialog");
        this.setVisible(false);
    }

    @Override
    public void cancel() {
        GUIUtilities.saveGeometry(this, "propdialog");
        this.setVisible(false);
    }

    private void createAndShowGUI() {
        this.addComponentsToPane();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setFocusable(true);
        this.toFront();
        this.requestFocus();
        this.setResizable(false);
        this.setVisible(true);
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == FilePropertiesDialog.this.okButton) {
                FilePropertiesDialog.this.ok();
            } else if (source == FilePropertiesDialog.this.cancelButton) {
                FilePropertiesDialog.this.cancel();
            }
        }
    }
}

