/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;

public class BrowserCommandsMenu
extends JPopupMenu {
    private VFSBrowser browser;
    private HashMap<String, JRadioButtonMenuItem> encodingMenuItems;
    private JCheckBoxMenuItem autoDetect;
    private JRadioButtonMenuItem otherEncoding;

    public BrowserCommandsMenu(VFSBrowser browser, VFSFile[] files) {
        this.browser = browser;
        if (files != null) {
            VFS vfs = VFSManager.getVFSForPath(files[0].getDeletePath());
            int type = files[0].getType();
            boolean fileOpen = jEdit.getBuffer(files[0].getPath()) != null;
            boolean deletePathOpen = jEdit.getBuffer(files[0].getDeletePath()) != null;
            boolean delete = !deletePathOpen && (vfs.getCapabilities() & 8) != 0;
            boolean rename = !fileOpen && (vfs.getCapabilities() & 0x10) != 0;
            for (int i = 1; i < files.length; ++i) {
                VFSFile file = files[i];
                VFS _vfs = VFSManager.getVFSForPath(file.getDeletePath());
                delete &= vfs == _vfs && (_vfs.getCapabilities() & 8) != 0;
                if (type != file.getType()) {
                    type = -1;
                }
                rename = false;
                if (jEdit.getBuffer(file.getPath()) == null) continue;
                fileOpen = true;
            }
            if (type == 1 || type == 2) {
                if (files.length == 1) {
                    this.add(this.createMenuItem("browse"));
                }
                if (browser.getMode() == 2) {
                    this.add(this.createMenuItem("browse-window"));
                }
            } else if (type == 0 && (browser.getMode() == 2 || browser.getMode() == 4)) {
                this.add(this.createMenuItem("open"));
                this.add(GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "vfs.browser.open-in"));
                this.add(this.createMenuItem("insert"));
                if (fileOpen) {
                    this.add(this.createMenuItem("close"));
                }
            } else if (type != -1) {
                this.add(this.createMenuItem("open"));
            }
            if (rename) {
                this.add(this.createMenuItem("rename"));
            }
            if (delete) {
                this.add(this.createMenuItem("delete"));
            }
            this.add(this.createMenuItem("copy-path"));
            this.add(this.createMenuItem("paste"));
            if (files.length == 1 || browser.getSelectedFiles().length != 0) {
                this.add(this.createMenuItem("properties"));
            }
            this.addSeparator();
        }
        this.add(this.createMenuItem("up"));
        this.add(this.createMenuItem("previous"));
        this.add(this.createMenuItem("next"));
        this.add(this.createMenuItem("reload"));
        this.add(this.createMenuItem("roots"));
        this.add(this.createMenuItem("home"));
        this.add(this.createMenuItem("synchronize"));
        this.addSeparator();
        if (browser.getMode() == 2) {
            this.add(this.createMenuItem("new-file"));
        }
        this.add(this.createMenuItem("new-directory"));
        if (browser.getMode() == 2) {
            this.addSeparator();
            this.add(this.createMenuItem("search-directory"));
        }
        this.addSeparator();
        this.add(this.createMenuItem("show-hidden-files"));
        if (browser.getMode() == 2 || browser.getMode() == 4) {
            this.addSeparator();
            this.add(this.createEncodingMenu());
        }
        this.addSeparator();
        this.add(this.createPluginMenu(browser));
        this.update();
    }

    public void update() {
        if (this.encodingMenuItems != null && this.browser.currentEncoding != null) {
            JRadioButtonMenuItem mi = this.encodingMenuItems.get(this.browser.currentEncoding);
            if (mi != null) {
                mi.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding.label"));
            } else {
                this.otherEncoding.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding-2.label", new String[]{this.browser.currentEncoding}));
            }
        }
    }

    private JMenuItem createMenuItem(String name) {
        return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), "vfs.browser." + name, false);
    }

    private JMenu createEncodingMenu() {
        JMenu encodingMenu;
        ActionHandler actionHandler = new ActionHandler();
        this.encodingMenuItems = new HashMap();
        JMenu menu = encodingMenu = new JMenu(jEdit.getProperty("vfs.browser.commands.encoding.label"));
        this.autoDetect = new JCheckBoxMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        this.autoDetect.setSelected(this.browser.autoDetectEncoding);
        this.autoDetect.setActionCommand("auto-detect");
        this.autoDetect.addActionListener(actionHandler);
        menu.add(this.autoDetect);
        menu.addSeparator();
        ButtonGroup grp = new ButtonGroup();
        ArrayList<JRadioButtonMenuItem> encodingMenuItemList = new ArrayList<JRadioButtonMenuItem>();
        String[] encodings = MiscUtilities.getEncodings(true);
        for (int i = 0; i < encodings.length; ++i) {
            String encoding = encodings[i];
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(encoding);
            mi.setActionCommand("encoding@" + encoding);
            mi.addActionListener(actionHandler);
            grp.add(mi);
            this.encodingMenuItems.put(encoding, mi);
            encodingMenuItemList.add(mi);
        }
        String systemEncoding = System.getProperty("file.encoding");
        if (this.encodingMenuItems.get(systemEncoding) == null) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(systemEncoding);
            mi.setActionCommand("encoding@" + systemEncoding);
            mi.addActionListener(actionHandler);
            grp.add(mi);
            this.encodingMenuItems.put(systemEncoding, mi);
            encodingMenuItemList.add(mi);
        }
        Collections.sort(encodingMenuItemList, new MenuItemTextComparator());
        for (JRadioButtonMenuItem mi : encodingMenuItemList) {
            if (menu.getMenuComponentCount() > 20) {
                JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                menu.add(newMenu);
                menu = newMenu;
            }
            menu.add(mi);
        }
        menu.addSeparator();
        this.otherEncoding = new JRadioButtonMenuItem();
        this.otherEncoding.setActionCommand("other-encoding");
        this.otherEncoding.addActionListener(actionHandler);
        grp.add(this.otherEncoding);
        menu.add(this.otherEncoding);
        return encodingMenu;
    }

    private JMenu createPluginMenu(VFSBrowser browser) {
        JMenu pluginMenu = new JMenu(jEdit.getProperty("vfs.browser.plugins.label"));
        return (JMenu)browser.createPluginsMenu(pluginMenu, false);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String actionCommand = evt.getActionCommand();
            if (actionCommand.equals("auto-detect")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.autoDetectEncoding = BrowserCommandsMenu.this.autoDetect.isSelected();
            } else if (actionCommand.equals("other-encoding")) {
                String encoding = GUIUtilities.input(BrowserCommandsMenu.this.browser, "encoding-prompt", null, jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
                if (encoding == null) {
                    return;
                }
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = encoding;
            } else if (actionCommand.startsWith("encoding@")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = actionCommand.substring(9);
            }
        }
    }
}

