/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.Directory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class TreeNode {
    int starty;
    int endy;
    int number;
    String name;
    String path;
    Vector leaves = new Vector(10, 10);
    boolean unfold = false;

    public void insertNode(String string, String string2, String string3, int n, boolean bl) {
        if (string2.length() == 0) {
            this.leaves.addElement(new TreeNode(string, string3, n));
            this.unfold = this.unfold || bl;
        } else {
            String string4;
            String string5;
            boolean bl2 = this.unfold = this.unfold || bl;
            if (string2.indexOf(47) < 0) {
                string5 = string2;
                string4 = "";
            } else {
                string5 = string2.substring(0, string2.indexOf(47));
                string4 = string2.substring(string2.indexOf(47) + 1);
            }
            Enumeration enumeration = this.leaves.elements();
            TreeNode treeNode = null;
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = (TreeNode)enumeration.nextElement();
                if (!treeNode2.name.equals(string5)) continue;
                treeNode = treeNode2;
                break;
            }
            if (treeNode == null) {
                treeNode = new TreeNode(string5, "", -1);
                this.leaves.addElement(treeNode);
            }
            treeNode.insertNode(string, string4, string3, n, bl);
        }
    }

    public TreeNode(String string, String string2, int n) {
        this.name = string;
        this.path = string2;
        this.number = n;
    }

    public TreeNode(String string, String string2, int n, boolean bl) {
        this(string, string2, n);
        this.unfold = bl;
    }

    public int getNumber() {
        return this.number;
    }

    public TreeNode lookup(int n) {
        if (n >= this.starty && n < this.endy) {
            return this;
        }
        if (this.unfold) {
            for (int i = 0; i < this.leaves.size(); ++i) {
                TreeNode treeNode = ((TreeNode)this.leaves.elementAt(i)).lookup(n);
                if (treeNode == null) continue;
                return treeNode;
            }
        }
        return null;
    }

    public boolean select() {
        if (!this.leaves.isEmpty()) {
            if (this.unfold) {
                this.collapse();
            } else {
                this.unfold = true;
            }
            return true;
        }
        return false;
    }

    public void collapse() {
        this.unfold = false;
    }

    void collapsedNodes(Vector vector) {
        if (this.number >= 0) {
            vector.addElement(new Integer(this.number));
        }
        Enumeration enumeration = this.leaves.elements();
        while (enumeration.hasMoreElements()) {
            ((TreeNode)enumeration.nextElement()).collapsedNodes(vector);
        }
    }

    public void collapsedDirectories(Vector vector) {
        if (!this.unfold) {
            Vector vector2 = new Vector(10, 10);
            vector.addElement(new Directory(this, this.name, vector2));
            this.collapsedNodes(vector2);
        } else {
            Enumeration enumeration = this.leaves.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (treeNode.leaves.isEmpty()) continue;
                treeNode.collapsedDirectories(vector);
            }
        }
    }

    public Dimension draw(Graphics graphics, int n, int n2, TreeNode treeNode) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = n3 / 10 + 1;
        int[] nArray = new int[]{n + n4, n + n3 - n4, n + n3 / 2};
        int[] nArray2 = new int[]{n2 + n4, n2 + n4, n2 + 3 * n3 / 4 - n4};
        int[] nArray3 = new int[]{n + n4, n + 3 * n3 / 4 - n4, n + n4};
        int[] nArray4 = new int[]{n2 + n4, n2 + n3 / 2, n2 + n3 - n4};
        int n5 = 0;
        if (this.unfold) {
            graphics.setColor(Color.green);
            graphics.fillPolygon(nArray, nArray2, 3);
            graphics.setColor(Color.black);
            graphics.drawString(this.name, n + n3 + 4, n2 + fontMetrics.getAscent());
            this.starty = n2;
            this.endy = n2 + n3;
            n5 = Math.max(n5, n + n3 + 4 + fontMetrics.stringWidth(this.name));
            n2 += n3 + 5;
            for (int i = 0; i < this.leaves.size(); ++i) {
                Dimension dimension = ((TreeNode)this.leaves.elementAt(i)).draw(graphics, n + n3 + 4, n2, treeNode);
                n2 = dimension.height;
                n5 = Math.max(n5, dimension.width);
            }
        } else {
            graphics.setColor(this.leaves.isEmpty() ? Color.blue : Color.red);
            graphics.fillPolygon(nArray3, nArray4, 3);
            if (this == treeNode && this.leaves.isEmpty()) {
                graphics.setColor(Color.white);
                graphics.fillRect(n + n3 + 4, n2, fontMetrics.stringWidth(this.name), n3);
            }
            graphics.setColor(Color.black);
            graphics.drawString(this.name, n + n3 + 4, n2 + fontMetrics.getAscent());
            this.starty = n2;
            this.endy = n2 + n3;
            n5 = Math.max(n5, n + n3 + 4 + fontMetrics.stringWidth(this.name));
            n2 += n3 + 5;
        }
        return new Dimension(n5, n2);
    }
}

