/*
 * Decompiled with CFR 0.152.
 */
package GraphBrowser;

import GraphBrowser.SplineSection;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Spline {
    Vector sections;
    Vector points;
    Point start;
    Point end;

    public Spline(Vector vector) {
        this.start = (Point)vector.firstElement();
        this.end = (Point)vector.lastElement();
        this.sections = new Vector(10, 10);
        for (int i = 1; i <= vector.size() - 4; i += 3) {
            Point point = (Point)vector.elementAt(i);
            Point point2 = (Point)vector.elementAt(i + 1);
            Point point3 = (Point)vector.elementAt(i + 2);
            SplineSection splineSection = new SplineSection(point3.x - 2 * point2.x + point.x, 2.0 * (double)(point2.x - point.x), point.x, point3.y - 2 * point2.y + point.y, 2.0 * (double)(point2.y - point.y), point.y, Math.abs(point3.x - point.x), Math.abs(point3.y - point.y));
            this.sections.addElement(splineSection);
        }
        this.points = vector;
    }

    public void draw(Graphics graphics) {
        Enumeration enumeration = this.sections.elements();
        Point point = this.start;
        while (enumeration.hasMoreElements()) {
            point = ((SplineSection)enumeration.nextElement()).draw(graphics, point);
        }
        graphics.drawLine(point.x, point.y, this.end.x, this.end.y);
    }

    public void PS(PrintWriter printWriter) {
        printWriter.println("n " + this.start.x + " " + this.start.y + " m");
        for (int i = 1; i <= this.points.size() - 4; i += 3) {
            Point point = (Point)this.points.elementAt(i);
            Point point2 = (Point)this.points.elementAt(i + 1);
            Point point3 = (Point)this.points.elementAt(i + 2);
            printWriter.println(point.x + " " + point.y + " l");
            printWriter.println(point.x + " " + point.y + " " + point2.x + " " + point2.y + " " + point3.x + " " + point3.y + " c");
        }
        printWriter.println(this.end.x + " " + this.end.y + " l s");
    }
}

