/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.Utility$;
import scala.xml.include.sax.XIncludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncluder
implements ContentHandler,
LexicalHandler,
ScalaObject {
    private XIncludeFilter filter;
    private final Stack<String> entities;
    private boolean inDTD;
    private OutputStreamWriter out;
    private final String encoding;

    public XIncluder(OutputStream outs, String encoding) {
        this.encoding = encoding;
        this.out = new OutputStreamWriter(outs, encoding);
        this.inDTD = false;
        this.entities = new Stack();
        this.filter = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void comment(char[] ch, int start2, int length2) {
        if (this.inDTD() || this.filter().insideIncludeElement()) return;
        try {
            this.out().write("<!--");
            this.out().write(ch, start2, length2);
            this.out().write("-->");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void setFilter(XIncludeFilter filter2) {
        this.filter_$eq(filter2);
    }

    private void filter_$eq(XIncludeFilter x$1) {
        this.filter = x$1;
    }

    private XIncludeFilter filter() {
        return this.filter;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endEntity(String name) {
        this.entities().pop();
    }

    @Override
    public void startEntity(String name) {
        this.entities().push(name);
    }

    @Override
    public void endDTD() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startDTD(String name, String publicID, String systemID) {
        this.inDTD_$eq(true);
        if (this.entities().size() != 0) return;
        String id = "";
        String string2 = publicID;
        if (string2 == null || string2.equals(null)) {
            String string3 = systemID;
            if (string3 != null && !string3.equals(null)) {
                id = new StringBuilder().append((Object)" SYSTEM \"").append((Object)systemID).append(BoxesRunTime.boxToCharacter('\"')).toString();
            }
        } else {
            id = new StringBuilder().append((Object)" PUBLIC \"").append((Object)publicID).append((Object)"\" \"").append((Object)systemID).append(BoxesRunTime.boxToCharacter('\"')).toString();
        }
        try {
            this.out().write(new StringBuilder().append((Object)"<!DOCTYPE ").append((Object)name).append((Object)id).append((Object)">\r\n").toString());
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Error while writing DOCTYPE", iOException);
        }
    }

    private Stack<String> entities() {
        return this.entities;
    }

    private void inDTD_$eq(boolean x$1) {
        this.inDTD = x$1;
    }

    private boolean inDTD() {
        return this.inDTD;
    }

    @Override
    public void skippedEntity(String name) {
        try {
            this.out().write(new StringBuilder().append((Object)"&").append((Object)name).append((Object)";").toString());
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void processingInstruction(String target, String data2) {
        try {
            this.out().write(new StringBuilder().append((Object)"<?").append((Object)target).append((Object)" ").append((Object)data2).append((Object)"?>").toString());
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start2, int length2) {
        this.characters(ch, start2, length2);
    }

    @Override
    public void characters(char[] ch, int start2, int length2) {
        try {
            for (int i = 0; i < length2; ++i) {
                char c = ch[start2 + i];
                if (c == '&') {
                    this.out().write("&amp;");
                    continue;
                }
                if (c == '<') {
                    this.out().write("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.out().write("&gt;");
                    continue;
                }
                this.out().write(Predef$.MODULE$.char2int(c));
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        try {
            this.out().write(new StringBuilder().append((Object)"</").append((Object)qualifiedName).append((Object)">").toString());
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
        try {
            this.out().write(new StringBuilder().append((Object)"<").append((Object)qualifiedName).toString());
            for (int i = 0; i < atts.getLength(); ++i) {
                this.out().write(" ");
                this.out().write(atts.getQName(i));
                this.out().write("='");
                String value2 = atts.getValue(i);
                this.out().write(Utility$.MODULE$.escape(value2));
                this.out().write("'");
            }
            this.out().write(">");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endDocument() {
        try {
            this.out().flush();
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Flush failed", iOException);
        }
    }

    @Override
    public void startDocument() {
        try {
            this.out().write(new StringBuilder().append((Object)"<?xml version='1.0' encoding='").append((Object)this.encoding).append((Object)"'?>\r\n").toString());
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public void out_$eq(OutputStreamWriter x$1) {
        this.out = x$1;
    }

    public OutputStreamWriter out() {
        return this.out;
    }

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }
}

