(*  Title:      Pure/General/buffer.ML
    ID:         $Id: buffer.ML,v 1.4.2.1 2004/06/08 00:29:54 kleing Exp $
    Author:     Markus Wenzel, TU Muenchen

Simple string buffers.
*)

signature BUFFER =
sig
  type T
  val empty: T
  val add: string -> T -> T
  val content: T -> string
  val write: Path.T -> T -> unit
end;

structure Buffer: BUFFER =
struct

datatype T = Buffer of string list;

val empty = Buffer [];
fun add x (Buffer xs) = Buffer (x :: xs);
fun content (Buffer xs) = implode (rev xs);
fun write path buffer = File.write path (content buffer);

end;
