theory Inductive_Demo
imports Main
begin

subsection "Inductive definition of the even numbers"

inductive ev :: "nat \<Rightarrow> bool" where
  ev0: "ev 0"
| evSS: "ev n \<Longrightarrow> ev (Suc(Suc n))"

thm ev0 evSS
thm ev.intros
thm ev.induct

text \<open>Using the introduction rules:\<close>

lemma "ev (Suc(Suc(Suc(Suc 0))))"

  done


thm evSS[OF evSS[OF ev0]]

text \<open>A recursive definition of evenness:\<close>

fun evn :: "nat \<Rightarrow> bool" where
  "evn 0 = True"
| "evn (Suc 0) = False"
| "evn (Suc(Suc n)) = evn n"

text \<open>A simple example of rule induction:\<close>

lemma "ev n \<Longrightarrow> evn n"
  apply (induction rule: ev.induct)

  done


text \<open>An induction on the computation of evn:\<close>

lemma "evn n \<Longrightarrow> ev n"
  apply (induction n rule: evn.induct)

  done


text \<open>No problem with termination because the premises are always smaller
than the conclusion:\<close>

declare ev.intros[simp,intro]

text \<open>A shorter proof:\<close>

lemma "evn n \<Longrightarrow> ev n"
  apply (induction n rule: evn.induct)
    apply (simp_all)
  done

text \<open>The power of arith:\<close>

lemma "ev n \<Longrightarrow> \<exists>k. n = 2*k"
  apply (induction rule: ev.induct)
   apply simp
  apply arith
  done


subsection "Inductive definition of the reflexive transitive closure"

inductive
  star :: "('a \<Rightarrow> 'a \<Rightarrow> bool) \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool"
where
  refl:  "star r x x"
| step:  "r x y \<Longrightarrow> star r y z \<Longrightarrow> star r x z"

thm star.induct

lemma star_trans:
  "star r x y \<Longrightarrow> star r y z \<Longrightarrow> star r x z"
  apply (induction rule: star.induct)
   apply (assumption)
  subgoal for r x x' y

    done
  done

end
