(*<*)
theory Assignment1
  imports Big_Step
begin
(*>*)

text \<open>The following tasks are about writing/generating and verifying programs in the IMP language.

  Note that the version of the IMP language defined in the files in this assignment template uses
  natural numbers as variable identifiers rather than strings, in order to simplify reasoning about
  variable names.\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{4 marks}\<close>

text \<open>Prove the following lemma about the preservation of invariants, which can be useful when
  proving properties about programs containing WHILE loops:\<close>

lemma While_inv:
  assumes "(WHILE b DO c, s) \<Rightarrow> t"
    and "\<And>s t. (c, s) \<Rightarrow> t \<Longrightarrow> bval b s \<Longrightarrow> Inv s \<Longrightarrow> Inv t"
    and "Inv s"
  shows "\<not>bval b t \<and> Inv t"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{15 marks}\<close>

text \<open>The basic arithmetic expression language @{typ aexp} in our IMP language only supports
  addition, but we can still write programs that perform other arithmetic operations.

  Write a program that subtracts the value of variable 1 from the value of variable 0 and stores
  the result in variable 2:\<close>

definition minus_com :: com where
  "minus_com \<equiv> undefined"

text \<open>You may use all commands of the IMP language including WHILE and IF commands,
  as well as additional variables.\<close>

text \<open>Prove your program correct:\<close>

lemma
  "(minus_com, s) \<Rightarrow> t  \<Longrightarrow>  t 2 = s 0 - s 1"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{3 marks}\<close>

text \<open>Now consider the following expression language that extends @{typ aexp} with subtraction and
  multiplication:\<close>

datatype aexp2 =
    N2 int
  | V2 vname
  | Plus2 aexp2 aexp2
  | Minus2 aexp2 aexp2
  | Mult2 aexp2 aexp2

text \<open>Write an evaluation function and a function determining the variables appearing in an
  expression:\<close>

fun aval2 :: "aexp2 \<Rightarrow> state \<Rightarrow> int" where
  "aval2 e s = undefined"

fun avars2 :: "aexp2 \<Rightarrow> vname set" where
  "avars2 e = undefined"

text \<open>Show the following congruence lemma, stating that evaluating an @{typ aexp2} expression in
  two states agreeing on the values of variables appearing in the expression gives the same result,
  i.e. the value of an expression does not depend on variables that don't appear in it:\<close>

lemma aval2_cong:
  "(\<forall>v. v \<in> avars2 e \<longrightarrow> s v = t v)  \<Longrightarrow>  aval2 e s = aval2 e t"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{10 marks}\<close>

text \<open>Write a compiler \<open>com_of_aexp2\<close> from an @{typ aexp2} expression to a program
  in the original IMP language (possibly using loops and conditionals for evaluating
  sub-expressions not supported there, as well as additional variables for intermediate values),
  where the program \<open>com_of_aexp2 res e\<close> writes the result of evaluating \<open>e\<close> to variable \<open>res\<close>:\<close>

fun com_of_aexp2 :: "vname \<Rightarrow> aexp2 \<Rightarrow> com" where
  "com_of_aexp2 res e = undefined"

text \<open>Test your compiler using some example expressions.

  Explain informally in your write-up how, why, and under what conditions the compiler works.\<close>

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{18 marks}\<close>

text \<open>Prove (partial) correctness of the programs generated by @{term com_of_aexp2}.  You may add
  assumptions to the lemma capturing the conditions under which your compiler works, as explained
  above.\<close>

lemma com_of_aexp2_correct:
  "(com_of_aexp2 res e, s) \<Rightarrow> t  \<Longrightarrow>  t res = aval2 e s"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{20 marks (advanced)}\<close>

text \<open>Prove the termination (and therefore total correctness) of programs generated by
  @{term com_of_aexp2} (again possibly adding assumptions as in the previous task):\<close>

lemma com_of_aexp2_terminates:
  "\<exists>t. (com_of_aexp2 res e, s) \<Rightarrow> t"
  sorry

lemma com_of_aexp2_correct_total:
  "\<exists>t. (com_of_aexp2 res e, s) \<Rightarrow> t \<and> t res = aval2 e s"
  sorry

text_raw \<open>\EndTask\<close>

(*<*)
end
(*>*)
