/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class KeyEventDemo
extends JFrame
implements KeyListener,
ActionListener {
    JTextArea displayArea;
    JTextField typingArea;
    static final String newline = System.getProperty("line.separator");

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyEventDemo.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        KeyEventDemo frame = new KeyEventDemo("KeyEventDemo");
        frame.setDefaultCloseOperation(3);
        frame.addComponentsToPane();
        frame.pack();
        frame.setVisible(true);
    }

    private void addComponentsToPane() {
        JButton button = new JButton("Clear");
        button.addActionListener(this);
        this.typingArea = new JTextField(20);
        this.typingArea.addKeyListener(this);
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.displayArea);
        scrollPane.setPreferredSize(new Dimension(375, 125));
        this.getContentPane().add((Component)this.typingArea, "First");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)button, "Last");
    }

    public KeyEventDemo(String name) {
        super(name);
    }

    public void keyTyped(KeyEvent e) {
        this.displayInfo(e, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent e) {
        this.displayInfo(e, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent e) {
        this.displayInfo(e, "KEY RELEASED: ");
    }

    public void actionPerformed(ActionEvent e) {
        this.displayArea.setText("");
        this.typingArea.setText("");
        this.typingArea.requestFocusInWindow();
    }

    private void displayInfo(KeyEvent e, String keyStatus) {
        String keyString;
        int id = e.getID();
        if (id == 400) {
            char c = e.getKeyChar();
            keyString = "key character = '" + c + "'";
        } else {
            int keyCode = e.getKeyCode();
            keyString = "key code = " + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ")";
        }
        int modifiersEx = e.getModifiersEx();
        String modString = "extended modifiers = " + modifiersEx;
        String tmpString = KeyEvent.getModifiersExText(modifiersEx);
        modString = tmpString.length() > 0 ? String.valueOf(modString) + " (" + tmpString + ")" : String.valueOf(modString) + " (no extended modifiers)";
        String actionString = "action key? ";
        actionString = e.isActionKey() ? String.valueOf(actionString) + "YES" : String.valueOf(actionString) + "NO";
        String locationString = "key location: ";
        int location = e.getKeyLocation();
        locationString = location == 1 ? String.valueOf(locationString) + "standard" : (location == 2 ? String.valueOf(locationString) + "left" : (location == 3 ? String.valueOf(locationString) + "right" : (location == 4 ? String.valueOf(locationString) + "numpad" : String.valueOf(locationString) + "unknown")));
        this.displayArea.append(String.valueOf(keyStatus) + newline + "    " + keyString + newline + "    " + modString + newline + "    " + actionString + newline + "    " + locationString + newline);
        this.displayArea.setCaretPosition(this.displayArea.getDocument().getLength());
    }
}

