/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.JCheckBox;
import tdg.corpora.MstSentenceUlab;
import tdg.corpora.MstSentenceUlabAdvanced;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepTreePanel
extends TreePanel<MstSentenceUlabAdvanced> {
    MstSentenceUlabAdvanced sentence;
    int[] XLeftWordArray;
    int[] XLeftPosArray;
    int[] YArray;
    int[] XMiddleWordArray;
    int[] posWordLengthArray;
    Integer[] wrongNodes;
    public JCheckBox skewedLinesCheckBox;
    public static int wrongNodesBorder = 2;

    public DepTreePanel() {
        this.levelSizeFactor = 3;
    }

    public DepTreePanel(ArrayList<MstSentenceUlabAdvanced> treebank) {
        this.loadTreebank(treebank);
    }

    @Override
    public void loadTreebank(ArrayList<MstSentenceUlabAdvanced> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
    }

    public void setWrongNodes(Integer[] wrongNodes) {
        this.wrongNodes = wrongNodes;
    }

    public MstSentenceUlab getSentence(int n) {
        return (MstSentenceUlab)this.treebank.get(n);
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setStroke(new BasicStroke());
        this.drawWordsAndArrows(g2);
        this.drawWrongNodesBoxes(g2);
        this.drawCrossingIndexes(g2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    private void drawWordsAndArrows(Graphics2D g2) {
        int i = 0;
        while (i < this.sentence.length) {
            if (this.sentence.loopIndexes.get(i)) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.black);
            }
            g2.drawString(this.sentence.postags[i], this.XLeftPosArray[i], this.YArray[i]);
            g2.drawString(this.sentence.words[i], this.XLeftWordArray[i], this.YArray[i] + this.fontHight);
            g2.setColor(Color.black);
            int pIndex = this.sentence.indexes[i];
            if (pIndex != 0) {
                --pIndex;
                if (!this.sentence.loopIndexes.get(i)) {
                    this.drawLine(this.XMiddleWordArray[pIndex], this.YArray[pIndex] + this.textTopMargin + this.fontHight, this.XMiddleWordArray[i], this.YArray[i] - this.fontHight - this.textTopMargin, g2);
                }
            }
            ++i;
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        if (!this.skewedLinesCheckBox.isSelected()) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    private void drawWrongNodesBoxes(Graphics2D g2) {
        if (this.wrongNodes == null) {
            return;
        }
        g2.setColor(Color.red);
        Integer[] integerArray = this.wrongNodes;
        int n = this.wrongNodes.length;
        int n2 = 0;
        while (n2 < n) {
            int w = integerArray[n2];
            g2.drawRect(Math.min(this.XLeftPosArray[w], this.XLeftWordArray[w]), this.YArray[w] - this.fontHight + wrongNodesBorder, this.posWordLengthArray[w], this.doubleFontHight);
            ++n2;
        }
        g2.setColor(Color.black);
    }

    private void drawCrossingIndexes(Graphics2D g2) {
        g2.setColor(Color.red);
        int i = 0;
        while (i < this.sentence.length) {
            int n;
            BitSet iBs = this.sentence.constituents[i];
            int p = -1;
            while ((n = iBs.nextSetBit(p + 1)) != -1) {
                if (p != -1 && n != p + 1) {
                    g2.drawLine(this.XMiddleWordArray[p], this.YArray[p], this.XMiddleWordArray[n], this.YArray[n]);
                }
                p = n;
            }
            ++i;
        }
        g2.setColor(Color.black);
    }

    @Override
    public void loadSentence() {
        this.sentence = (MstSentenceUlabAdvanced)this.treebank.get(this.sentenceNumber);
        this.XLeftWordArray = new int[this.sentence.length];
        this.XLeftPosArray = new int[this.sentence.length];
        this.XMiddleWordArray = new int[this.sentence.length];
        this.YArray = new int[this.sentence.length];
        this.posWordLengthArray = new int[this.sentence.length];
        int treeWidth = 0;
        int treeHeight = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int i = 0;
        while (i < this.sentence.length) {
            int posWordLength;
            int wordLength = this.metrics.stringWidth(this.sentence.words[i]);
            int posLength = this.metrics.stringWidth(this.sentence.postags[i]);
            this.posWordLengthArray[i] = posWordLength = Math.max(wordLength, posLength);
            this.XMiddleWordArray[i] = posWordLength / 2 + previousXLeft + previousWordLength + this.wordSpace;
            this.XLeftWordArray[i] = this.XMiddleWordArray[i] - wordLength / 2;
            this.XLeftPosArray[i] = this.XMiddleWordArray[i] - posLength / 2;
            this.YArray[i] = this.topMargin + this.fontHight + this.sentence.depths[i] * this.levelSize;
            if (this.YArray[i] > treeHeight) {
                treeHeight = this.YArray[i];
            }
            previousWordLength = posWordLength;
            previousXLeft = this.XLeftWordArray[i];
            if (i == this.sentence.length - 1) {
                treeWidth = previousXLeft + previousWordLength + this.wordSpace + posWordLength;
            }
            ++i;
        }
        this.area.width = treeWidth += this.leftMargin + this.rightMargin;
        this.area.height = treeHeight += this.bottomMargin;
    }

    public void exportOddsToPdf(File loopFile, File nonProjectiveFile, File corpusFile) {
        int currentSentence = this.sentenceNumber;
        Color bgColor = new Color(255, 222, 173);
        try {
            Document lDocument = new Document();
            Document npDocument = new Document();
            PdfWriter lWriter = PdfWriter.getInstance(lDocument, new FileOutputStream(loopFile));
            PdfWriter npWriter = PdfWriter.getInstance(npDocument, new FileOutputStream(nonProjectiveFile));
            lDocument.open();
            npDocument.open();
            PdfContentByte cbL = lWriter.getDirectContent();
            PdfContentByte cbNP = npWriter.getDirectContent();
            Chunk loopSentenceLabel = new Chunk("Sentences with loops, in file " + corpusFile.getName());
            Chunk npSentenceLabel = new Chunk("Sentences with non-projectivity, in file " + corpusFile.getName());
            lDocument.add(loopSentenceLabel);
            npDocument.add(npSentenceLabel);
            this.sentenceNumber = 0;
            while (this.sentenceNumber < this.treebank.size()) {
                this.loadSentence();
                boolean loops = this.sentence.hasLoops;
                boolean projective = this.sentence.isProjective();
                if (loops || !projective) {
                    Graphics2D g2;
                    Rectangle r = new Rectangle((int)this.area.getWidth(), (int)this.area.getHeight());
                    Chunk sentenceLabel = new Chunk("Sentence # " + (this.sentenceNumber + 1));
                    sentenceLabel.setBackground(bgColor);
                    if (loops) {
                        lDocument.setPageSize(r);
                        lDocument.newPage();
                        lDocument.add(sentenceLabel);
                        g2 = cbL.createGraphics((int)this.area.getWidth(), (int)this.area.getHeight());
                        this.render(g2);
                        g2.dispose();
                    }
                    if (!projective) {
                        npDocument.setPageSize(r);
                        npDocument.newPage();
                        npDocument.add(sentenceLabel);
                        g2 = cbNP.createGraphics((int)this.area.getWidth(), (int)this.area.getHeight());
                        this.render(g2);
                        g2.dispose();
                    }
                }
                ++this.sentenceNumber;
            }
            lDocument.close();
            npDocument.close();
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        this.sentenceNumber = currentSentence;
    }
}

